/*
 * Decompiled with CFR 0.152.
 */
package de.myzelyam.supervanish.hooks;

import de.myzelyam.api.vanish.PlayerHideEvent;
import de.myzelyam.api.vanish.PlayerShowEvent;
import de.myzelyam.supervanish.SuperVanish;
import de.myzelyam.supervanish.hooks.PluginHook;
import me.kvq.plugin.trails.API.SuperTrailsAPI;
import org.bukkit.Bukkit;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.EventPriority;
import org.bukkit.event.player.PlayerJoinEvent;
import org.bukkit.event.player.PlayerQuitEvent;
import org.bukkit.plugin.Plugin;

public class SuperTrailsHook
extends PluginHook {
    public SuperTrailsHook(SuperVanish superVanish) {
        super(superVanish);
    }

    @Override
    public void onPluginEnable(Plugin plugin) {
        for (Player p : Bukkit.getOnlinePlayers()) {
            if (!this.superVanish.getVanishStateMgr().isVanished(p.getUniqueId())) continue;
            SuperTrailsAPI.HideTrailFor((Player)p, (Boolean)true);
        }
    }

    @EventHandler(priority=EventPriority.MONITOR, ignoreCancelled=true)
    public void onVanish(PlayerHideEvent e) {
        SuperTrailsAPI.HideTrailFor((Player)e.getPlayer(), (Boolean)true);
    }

    @EventHandler(priority=EventPriority.MONITOR, ignoreCancelled=true)
    public void onReappear(PlayerShowEvent e) {
        SuperTrailsAPI.HideTrailFor((Player)e.getPlayer(), (Boolean)false);
    }

    @EventHandler(priority=EventPriority.MONITOR)
    public void onJoin(PlayerJoinEvent e) {
        if (!this.superVanish.getVanishStateMgr().isVanished(e.getPlayer().getUniqueId())) {
            return;
        }
        SuperTrailsAPI.HideTrailFor((Player)e.getPlayer(), (Boolean)true);
    }

    @EventHandler(priority=EventPriority.MONITOR)
    public void onQuit(PlayerQuitEvent e) {
        if (!this.superVanish.getVanishStateMgr().isVanished(e.getPlayer().getUniqueId())) {
            return;
        }
        SuperTrailsAPI.HideTrailFor((Player)e.getPlayer(), (Boolean)false);
    }
}

