/*
 * Decompiled with CFR 0.152.
 */
package de.myzelyam.supervanish.hooks;

import com.earth2me.essentials.Essentials;
import com.earth2me.essentials.User;
import de.myzelyam.api.vanish.PlayerHideEvent;
import de.myzelyam.api.vanish.PostPlayerShowEvent;
import de.myzelyam.supervanish.SuperVanish;
import de.myzelyam.supervanish.commands.CommandAction;
import de.myzelyam.supervanish.hooks.PluginHook;
import java.util.HashSet;
import java.util.Locale;
import java.util.Set;
import java.util.UUID;
import org.bukkit.Bukkit;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.EventPriority;
import org.bukkit.event.player.PlayerCommandPreprocessEvent;
import org.bukkit.event.player.PlayerJoinEvent;
import org.bukkit.plugin.Plugin;
import org.bukkit.scheduler.BukkitRunnable;
import org.bukkit.scheduler.BukkitTask;

public class EssentialsHook
extends PluginHook {
    private final Set<UUID> preVanishHiddenPlayers = new HashSet<UUID>();
    private Essentials essentials;
    private BukkitRunnable forcedInvisibilityRunnable = new BukkitRunnable(){

        public void run() {
            try {
                if (!Bukkit.getPluginManager().isPluginEnabled("Essentials")) {
                    return;
                }
                for (UUID uuid : EssentialsHook.this.superVanish.getVanishStateMgr().getOnlineVanishedPlayers()) {
                    Player p = Bukkit.getPlayer((UUID)uuid);
                    User user = EssentialsHook.this.essentials.getUser(p);
                    if (user == null || user.isHidden()) continue;
                    user.setHidden(true);
                }
            }
            catch (Exception e) {
                this.cancel();
                EssentialsHook.this.superVanish.logException(e);
            }
        }
    };
    private BukkitTask forcedInvisibilityTask;

    public EssentialsHook(SuperVanish superVanish) {
        super(superVanish);
    }

    @Override
    public void onPluginEnable(Plugin plugin) {
        this.essentials = (Essentials)plugin;
        this.forcedInvisibilityTask = this.forcedInvisibilityRunnable.runTaskTimer((Plugin)this.superVanish, 0L, 100L);
        this.forcedInvisibilityRunnable.run();
    }

    @Override
    public void onPluginDisable(Plugin plugin) {
        this.essentials = null;
        this.forcedInvisibilityTask.cancel();
    }

    @EventHandler(priority=EventPriority.LOW)
    public void onJoin(PlayerJoinEvent e) {
        User user = this.essentials.getUser(e.getPlayer());
        if (user == null) {
            return;
        }
        if (this.superVanish.getVanishStateMgr().isVanished(e.getPlayer().getUniqueId()) && !user.isHidden()) {
            user.setHidden(true);
        } else {
            user.setHidden(false);
        }
    }

    @EventHandler(priority=EventPriority.MONITOR, ignoreCancelled=true)
    public void onVanish(PlayerHideEvent e) {
        User user = this.essentials.getUser(e.getPlayer());
        if (user == null) {
            return;
        }
        if (user.isVanished()) {
            user.setVanished(false);
        }
        this.preVanishHiddenPlayers.remove(e.getPlayer().getUniqueId());
        user.setHidden(true);
    }

    @EventHandler
    public void onReappear(PostPlayerShowEvent e) {
        User user = this.essentials.getUser(e.getPlayer());
        if (user == null) {
            return;
        }
        user.setHidden(false);
    }

    @EventHandler(priority=EventPriority.HIGHEST, ignoreCancelled=true)
    public void onCommand(final PlayerCommandPreprocessEvent e) {
        if (!CommandAction.VANISH_SELF.checkPermission((CommandSender)e.getPlayer(), this.superVanish)) {
            return;
        }
        if (this.superVanish.getVanishStateMgr().isVanished(e.getPlayer().getUniqueId())) {
            return;
        }
        String command = e.getMessage().toLowerCase(Locale.ENGLISH).split(" ")[0].replace("/", "").toLowerCase(Locale.ENGLISH);
        if (command.split(":").length > 1) {
            command = command.split(":")[1];
        }
        if (command.equals("supervanish") || command.equals("sv") || command.equals("v") || command.equals("vanish")) {
            final User user = this.essentials.getUser(e.getPlayer());
            if (user == null || !user.isAfk()) {
                return;
            }
            user.setHidden(true);
            this.preVanishHiddenPlayers.add(e.getPlayer().getUniqueId());
            this.superVanish.getServer().getScheduler().runTaskLater((Plugin)this.superVanish, new Runnable(){

                @Override
                public void run() {
                    if (EssentialsHook.this.preVanishHiddenPlayers.remove(e.getPlayer().getUniqueId())) {
                        user.setHidden(false);
                    }
                }
            }, 1L);
        }
    }
}

