/*
 * Decompiled with CFR 0.152.
 */
package de.myzelyam.supervanish.features;

import de.myzelyam.api.vanish.PlayerHideEvent;
import de.myzelyam.api.vanish.PlayerShowEvent;
import de.myzelyam.supervanish.SuperVanish;
import de.myzelyam.supervanish.features.Feature;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.EventPriority;
import org.bukkit.event.player.PlayerJoinEvent;
import org.bukkit.event.player.PlayerQuitEvent;
import org.bukkit.plugin.Plugin;
import org.bukkit.scheduler.BukkitRunnable;
import org.bukkit.scoreboard.Team;

public class NoPush
extends Feature {
    public NoPush(SuperVanish plugin) {
        super(plugin);
    }

    @Override
    public boolean isActive() {
        return this.plugin.getSettings().getBoolean("InvisibilityFeatures.DisablePush");
    }

    public void setCantPush(Player p) {
        Team team = p.getScoreboard().getTeam("Vanished");
        if (team == null) {
            team = p.getScoreboard().registerNewTeam("Vanished");
        }
        try {
            team.setOption(Team.Option.COLLISION_RULE, Team.OptionStatus.NEVER);
            team.addEntry(p.getName());
        }
        catch (NoClassDefFoundError | NoSuchMethodError linkageError) {
            // empty catch block
        }
    }

    public void setCanPush(Player p) {
        Team team = p.getScoreboard().getTeam("Vanished");
        if (team != null) {
            team.removeEntry(p.getName());
        }
    }

    @EventHandler(priority=EventPriority.MONITOR, ignoreCancelled=true)
    public void onVanish(PlayerHideEvent e) {
        this.setCantPush(e.getPlayer());
    }

    @EventHandler(priority=EventPriority.MONITOR, ignoreCancelled=true)
    public void onReappear(PlayerShowEvent e) {
        this.setCanPush(e.getPlayer());
    }

    @EventHandler
    public void onJoin(final PlayerJoinEvent e) {
        if (this.plugin.getVanishStateMgr().isVanished(e.getPlayer().getUniqueId())) {
            new BukkitRunnable(){

                public void run() {
                    NoPush.this.setCantPush(e.getPlayer());
                }
            }.runTaskLater((Plugin)this.plugin, 5L);
        }
    }

    @EventHandler
    public void onQuit(PlayerQuitEvent e) {
        this.setCanPush(e.getPlayer());
    }
}

