/*
 * Decompiled with CFR 0.152.
 */
package de.myzelyam.supervanish.events;

import de.myzelyam.supervanish.SuperVanish;
import de.myzelyam.supervanish.commands.CommandAction;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.EventPriority;
import org.bukkit.event.Listener;
import org.bukkit.event.player.PlayerChangedWorldEvent;

public class WorldChangeEvent
implements Listener {
    private final SuperVanish plugin;

    public WorldChangeEvent(SuperVanish plugin) {
        this.plugin = plugin;
    }

    @EventHandler(priority=EventPriority.MONITOR)
    public void onWorldChange(PlayerChangedWorldEvent e) {
        try {
            Player p = e.getPlayer();
            if (!this.plugin.getVanishStateMgr().isVanished(p.getUniqueId())) {
                return;
            }
            if (this.plugin.getSettings().getBoolean("VanishStateFeatures.ReappearOnWorldChange") || this.plugin.getSettings().getBoolean("VanishStateFeatures.CheckPermissionOnWorldChange") && !CommandAction.VANISH_SELF.checkPermission((CommandSender)p, this.plugin)) {
                this.plugin.getVisibilityChanger().showPlayer(p);
            }
        }
        catch (Exception er) {
            this.plugin.logException(er);
        }
    }
}

