/*
 * Decompiled with CFR 0.152.
 */
package de.myzelyam.supervanish.config;

import de.myzelyam.supervanish.SuperVanish;
import de.myzelyam.supervanish.config.ConfigurableFile;
import de.myzelyam.supervanish.config.FileMgr;
import de.myzelyam.supervanish.config.StorageFile;
import java.util.Collections;
import java.util.logging.Level;
import org.bukkit.Bukkit;
import org.bukkit.ChatColor;
import org.bukkit.configuration.file.FileConfiguration;

public class ConfigMgr {
    private final SuperVanish plugin;
    private final FileMgr fileMgr;
    private boolean settingsUpdateRequired;
    private boolean messagesUpdateRequired;
    private FileConfiguration settings;
    private FileConfiguration messages;
    private FileConfiguration playerData;
    private ConfigurableFile messagesFile;
    private ConfigurableFile settingsFile;
    private StorageFile playerDataFile;

    public ConfigMgr(SuperVanish plugin) {
        this.plugin = plugin;
        this.fileMgr = new FileMgr(plugin);
    }

    public void prepareFiles() {
        this.messagesFile = (ConfigurableFile)this.fileMgr.addFile("messages", FileMgr.FileType.CONFIG);
        this.messages = this.messagesFile.getConfig();
        this.settingsFile = (ConfigurableFile)this.fileMgr.addFile("config", FileMgr.FileType.CONFIG);
        this.settings = this.settingsFile.getConfig();
        this.playerDataFile = (StorageFile)this.fileMgr.addFile("data", FileMgr.FileType.STORAGE);
        this.playerData = this.playerDataFile.getConfig();
        this.playerData.addDefault("InvisiblePlayers", Collections.emptyList());
        this.playerData.options().copyDefaults(true);
        this.playerData.options().header("SuperVanish v" + this.plugin.getDescription().getVersion() + " - Data file");
        this.playerDataFile.save();
        this.checkFilesForLeftOvers();
    }

    public void checkFilesForLeftOvers() {
        try {
            String currentSettingsVersion = this.settings.getString("ConfigVersion");
            String newestVersion = this.plugin.getDescription().getVersion();
            String currentMessagesVersion = this.messages.getString("MessagesVersion");
            this.messagesUpdateRequired = this.fileRequiresRecreation(currentMessagesVersion, false);
            this.settingsUpdateRequired = this.fileRequiresRecreation(currentSettingsVersion, true);
            if (newestVersion.equals(currentSettingsVersion)) {
                this.settingsUpdateRequired = false;
            }
            if (newestVersion.equals(currentMessagesVersion)) {
                this.messagesUpdateRequired = false;
            }
            if (this.settingsUpdateRequired || this.messagesUpdateRequired) {
                String currentVersion = this.plugin.getDescription().getVersion();
                boolean isDismissed = this.playerData.getBoolean("PlayerData.CONSOLE.dismissed." + currentVersion.replace(".", "_"), false);
                if (!isDismissed) {
                    this.plugin.log(Level.WARNING, "At least one config file is outdated, it's recommended to regenerate it using '/sv recreatefiles'");
                }
            }
            if (currentSettingsVersion.startsWith("1.5.") || currentSettingsVersion.startsWith("1.4.")) {
                Bukkit.getConsoleSender().sendMessage(ChatColor.YELLOW + "You have a very outdated config file, your settings will not work until you regenerate your SV-files using /sv recreatefiles");
            }
        }
        catch (Exception e) {
            this.plugin.logException(e);
        }
    }

    private boolean fileRequiresRecreation(String currentVersion, boolean isSettingsFile) {
        if (currentVersion == null) {
            return true;
        }
        for (String ignoredVersion : isSettingsFile ? SuperVanish.NON_REQUIRED_SETTINGS_UPDATES : SuperVanish.NON_REQUIRED_MESSAGES_UPDATES) {
            if (!currentVersion.equalsIgnoreCase(ignoredVersion)) continue;
            return false;
        }
        return true;
    }

    public FileMgr getFileMgr() {
        return this.fileMgr;
    }

    public SuperVanish getPlugin() {
        return this.plugin;
    }

    public boolean isSettingsUpdateRequired() {
        return this.settingsUpdateRequired;
    }

    public boolean isMessagesUpdateRequired() {
        return this.messagesUpdateRequired;
    }

    public FileConfiguration getSettings() {
        return this.settings;
    }

    public FileConfiguration getMessages() {
        return this.messages;
    }

    public FileConfiguration getPlayerData() {
        return this.playerData;
    }

    public ConfigurableFile getMessagesFile() {
        return this.messagesFile;
    }

    public ConfigurableFile getSettingsFile() {
        return this.settingsFile;
    }

    public StorageFile getPlayerDataFile() {
        return this.playerDataFile;
    }

    public void setSettingsUpdateRequired(boolean settingsUpdateRequired) {
        this.settingsUpdateRequired = settingsUpdateRequired;
    }

    public void setMessagesUpdateRequired(boolean messagesUpdateRequired) {
        this.messagesUpdateRequired = messagesUpdateRequired;
    }

    public void setSettings(FileConfiguration settings) {
        this.settings = settings;
    }

    public void setMessages(FileConfiguration messages) {
        this.messages = messages;
    }

    public void setPlayerData(FileConfiguration playerData) {
        this.playerData = playerData;
    }

    public void setMessagesFile(ConfigurableFile messagesFile) {
        this.messagesFile = messagesFile;
    }

    public void setSettingsFile(ConfigurableFile settingsFile) {
        this.settingsFile = settingsFile;
    }

    public void setPlayerDataFile(StorageFile playerDataFile) {
        this.playerDataFile = playerDataFile;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof ConfigMgr)) {
            return false;
        }
        ConfigMgr other = (ConfigMgr)o;
        if (!other.canEqual(this)) {
            return false;
        }
        SuperVanish this$plugin = this.getPlugin();
        SuperVanish other$plugin = other.getPlugin();
        if (this$plugin == null ? other$plugin != null : !this$plugin.equals(other$plugin)) {
            return false;
        }
        FileMgr this$fileMgr = this.getFileMgr();
        FileMgr other$fileMgr = other.getFileMgr();
        if (this$fileMgr == null ? other$fileMgr != null : !this$fileMgr.equals(other$fileMgr)) {
            return false;
        }
        if (this.isSettingsUpdateRequired() != other.isSettingsUpdateRequired()) {
            return false;
        }
        if (this.isMessagesUpdateRequired() != other.isMessagesUpdateRequired()) {
            return false;
        }
        FileConfiguration this$settings = this.getSettings();
        FileConfiguration other$settings = other.getSettings();
        if (this$settings == null ? other$settings != null : !this$settings.equals(other$settings)) {
            return false;
        }
        FileConfiguration this$messages = this.getMessages();
        FileConfiguration other$messages = other.getMessages();
        if (this$messages == null ? other$messages != null : !this$messages.equals(other$messages)) {
            return false;
        }
        FileConfiguration this$playerData = this.getPlayerData();
        FileConfiguration other$playerData = other.getPlayerData();
        if (this$playerData == null ? other$playerData != null : !this$playerData.equals(other$playerData)) {
            return false;
        }
        ConfigurableFile this$messagesFile = this.getMessagesFile();
        ConfigurableFile other$messagesFile = other.getMessagesFile();
        if (this$messagesFile == null ? other$messagesFile != null : !this$messagesFile.equals(other$messagesFile)) {
            return false;
        }
        ConfigurableFile this$settingsFile = this.getSettingsFile();
        ConfigurableFile other$settingsFile = other.getSettingsFile();
        if (this$settingsFile == null ? other$settingsFile != null : !this$settingsFile.equals(other$settingsFile)) {
            return false;
        }
        StorageFile this$playerDataFile = this.getPlayerDataFile();
        StorageFile other$playerDataFile = other.getPlayerDataFile();
        return !(this$playerDataFile == null ? other$playerDataFile != null : !this$playerDataFile.equals(other$playerDataFile));
    }

    protected boolean canEqual(Object other) {
        return other instanceof ConfigMgr;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        SuperVanish $plugin = this.getPlugin();
        result = result * 59 + ($plugin == null ? 43 : $plugin.hashCode());
        FileMgr $fileMgr = this.getFileMgr();
        result = result * 59 + ($fileMgr == null ? 43 : $fileMgr.hashCode());
        result = result * 59 + (this.isSettingsUpdateRequired() ? 79 : 97);
        result = result * 59 + (this.isMessagesUpdateRequired() ? 79 : 97);
        FileConfiguration $settings = this.getSettings();
        result = result * 59 + ($settings == null ? 43 : $settings.hashCode());
        FileConfiguration $messages = this.getMessages();
        result = result * 59 + ($messages == null ? 43 : $messages.hashCode());
        FileConfiguration $playerData = this.getPlayerData();
        result = result * 59 + ($playerData == null ? 43 : $playerData.hashCode());
        ConfigurableFile $messagesFile = this.getMessagesFile();
        result = result * 59 + ($messagesFile == null ? 43 : $messagesFile.hashCode());
        ConfigurableFile $settingsFile = this.getSettingsFile();
        result = result * 59 + ($settingsFile == null ? 43 : $settingsFile.hashCode());
        StorageFile $playerDataFile = this.getPlayerDataFile();
        result = result * 59 + ($playerDataFile == null ? 43 : $playerDataFile.hashCode());
        return result;
    }

    public String toString() {
        return "ConfigMgr(plugin=" + this.getPlugin() + ", fileMgr=" + this.getFileMgr() + ", settingsUpdateRequired=" + this.isSettingsUpdateRequired() + ", messagesUpdateRequired=" + this.isMessagesUpdateRequired() + ", settings=" + this.getSettings() + ", messages=" + this.getMessages() + ", playerData=" + this.getPlayerData() + ", messagesFile=" + this.getMessagesFile() + ", settingsFile=" + this.getSettingsFile() + ", playerDataFile=" + this.getPlayerDataFile() + ")";
    }
}

