/*
 * Decompiled with CFR 0.152.
 */
package de.myzelyam.supervanish;

import de.myzelyam.supervanish.SuperVanish;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;

public class VanishPlayer {
    private final SuperVanish plugin;
    private Player player;
    private boolean itemPickUps;
    private int seePermissionLevel;
    private int usePermissionLevel;

    VanishPlayer(Player player, SuperVanish plugin, boolean itemPickUps) {
        this.plugin = plugin;
        this.player = player;
        this.itemPickUps = itemPickUps;
        if (plugin.getSettings().getBoolean("IndicationFeatures.LayeredPermissions.LayeredSeeAndUsePermissions", false)) {
            this.seePermissionLevel = plugin.getLayeredPermissionLevel((CommandSender)player, "see");
            this.usePermissionLevel = plugin.getLayeredPermissionLevel((CommandSender)player, "use");
        }
    }

    public boolean isOnlineVanished() {
        return this.plugin.getVanishStateMgr().isVanished(this.player.getUniqueId());
    }

    public boolean hasItemPickUpsEnabled() {
        return this.itemPickUps;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        VanishPlayer that = (VanishPlayer)o;
        return this.player != null ? this.player.getUniqueId().equals(that.player.getUniqueId()) : that.player == null;
    }

    public int hashCode() {
        return this.player != null ? this.player.getUniqueId().hashCode() : 0;
    }

    public Player getPlayer() {
        return this.player;
    }

    public void setItemPickUps(boolean itemPickUps) {
        this.itemPickUps = itemPickUps;
    }

    public int getSeePermissionLevel() {
        return this.seePermissionLevel;
    }

    public int getUsePermissionLevel() {
        return this.usePermissionLevel;
    }
}

