/*
 * Decompiled with CFR 0.152.
 */
package de.myzelyam.supervanish;

import com.comphenix.protocol.ProtocolLibrary;
import de.myzelyam.api.vanish.VanishAPI;
import de.myzelyam.supervanish.LayeredPermissionChecker;
import de.myzelyam.supervanish.PlaceholderConverter;
import de.myzelyam.supervanish.SuperVanishPlugin;
import de.myzelyam.supervanish.VanishPlayer;
import de.myzelyam.supervanish.commands.VanishCommand;
import de.myzelyam.supervanish.config.ConfigMgr;
import de.myzelyam.supervanish.events.GeneralEventHandler;
import de.myzelyam.supervanish.events.JoinEvent;
import de.myzelyam.supervanish.events.LoginEvent;
import de.myzelyam.supervanish.events.PlayerBlockModifyEventHandler;
import de.myzelyam.supervanish.events.QuitEvent;
import de.myzelyam.supervanish.events.WorldChangeEvent;
import de.myzelyam.supervanish.features.FeatureMgr;
import de.myzelyam.supervanish.hooks.PluginHookMgr;
import de.myzelyam.supervanish.net.UpdateNotifier;
import de.myzelyam.supervanish.utils.ExceptionLogger;
import de.myzelyam.supervanish.utils.VersionUtil;
import de.myzelyam.supervanish.visibility.ActionBarMgr;
import de.myzelyam.supervanish.visibility.FileVanishStateMgr;
import de.myzelyam.supervanish.visibility.ServerListPacketListener;
import de.myzelyam.supervanish.visibility.VisibilityChanger;
import de.myzelyam.supervanish.visibility.hiders.PreventionHider;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.logging.Level;
import org.bukkit.Bukkit;
import org.bukkit.command.Command;
import org.bukkit.command.CommandSender;
import org.bukkit.configuration.file.FileConfiguration;
import org.bukkit.entity.Player;
import org.bukkit.event.Event;
import org.bukkit.event.EventPriority;
import org.bukkit.event.HandlerList;
import org.bukkit.event.Listener;
import org.bukkit.event.player.PlayerJoinEvent;
import org.bukkit.event.player.PlayerQuitEvent;
import org.bukkit.plugin.EventExecutor;
import org.bukkit.plugin.Plugin;
import org.bukkit.plugin.PluginManager;
import org.bukkit.plugin.java.JavaPlugin;

public class SuperVanish
extends JavaPlugin
implements SuperVanishPlugin {
    public static final String[] NON_REQUIRED_SETTINGS_UPDATES = new String[]{"6.0.0", "6.0.1", "6.0.2", "6.0.3", "6.0.4", "6.0.5", "6.1.0", "6.1.1", "6.1.2", "6.1.3", "6.1.4", "6.1.5", "6.1.6", "6.1.7", "6.1.8", "6.2.0"};
    public static final String[] NON_REQUIRED_MESSAGES_UPDATES = new String[]{"6.0.0", "6.0.1", "6.0.2", "6.0.3", "6.0.4", "6.0.5", "6.1.0", "6.1.1", "6.1.2", "6.1.3", "6.1.4", "6.1.5", "6.1.6", "6.1.7", "6.1.8", "6.2.0"};
    private boolean useProtocolLib;
    private ActionBarMgr actionBarMgr;
    private FileVanishStateMgr vanishStateMgr;
    private VersionUtil versionUtil;
    private ConfigMgr configMgr;
    private FeatureMgr featureMgr;
    private PlaceholderConverter placeholderConverter;
    private VanishCommand command;
    private VisibilityChanger visibilityChanger;
    private UpdateNotifier updateNotifier;
    private LoginEvent loginEvent;
    private LayeredPermissionChecker layeredPermissionChecker;
    private Set<VanishPlayer> vanishPlayers = new HashSet<VanishPlayer>();

    public void onEnable() {
        try {
            this.useProtocolLib = this.getServer().getPluginManager().isPluginEnabled("ProtocolLib");
            if (!this.useProtocolLib) {
                this.log(Level.INFO, "Please install ProtocolLib to be able to use all SuperVanish features: https://www.spigotmc.org/resources/protocollib.1997/");
            }
            this.configMgr = new ConfigMgr(this);
            this.configMgr.prepareFiles();
            this.placeholderConverter = new PlaceholderConverter(this);
            this.layeredPermissionChecker = new LayeredPermissionChecker(this);
            this.command = new VanishCommand(this);
            this.versionUtil = new VersionUtil(this);
            this.vanishStateMgr = new FileVanishStateMgr(this);
            if (this.getSettings().getBoolean("MiscellaneousOptions.UpdateChecker.Enable", true)) {
                this.updateNotifier = new UpdateNotifier(this);
            }
            this.visibilityChanger = new VisibilityChanger(new PreventionHider(this), this);
            if (this.versionUtil.isOneDotXOrHigher(8) && this.useProtocolLib) {
                this.actionBarMgr = new ActionBarMgr(this);
            }
            if (this.useProtocolLib && ServerListPacketListener.isEnabled(this)) {
                ServerListPacketListener.register(this);
            }
            this.registerEvents();
            new PluginHookMgr(this);
            this.featureMgr = new FeatureMgr(this);
            this.featureMgr.enableFeatures();
            if (!Bukkit.getOnlinePlayers().isEmpty()) {
                this.onReload();
            }
        }
        catch (Exception e) {
            this.logException(e);
        }
        try {
            VanishAPI.setPlugin(this);
        }
        catch (NoSuchMethodError noSuchMethodError) {
            // empty catch block
        }
    }

    public void onDisable() {
        block4: {
            try {
                if (this.featureMgr != null) {
                    this.featureMgr.disableFeatures();
                }
                this.vanishPlayers.clear();
                VanishAPI.setPlugin(null);
            }
            catch (Throwable e) {
                if (e instanceof ThreadDeath || e instanceof VirtualMachineError) {
                    throw e;
                }
                if (e instanceof NoClassDefFoundError | e instanceof NoSuchMethodError) break block4;
                e.printStackTrace();
            }
        }
    }

    private void onReload() {
        for (Player player : Bukkit.getOnlinePlayers()) {
            boolean itemPickUps = this.getPlayerData().getBoolean("PlayerData." + player.getUniqueId() + ".itemPickUps", this.getSettings().getBoolean("InvisibilityFeatures.DefaultPickUpItemsOption"));
            boolean vanished = this.vanishStateMgr.isVanished(player.getUniqueId());
            this.createVanishPlayer(player, itemPickUps);
            if (vanished) {
                for (Player onlinePlayer : Bukkit.getOnlinePlayers()) {
                    if (this.hasPermissionToSee(onlinePlayer, player)) continue;
                    this.visibilityChanger.getHider().setHidden(player, onlinePlayer, true);
                }
            }
            if (!this.getSettings().getBoolean("MessageOptions.DisplayActionBar") || !vanished || this.actionBarMgr == null) continue;
            this.actionBarMgr.addActionBar(player);
        }
    }

    public void reload() {
        this.getServer().getScheduler().cancelTasks((Plugin)this);
        HandlerList.unregisterAll((Plugin)this);
        if (this.useProtocolLib) {
            ProtocolLibrary.getProtocolManager().removePacketListeners((Plugin)this);
        }
        this.onDisable();
        this.onEnable();
    }

    public List<String> onTabComplete(CommandSender sender, Command command, String alias, String[] args) {
        return this.command.tabComplete(command, sender, alias, args);
    }

    public boolean onCommand(CommandSender sender, Command command, String label, String[] args) {
        this.command.execute(command, sender, label, args);
        return true;
    }

    private void registerEvents() {
        PluginManager pluginManager = this.getServer().getPluginManager();
        pluginManager.registerEvents((Listener)new GeneralEventHandler(this), (Plugin)this);
        pluginManager.registerEvents((Listener)new PlayerBlockModifyEventHandler(this), (Plugin)this);
        pluginManager.registerEvents((Listener)new WorldChangeEvent(this), (Plugin)this);
        this.loginEvent = new LoginEvent(this);
        pluginManager.registerEvents((Listener)this.loginEvent, (Plugin)this);
        JoinEvent joinEvent = new JoinEvent(this);
        pluginManager.registerEvent(PlayerJoinEvent.class, (Listener)joinEvent, this.getEventPriority(PlayerJoinEvent.class), (EventExecutor)joinEvent, (Plugin)this, false);
        QuitEvent quitEvent = new QuitEvent(this);
        pluginManager.registerEvent(PlayerQuitEvent.class, (Listener)quitEvent, this.getEventPriority(PlayerQuitEvent.class), (EventExecutor)quitEvent, (Plugin)this, false);
    }

    private EventPriority getEventPriority(Class<? extends Event> eventClass) {
        try {
            String eventName = eventClass.getSimpleName();
            String configString = this.getSettings().getString("CompatibilityOptions." + eventName + "Priority");
            if (configString == null) {
                return EventPriority.NORMAL;
            }
            EventPriority priority = EventPriority.valueOf((String)configString);
            return priority;
        }
        catch (Exception e) {
            this.logException(e);
            return EventPriority.NORMAL;
        }
    }

    public String replacePlaceholders(String msg, Object ... additionalPlayerInfo) {
        return this.placeholderConverter.replacePlaceholders(msg, additionalPlayerInfo);
    }

    public String getMessage(String path) {
        String message = this.getMessages().getString("Messages." + path);
        if (message == null) {
            message = this.configMgr.getMessagesFile().getDefaultConfig().getString("Messages." + path);
        }
        return message;
    }

    public VanishPlayer getVanishPlayer(Player player) {
        VanishPlayer vanishPlayer2;
        for (VanishPlayer vanishPlayer2 : this.vanishPlayers) {
            if (!vanishPlayer2.getPlayer().equals(player)) continue;
            return vanishPlayer2;
        }
        boolean itemPickUps = this.getPlayerData().getBoolean("PlayerData." + player.getUniqueId() + ".itemPickUps", this.getSettings().getBoolean("InvisibilityFeatures.DefaultPickUpItemsOption"));
        vanishPlayer2 = new VanishPlayer(player, this, itemPickUps);
        this.vanishPlayers.add(vanishPlayer2);
        return vanishPlayer2;
    }

    public void createVanishPlayer(Player player, boolean itemPickUps) {
        VanishPlayer vanishPlayer = new VanishPlayer(player, this, itemPickUps);
        this.vanishPlayers.add(vanishPlayer);
    }

    public void removeVanishPlayer(VanishPlayer vanishPlayer) {
        this.vanishPlayers.remove(vanishPlayer);
    }

    public void sendMessage(CommandSender p, String messagesYmlPath, Object ... additionalPlayerInfo) {
        String message = !messagesYmlPath.contains(" ") ? this.getMessage(messagesYmlPath) : messagesYmlPath;
        if (message.equalsIgnoreCase("") || messagesYmlPath.equalsIgnoreCase("")) {
            return;
        }
        message = this.replacePlaceholders(message, additionalPlayerInfo);
        p.sendMessage(message);
    }

    public boolean canSee(Player viewer, Player viewed) {
        return !this.visibilityChanger.getHider().isHidden(viewed, viewer);
    }

    public boolean hasPermissionToVanish(CommandSender sender) {
        return this.layeredPermissionChecker.hasPermissionToVanish(sender);
    }

    public boolean hasPermissionToSee(Player viewer, Player viewed) {
        return this.layeredPermissionChecker.hasPermissionToSee(viewer, viewed);
    }

    public int getLayeredPermissionLevel(CommandSender sender, String permission) {
        return this.layeredPermissionChecker.getLayeredPermissionLevel(sender, permission);
    }

    public FileConfiguration getSettings() {
        return this.configMgr.getSettings();
    }

    public FileConfiguration getMessages() {
        return this.configMgr.getMessages();
    }

    public FileConfiguration getPlayerData() {
        return this.configMgr.getPlayerData();
    }

    public FileConfiguration getConfig() {
        return this.getSettings();
    }

    @Override
    public void log(Level level, String msg) {
        this.getLogger().log(level, msg);
    }

    @Override
    public void log(Level level, String msg, Throwable ex) {
        this.getLogger().log(level, msg, ex);
    }

    @Override
    public void logException(Throwable e) {
        ExceptionLogger.logException(e, this);
    }

    public boolean isUseProtocolLib() {
        return this.useProtocolLib;
    }

    public ActionBarMgr getActionBarMgr() {
        return this.actionBarMgr;
    }

    @Override
    public FileVanishStateMgr getVanishStateMgr() {
        return this.vanishStateMgr;
    }

    public VersionUtil getVersionUtil() {
        return this.versionUtil;
    }

    public ConfigMgr getConfigMgr() {
        return this.configMgr;
    }

    public FeatureMgr getFeatureMgr() {
        return this.featureMgr;
    }

    public PlaceholderConverter getPlaceholderConverter() {
        return this.placeholderConverter;
    }

    public VanishCommand getCommand() {
        return this.command;
    }

    public VisibilityChanger getVisibilityChanger() {
        return this.visibilityChanger;
    }

    public UpdateNotifier getUpdateNotifier() {
        return this.updateNotifier;
    }

    public LoginEvent getLoginEvent() {
        return this.loginEvent;
    }

    public LayeredPermissionChecker getLayeredPermissionChecker() {
        return this.layeredPermissionChecker;
    }
}

