/*
 * Decompiled with CFR 0.152.
 */
package com.kunzisoft.switchdatetime.date.widget;

import android.content.Context;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.TextView;
import androidx.recyclerview.widget.RecyclerView;
import com.kunzisoft.switchdatetime.R;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.List;
import java.util.Locale;

class YearPickerAdapter
extends RecyclerView.Adapter<TextIndicatorViewHolder> {
    private static final int LIST_ITEM_TYPE_STANDARD = 0;
    private static final int LIST_ITEM_TYPE_INDICATOR = 1;
    public static final int UNDEFINED = -1;
    private SimpleDateFormat yearFormat;
    private Calendar calendar;
    private List<Integer> listYears = new ArrayList<Integer>();
    private Integer selectedYear = -1;
    private int positionSelectedYear;
    private OnClickYearListener onClickYearListener;

    YearPickerAdapter() {
        this.yearFormat = new SimpleDateFormat("yyyy", Locale.getDefault());
        this.calendar = Calendar.getInstance();
    }

    public long getItemId(int i) {
        return this.listYears.get(i).intValue();
    }

    public int getItemCount() {
        return this.listYears.size();
    }

    public TextIndicatorViewHolder onCreateViewHolder(ViewGroup parent, int viewType) {
        switch (viewType) {
            default: {
                return new TextIndicatorViewHolder(LayoutInflater.from((Context)parent.getContext()).inflate(R.layout.year_text, parent, false));
            }
            case 1: 
        }
        return new TextIndicatorViewHolder(LayoutInflater.from((Context)parent.getContext()).inflate(R.layout.year_text_indicator, parent, false));
    }

    public void onBindViewHolder(TextIndicatorViewHolder holder, int position) {
        Integer currentYear = this.listYears.get(position);
        this.calendar.set(1, currentYear);
        holder.textView.setText((CharSequence)this.yearFormat.format(this.calendar.getTime()));
        if (this.onClickYearListener != null) {
            holder.container.setOnClickListener((View.OnClickListener)new BufferYearClickListener(currentYear, position));
        }
    }

    public int getItemViewType(int position) {
        if (this.listYears.get(position).equals(this.selectedYear)) {
            return 1;
        }
        return 0;
    }

    public List<Integer> getListYears() {
        return this.listYears;
    }

    public void setListYears(List<Integer> listYears) {
        this.listYears = listYears;
    }

    public int getSelectedYear() {
        return this.selectedYear;
    }

    public void setSelectedYear(int selectedYear) throws SelectYearException {
        if (!this.listYears.contains(selectedYear)) {
            throw new SelectYearException(selectedYear, this.listYears);
        }
        this.selectedYear = selectedYear;
        this.positionSelectedYear = this.listYears.indexOf(selectedYear);
    }

    public int getPositionSelectedYear() {
        return this.positionSelectedYear;
    }

    public OnClickYearListener getOnClickYearListener() {
        return this.onClickYearListener;
    }

    public void setOnClickYearListener(OnClickYearListener onClickYearListener) {
        this.onClickYearListener = onClickYearListener;
    }

    class SelectYearException
    extends Exception {
        SelectYearException(Integer yearSelected, List<Integer> listYears) {
            super("Year selected " + yearSelected + " must be in list of years : " + listYears);
        }
    }

    class TextIndicatorViewHolder
    extends RecyclerView.ViewHolder {
        private ViewGroup container;
        private TextView textView;

        TextIndicatorViewHolder(View itemView) {
            super(itemView);
            this.container = (ViewGroup)itemView.findViewById(R.id.year_element_container);
            this.textView = (TextView)itemView.findViewById(R.id.year_textView);
        }
    }

    private class BufferYearClickListener
    implements View.OnClickListener {
        private Integer year;
        private int position;

        BufferYearClickListener(Integer yearClicked, int position) {
            this.year = yearClicked;
            this.position = position;
        }

        public void onClick(View view) {
            YearPickerAdapter.this.onClickYearListener.onItemYearClick(view, this.year, this.position);
        }
    }

    public static interface OnClickYearListener {
        public void onItemYearClick(View var1, Integer var2, int var3);
    }
}

