/*
 * Decompiled with CFR 0.152.
 */
package com.kunzisoft.switchdatetime.date.widget;

import android.annotation.SuppressLint;
import android.content.Context;
import android.content.res.TypedArray;
import android.graphics.Canvas;
import android.graphics.Paint;
import android.support.annotation.ColorInt;
import android.support.v7.widget.AppCompatTextView;
import android.util.AttributeSet;
import com.kunzisoft.switchdatetime.R;

public class TextCircularIndicatorView
extends AppCompatTextView {
    private int mCircleColor = -16776961;
    private Paint mCirclePaint = new Paint();

    public TextCircularIndicatorView(Context context) {
        this(context, null, 0);
    }

    public TextCircularIndicatorView(Context context, AttributeSet attrs) {
        this(context, attrs, 0);
    }

    public TextCircularIndicatorView(Context context, AttributeSet attrs, int defStyleAttr) {
        super(context, attrs, defStyleAttr);
        this.init(attrs);
    }

    private void init(AttributeSet attrs) {
        if (attrs != null) {
            TypedArray circularIndicatorTypedArray = this.getContext().obtainStyledAttributes(attrs, R.styleable.TextCircularIndicatorView);
            this.setCircleColor(circularIndicatorTypedArray.getColor(R.styleable.TextCircularIndicatorView_colorCircleIndicator, this.mCircleColor));
            circularIndicatorTypedArray.recycle();
        }
        this.mCirclePaint.setFakeBoldText(true);
        this.mCirclePaint.setAntiAlias(true);
        this.mCirclePaint.setColor(this.mCircleColor);
        this.mCirclePaint.setTextAlign(Paint.Align.CENTER);
        this.mCirclePaint.setStyle(Paint.Style.FILL);
    }

    @SuppressLint(value={"GetContentDescriptionOverride"})
    public CharSequence getContentDescription() {
        return this.getText();
    }

    public void onDraw(Canvas canvas) {
        int width = this.getWidth();
        int height = this.getHeight();
        int radius = Math.min(width, height) / 2;
        canvas.drawCircle((float)(width / 2), (float)(height / 2), (float)radius, this.mCirclePaint);
        super.onDraw(canvas);
    }

    public int getCircleColor() {
        return this.mCircleColor;
    }

    public void setCircleColor(@ColorInt int color) {
        this.mCircleColor = color;
    }
}

