/*
 * Decompiled with CFR 0.152.
 */
package com.kunzisoft.switchdatetime.date.widget;

import android.content.Context;
import android.content.res.Resources;
import android.content.res.TypedArray;
import android.support.v7.widget.LinearLayoutManager;
import android.support.v7.widget.RecyclerView;
import android.util.AttributeSet;
import android.util.Log;
import android.view.View;
import android.view.ViewGroup;
import com.kunzisoft.switchdatetime.R;
import com.kunzisoft.switchdatetime.date.OnYearSelectedListener;
import com.kunzisoft.switchdatetime.date.widget.YearPickerAdapter;
import java.util.ArrayList;

public class ListPickerYearView
extends RecyclerView
implements YearPickerAdapter.OnClickYearListener {
    private static final String TAG = "ListPickerYearView";
    private int minYear = 1970;
    private int maxYear = 2100;
    private int currentYear;
    private YearPickerAdapter mAdapter;
    private OnYearSelectedListener yearChangeListener;
    private int mChildSize;
    private int mViewSize;

    public ListPickerYearView(Context context) {
        this(context, null, 0);
    }

    public ListPickerYearView(Context context, AttributeSet attrs) {
        this(context, attrs, 0);
    }

    public ListPickerYearView(Context context, AttributeSet attrs, int defStyleAttr) {
        super(context, attrs, defStyleAttr);
        this.init(context, attrs);
    }

    private void init(Context context, AttributeSet attrs) {
        this.setLayoutManager((RecyclerView.LayoutManager)new LinearLayoutManager(context));
        if (attrs != null) {
            TypedArray yearTypedArray = this.getContext().obtainStyledAttributes(attrs, R.styleable.ListPickerYearView);
            this.setMinYear(yearTypedArray.getInt(R.styleable.ListPickerYearView_minYear, this.minYear));
            this.setMaxYear(yearTypedArray.getInt(R.styleable.ListPickerYearView_maxYear, this.minYear));
            this.currentYear = yearTypedArray.getInt(R.styleable.ListPickerYearView_defaultYear, -1);
            yearTypedArray.recycle();
        }
        this.setLayoutParams(new ViewGroup.LayoutParams(-1, -2));
        Resources resources = context.getResources();
        this.mViewSize = resources.getDimensionPixelOffset(R.dimen.date_picker_view_animator_height);
        this.mChildSize = resources.getDimensionPixelOffset(R.dimen.year_label_height);
        this.setVerticalFadingEdgeEnabled(true);
        this.setFadingEdgeLength(this.mChildSize / 3);
        this.mAdapter = new YearPickerAdapter();
        this.setAdapter(this.mAdapter);
        this.mAdapter.setOnClickYearListener(this);
        this.refreshAndCenter();
    }

    private void injectYearsInAdapter() {
        if (this.mAdapter != null) {
            ArrayList<Integer> years = new ArrayList<Integer>();
            for (int year = this.minYear; year <= this.maxYear; ++year) {
                years.add(year);
            }
            this.mAdapter.setListYears(years);
            this.mAdapter.notifyDataSetChanged();
        }
    }

    public void refreshAndCenter() {
        this.mAdapter.notifyDataSetChanged();
        this.centerListOn(this.currentYear - this.minYear - 1);
    }

    @Override
    public void onItemYearClick(View view, Integer year, int position) {
        int positionOldYear = this.mAdapter.getPositionSelectedYear();
        this.currentYear = year;
        if (this.yearChangeListener != null) {
            this.yearChangeListener.onYearSelected(view, year);
        }
        try {
            this.mAdapter.setSelectedYear(this.currentYear);
        }
        catch (YearPickerAdapter.SelectYearException e) {
            Log.e((String)TAG, (String)e.getMessage());
        }
        this.mAdapter.notifyDataSetChanged();
        this.mAdapter.notifyItemChanged(positionOldYear);
        this.mAdapter.notifyItemChanged(position);
    }

    public void centerListOn(int position) {
        this.getLayoutManager().scrollToPosition(position);
        try {
            this.getLayoutManager().scrollVerticallyBy(this.mViewSize / 2 - this.mChildSize / 2, null, null);
        }
        catch (Exception e) {
            Log.w((String)TAG, (String)"Can't scroll more");
        }
    }

    public void setDatePickerListener(OnYearSelectedListener onYearSelectedListener) {
        this.yearChangeListener = onYearSelectedListener;
    }

    public int getMinYear() {
        return this.minYear;
    }

    public void setMinYear(int minYear) {
        this.minYear = minYear;
        this.injectYearsInAdapter();
    }

    public int getMaxYear() {
        return this.maxYear;
    }

    public void setMaxYear(int maxYear) {
        this.maxYear = maxYear;
        this.injectYearsInAdapter();
    }

    public int getYearSelected() {
        return this.currentYear;
    }

    public void assignCurrentYear(int year) {
        this.currentYear = year;
        if (this.mAdapter != null) {
            try {
                this.mAdapter.setSelectedYear(this.currentYear);
            }
            catch (YearPickerAdapter.SelectYearException e) {
                Log.e((String)TAG, (String)e.getMessage());
            }
        }
        this.refreshAndCenter();
    }
}

