/*
 * Decompiled with CFR 0.152.
 */
package com.kunzisoft.switchdatetime.date.widget;

import android.content.Context;
import android.content.res.TypedArray;
import android.graphics.Canvas;
import android.graphics.Paint;
import android.support.annotation.ColorInt;
import android.support.annotation.RequiresApi;
import android.util.AttributeSet;
import android.widget.TextView;
import com.kunzisoft.switchdatetime.R;

public class TextCircularIndicatorView
extends TextView {
    private int mCircleColor = -16776961;
    private Paint mCirclePaint = new Paint();

    public TextCircularIndicatorView(Context context) {
        this(context, null, 0);
    }

    public TextCircularIndicatorView(Context context, AttributeSet attrs) {
        this(context, attrs, 0);
    }

    public TextCircularIndicatorView(Context context, AttributeSet attrs, int defStyleAttr) {
        super(context, attrs, defStyleAttr);
        this.init(attrs);
    }

    @RequiresApi(api=21)
    public TextCircularIndicatorView(Context context, AttributeSet attrs, int defStyleAttr, int defStyleRes) {
        super(context, attrs, defStyleAttr, defStyleRes);
        this.init(attrs);
    }

    private void init(AttributeSet attrs) {
        if (attrs != null) {
            TypedArray circularIndicatorTypedArray = this.getContext().obtainStyledAttributes(attrs, R.styleable.TextCircularIndicatorView);
            this.setCircleColor(circularIndicatorTypedArray.getColor(R.styleable.TextCircularIndicatorView_colorCircleIndicator, this.mCircleColor));
            circularIndicatorTypedArray.recycle();
        }
        this.mCirclePaint.setFakeBoldText(true);
        this.mCirclePaint.setAntiAlias(true);
        this.mCirclePaint.setColor(this.mCircleColor);
        this.mCirclePaint.setTextAlign(Paint.Align.CENTER);
        this.mCirclePaint.setStyle(Paint.Style.FILL);
    }

    public CharSequence getContentDescription() {
        return this.getText();
    }

    public void onDraw(Canvas canvas) {
        int width = this.getWidth();
        int height = this.getHeight();
        int radius = Math.min(width, height) / 2;
        canvas.drawCircle((float)(width / 2), (float)(height / 2), (float)radius, this.mCirclePaint);
        super.onDraw(canvas);
    }

    public int getCircleColor() {
        return this.mCircleColor;
    }

    public void setCircleColor(@ColorInt int color) {
        this.mCircleColor = color;
    }
}

