/*
 * Decompiled with CFR 0.152.
 */
package com.kunzisoft.switchdatetime.date.widget;

import android.content.Context;
import android.content.res.Resources;
import android.content.res.TypedArray;
import android.graphics.drawable.Drawable;
import android.graphics.drawable.StateListDrawable;
import android.support.annotation.RequiresApi;
import android.util.AttributeSet;
import android.view.View;
import android.view.ViewGroup;
import android.widget.AdapterView;
import android.widget.ListAdapter;
import android.widget.ListView;
import android.widget.TextView;
import com.kunzisoft.switchdatetime.R;
import com.kunzisoft.switchdatetime.date.OnYearSelectedListener;
import com.kunzisoft.switchdatetime.date.widget.YearPickerAdapter;
import java.util.ArrayList;

public class ListPickerYearView
extends ListView
implements AdapterView.OnItemClickListener {
    private int minYear = 1900;
    private int maxYear = 3000;
    private int currentYear;
    private YearPickerAdapter mAdapter;
    private int mChildSize;
    private OnYearSelectedListener yearChangeListener;
    private int mViewSize;

    public ListPickerYearView(Context context) {
        this(context, null, 0);
    }

    public ListPickerYearView(Context context, AttributeSet attrs) {
        this(context, attrs, 0);
    }

    public ListPickerYearView(Context context, AttributeSet attrs, int defStyleAttr) {
        super(context, attrs, defStyleAttr);
        this.init(context, attrs);
    }

    @RequiresApi(api=21)
    public ListPickerYearView(Context context, AttributeSet attrs, int defStyleAttr, int defStyleRes) {
        super(context, attrs, defStyleAttr, defStyleRes);
        this.init(context, attrs);
    }

    private void init(Context context, AttributeSet attrs) {
        if (attrs != null) {
            TypedArray yearTypedArray = this.getContext().obtainStyledAttributes(attrs, R.styleable.ListPickerYearView);
            this.setMinYear(yearTypedArray.getInt(R.styleable.ListPickerYearView_minYear, this.minYear));
            this.setMaxYear(yearTypedArray.getInt(R.styleable.ListPickerYearView_maxYear, this.minYear));
            this.currentYear = yearTypedArray.getInt(R.styleable.ListPickerYearView_defaultYear, 2000);
            yearTypedArray.recycle();
        }
        this.setLayoutParams(new ViewGroup.LayoutParams(-1, -2));
        Resources resources = context.getResources();
        this.mViewSize = resources.getDimensionPixelOffset(R.dimen.date_picker_view_animator_height);
        this.mChildSize = resources.getDimensionPixelOffset(R.dimen.year_label_height);
        this.setVerticalFadingEdgeEnabled(true);
        this.setFadingEdgeLength(this.mChildSize / 3);
        ArrayList<Integer> years = new ArrayList<Integer>();
        for (int year = this.minYear; year <= this.maxYear; ++year) {
            years.add(year);
        }
        this.mAdapter = new YearPickerAdapter(this.getContext(), years, this.currentYear);
        this.setAdapter((ListAdapter)this.mAdapter);
        this.setOnItemClickListener(this);
        this.setSelector((Drawable)new StateListDrawable());
        this.setDividerHeight(0);
        this.refreshAndCenter();
    }

    public void refreshAndCenter() {
        this.mAdapter.notifyDataSetChanged();
        this.centerListOn(this.currentYear - this.minYear - 1);
    }

    public void onItemClick(AdapterView<?> parent, View view, int position, long id2) {
        TextView clickedView = (TextView)view.findViewById(R.id.year_textView);
        if (clickedView != null) {
            this.currentYear = ListPickerYearView.getYearFromTextView(clickedView);
            if (this.yearChangeListener != null) {
                this.yearChangeListener.onYearSelected((View)clickedView, ListPickerYearView.getYearFromTextView(clickedView));
            }
            this.mAdapter.setSelectedYear(this.currentYear);
            this.mAdapter.notifyDataSetChanged();
        }
    }

    public void centerListOn(int position) {
        this.centerListOnWithTop(position, this.mViewSize / 2 - this.mChildSize / 2);
    }

    public void centerListOnWithTop(final int position, final int y) {
        this.post(new Runnable(){

            @Override
            public void run() {
                ListPickerYearView.this.setSelectionFromTop(position, y);
                ListPickerYearView.this.requestLayout();
            }
        });
    }

    private static int getYearFromTextView(TextView view) {
        if (view == null) {
            return 0;
        }
        return Integer.valueOf(view.getText().toString());
    }

    public void setDatePickerListener(OnYearSelectedListener onYearSelectedListener) {
        this.yearChangeListener = onYearSelectedListener;
    }

    public int getMinYear() {
        return this.minYear;
    }

    public void setMinYear(int minYear) {
        this.minYear = minYear;
    }

    public int getMaxYear() {
        return this.maxYear;
    }

    public void setMaxYear(int maxYear) {
        this.maxYear = maxYear;
    }

    public int getYearSelected() {
        return this.currentYear;
    }

    public void assignCurrentYear(int year) {
        this.currentYear = year;
        if (this.mAdapter != null) {
            this.mAdapter.setSelectedYear(this.currentYear);
        }
        this.refreshAndCenter();
    }
}

