/*
 * Decompiled with CFR 0.152.
 */
package com.kunzisoft.switchdatetime;

import android.app.Dialog;
import android.content.Context;
import android.content.DialogInterface;
import android.os.Bundle;
import android.support.annotation.NonNull;
import android.support.v4.app.DialogFragment;
import android.support.v7.app.AlertDialog;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.view.animation.Animation;
import android.widget.ImageButton;
import android.widget.TextView;
import android.widget.ViewAnimator;
import com.kunzisoft.switchdatetime.R;
import com.kunzisoft.switchdatetime.Utils;
import com.kunzisoft.switchdatetime.date.OnYearSelectedListener;
import com.kunzisoft.switchdatetime.date.widget.ListPickerYearView;
import com.kunzisoft.switchdatetime.time.SwitchTimePicker;
import com.prolificinteractive.materialcalendarview.CalendarDay;
import com.prolificinteractive.materialcalendarview.MaterialCalendarView;
import com.prolificinteractive.materialcalendarview.OnDateSelectedListener;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;
import java.util.Locale;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class SwitchDateTimeDialogFragment
extends DialogFragment {
    private static final String TAG = "SwitchDateTimeDialogFrg";
    private static final String STATE_DATETIME = "STATE_DATETIME";
    private Calendar dateTimeCalendar;
    private static final String TAG_LABEL = "LABEL";
    private static final String TAG_POSITIVE_BUTTON = "POSITIVE_BUTTON";
    private static final String TAG_NEGATIVE_BUTTON = "NEGATIVE_BUTTON";
    private String mLabel;
    private String mPositiveButton;
    private String mNegativeButton;
    private OnButtonClickListener mListener;
    private static final int UNDEFINED_TIME_VALUE = -1;
    private int year = -1;
    private int month = -1;
    private int day = -1;
    private int hourOfDay = -1;
    private int minute = -1;
    private boolean is24HoursMode = false;
    private int startAtPosition = 0;
    private SimpleDateFormat dayAndMonthSimpleDate;
    private SimpleDateFormat yearSimpleDate;
    private ViewAnimator viewSwitcher;
    private SwitchTimePicker timePicker;
    private MaterialCalendarView materialCalendarView;
    private ListPickerYearView listPickerYearView;
    private TextView monthAndDayHeaderValues;
    private TextView yearHeaderValues;
    private boolean blockAnimationIn;
    private boolean blockAnimationOut;

    public static SwitchDateTimeDialogFragment newInstance(String label, String positiveButton, String negativeButton) {
        SwitchDateTimeDialogFragment switchDateTimeDialogFragment = new SwitchDateTimeDialogFragment();
        Bundle args = new Bundle();
        args.putString(TAG_LABEL, label);
        args.putString(TAG_POSITIVE_BUTTON, positiveButton);
        args.putString(TAG_NEGATIVE_BUTTON, negativeButton);
        switchDateTimeDialogFragment.setArguments(args);
        return switchDateTimeDialogFragment;
    }

    public void setOnButtonClickListener(OnButtonClickListener onButtonClickListener) {
        this.mListener = onButtonClickListener;
    }

    public void onSaveInstanceState(Bundle savedInstanceState) {
        savedInstanceState.putLong(STATE_DATETIME, this.dateTimeCalendar.getTimeInMillis());
        this.timePicker.onSaveInstanceState(savedInstanceState);
        super.onSaveInstanceState(savedInstanceState);
    }

    @NonNull
    public Dialog onCreateDialog(Bundle savedInstanceState) {
        super.onCreateDialog(savedInstanceState);
        if (this.getArguments() != null) {
            this.mLabel = this.getArguments().getString(TAG_LABEL);
            this.mPositiveButton = this.getArguments().getString(TAG_POSITIVE_BUTTON);
            this.mNegativeButton = this.getArguments().getString(TAG_NEGATIVE_BUTTON);
        }
        this.dateTimeCalendar = Calendar.getInstance();
        if (savedInstanceState != null) {
            this.dateTimeCalendar.setTime(new Date(savedInstanceState.getLong(STATE_DATETIME)));
        }
        if (this.year == -1) {
            this.year = this.dateTimeCalendar.get(1);
        }
        if (this.month == -1) {
            this.month = this.dateTimeCalendar.get(2);
        }
        if (this.day == -1) {
            this.day = this.dateTimeCalendar.get(5);
        }
        if (this.hourOfDay == -1) {
            this.hourOfDay = this.dateTimeCalendar.get(11);
        }
        if (this.minute == -1) {
            this.minute = this.dateTimeCalendar.get(12);
        }
        this.assignAllValuesToCalendar();
        LayoutInflater inflater = LayoutInflater.from((Context)this.getActivity());
        View dateTimeLayout = inflater.inflate(R.layout.dialog_switch_datetime_picker, (ViewGroup)this.getActivity().findViewById(R.id.datetime_picker));
        TextView labelView = (TextView)dateTimeLayout.findViewById(R.id.label);
        if (this.mLabel != null) {
            labelView.setText((CharSequence)this.mLabel);
        } else {
            labelView.setText((CharSequence)this.getString(R.string.label_datetime_dialog));
        }
        this.blockAnimationIn = false;
        this.blockAnimationOut = false;
        this.viewSwitcher = (ViewAnimator)dateTimeLayout.findViewById(R.id.dateSwitcher);
        this.viewSwitcher.getInAnimation().setAnimationListener(new Animation.AnimationListener(){

            public void onAnimationStart(Animation animation) {
                SwitchDateTimeDialogFragment.this.blockAnimationIn = true;
            }

            public void onAnimationEnd(Animation animation) {
                SwitchDateTimeDialogFragment.this.blockAnimationIn = false;
            }

            public void onAnimationRepeat(Animation animation) {
            }
        });
        this.viewSwitcher.getOutAnimation().setAnimationListener(new Animation.AnimationListener(){

            public void onAnimationStart(Animation animation) {
                SwitchDateTimeDialogFragment.this.blockAnimationOut = true;
            }

            public void onAnimationEnd(Animation animation) {
                SwitchDateTimeDialogFragment.this.blockAnimationOut = false;
            }

            public void onAnimationRepeat(Animation animation) {
            }
        });
        this.viewSwitcher.setDisplayedChild(this.startAtPosition);
        ImageButton buttonSwitch = (ImageButton)dateTimeLayout.findViewById(R.id.button_switch);
        buttonSwitch.setBackgroundColor(0);
        buttonSwitch.setOnClickListener(new View.OnClickListener(){

            public void onClick(View view) {
                Utils.animLabelElement(view);
                if (!SwitchDateTimeDialogFragment.this.blockAnimationIn || !SwitchDateTimeDialogFragment.this.blockAnimationOut) {
                    SwitchDateTimeDialogFragment.this.viewSwitcher.showNext();
                }
            }
        });
        View timeHeaderValues = dateTimeLayout.findViewById(R.id.time_header_values);
        OnClickHeaderElementListener onTimeClickListener = new OnClickHeaderElementListener(HeaderViewsPosition.VIEW_HOURS_AND_MINUTES.getPosition());
        timeHeaderValues.setOnClickListener((View.OnClickListener)onTimeClickListener);
        this.monthAndDayHeaderValues = (TextView)dateTimeLayout.findViewById(R.id.date_picker_month_and_day);
        OnClickHeaderElementListener onMonthAndDayClickListener = new OnClickHeaderElementListener(HeaderViewsPosition.VIEW_MONTH_AND_DAY.getPosition());
        this.monthAndDayHeaderValues.setOnClickListener((View.OnClickListener)onMonthAndDayClickListener);
        this.yearHeaderValues = (TextView)dateTimeLayout.findViewById(R.id.date_picker_year);
        OnClickHeaderElementListener onYearClickListener = new OnClickHeaderElementListener(HeaderViewsPosition.VIEW_YEAR.getPosition());
        this.yearHeaderValues.setOnClickListener((View.OnClickListener)onYearClickListener);
        if (this.dayAndMonthSimpleDate == null) {
            this.dayAndMonthSimpleDate = new SimpleDateFormat("MMMM dd", Locale.getDefault());
        }
        if (this.yearSimpleDate == null) {
            this.yearSimpleDate = new SimpleDateFormat("yyyy", Locale.getDefault());
        }
        this.yearHeaderValues.setText((CharSequence)String.valueOf(this.year));
        this.monthAndDayHeaderValues.setText((CharSequence)this.dayAndMonthSimpleDate.format(this.dateTimeCalendar.getTime()));
        SwitchTimePicker.OnTimeSelectedListener onTimeSelectedListener = new SwitchTimePicker.OnTimeSelectedListener(){

            @Override
            public void onTimeSelected(int hourOfDayTime, int minuteTime) {
                SwitchDateTimeDialogFragment.this.hourOfDay = hourOfDayTime;
                SwitchDateTimeDialogFragment.this.minute = minuteTime;
                SwitchDateTimeDialogFragment.this.dateTimeCalendar.set(11, hourOfDayTime);
                SwitchDateTimeDialogFragment.this.dateTimeCalendar.set(12, minuteTime);
            }
        };
        this.timePicker = savedInstanceState == null ? new SwitchTimePicker(this.getContext(), onTimeSelectedListener) : new SwitchTimePicker(this.getContext(), onTimeSelectedListener, savedInstanceState);
        this.timePicker = new SwitchTimePicker(this.getContext(), onTimeSelectedListener, savedInstanceState);
        this.timePicker.setIs24HourMode(this.is24HoursMode);
        this.timePicker.setHourOfDay(this.hourOfDay);
        this.timePicker.setMinute(this.minute);
        this.timePicker.onCreateView(dateTimeLayout, savedInstanceState);
        this.timePicker.setOnClickTimeListener(onTimeClickListener);
        this.materialCalendarView = (MaterialCalendarView)dateTimeLayout.findViewById(R.id.datePicker);
        this.materialCalendarView.setCurrentDate(this.dateTimeCalendar.getTime());
        this.materialCalendarView.setDateSelected(this.dateTimeCalendar, true);
        this.materialCalendarView.setOnDateChangedListener(new OnDateSelectedListener(){

            public void onDateSelected(@NonNull MaterialCalendarView widget, @NonNull CalendarDay calendarDay, boolean selected) {
                Date currentDate = calendarDay.getDate();
                SwitchDateTimeDialogFragment.this.year = calendarDay.getYear();
                SwitchDateTimeDialogFragment.this.month = calendarDay.getMonth();
                SwitchDateTimeDialogFragment.this.day = calendarDay.getDay();
                SwitchDateTimeDialogFragment.this.dateTimeCalendar.set(1, SwitchDateTimeDialogFragment.this.year);
                SwitchDateTimeDialogFragment.this.dateTimeCalendar.set(2, SwitchDateTimeDialogFragment.this.month);
                SwitchDateTimeDialogFragment.this.dateTimeCalendar.set(5, SwitchDateTimeDialogFragment.this.day);
                SwitchDateTimeDialogFragment.this.listPickerYearView.assignCurrentYear(SwitchDateTimeDialogFragment.this.year);
                SwitchDateTimeDialogFragment.this.yearHeaderValues.setText((CharSequence)String.valueOf(SwitchDateTimeDialogFragment.this.year));
                SwitchDateTimeDialogFragment.this.monthAndDayHeaderValues.setText((CharSequence)SwitchDateTimeDialogFragment.this.dayAndMonthSimpleDate.format(currentDate));
            }
        });
        this.listPickerYearView = (ListPickerYearView)dateTimeLayout.findViewById(R.id.yearPicker);
        this.listPickerYearView.assignCurrentYear(this.year);
        this.listPickerYearView.setDatePickerListener(new OnYearSelectedListener(){

            @Override
            public void onYearSelected(View view, int yearPicker) {
                SwitchDateTimeDialogFragment.this.year = yearPicker;
                SwitchDateTimeDialogFragment.this.dateTimeCalendar.set(1, SwitchDateTimeDialogFragment.this.year);
                SwitchDateTimeDialogFragment.this.materialCalendarView.setCurrentDate(SwitchDateTimeDialogFragment.this.dateTimeCalendar.getTime());
                SwitchDateTimeDialogFragment.this.materialCalendarView.setDateSelected(SwitchDateTimeDialogFragment.this.dateTimeCalendar, true);
                SwitchDateTimeDialogFragment.this.materialCalendarView.goToNext();
                SwitchDateTimeDialogFragment.this.materialCalendarView.goToPrevious();
                SwitchDateTimeDialogFragment.this.yearHeaderValues.setText((CharSequence)String.valueOf(SwitchDateTimeDialogFragment.this.year));
            }
        });
        AlertDialog.Builder db = new AlertDialog.Builder((Context)this.getActivity());
        db.setView(dateTimeLayout);
        if (this.mPositiveButton == null) {
            this.mPositiveButton = this.getString(R.string.positive_button_datetime_picker);
        }
        db.setPositiveButton((CharSequence)this.mPositiveButton, new DialogInterface.OnClickListener(){

            public void onClick(DialogInterface dialog, int which) {
                if (SwitchDateTimeDialogFragment.this.mListener != null) {
                    SwitchDateTimeDialogFragment.this.assignAllValuesToCalendar();
                    SwitchDateTimeDialogFragment.this.mListener.onPositiveButtonClick(SwitchDateTimeDialogFragment.this.dateTimeCalendar.getTime());
                }
            }
        });
        if (this.mNegativeButton == null) {
            this.mNegativeButton = this.getString(R.string.negative_button_datetime_picker);
        }
        db.setNegativeButton((CharSequence)this.mNegativeButton, new DialogInterface.OnClickListener(){

            public void onClick(DialogInterface dialog, int which) {
                if (SwitchDateTimeDialogFragment.this.mListener != null) {
                    SwitchDateTimeDialogFragment.this.assignAllValuesToCalendar();
                    SwitchDateTimeDialogFragment.this.mListener.onNegativeButtonClick(SwitchDateTimeDialogFragment.this.dateTimeCalendar.getTime());
                }
            }
        });
        return db.create();
    }

    private void assignAllValuesToCalendar() {
        this.dateTimeCalendar.set(1, this.year);
        this.dateTimeCalendar.set(2, this.month);
        this.dateTimeCalendar.set(5, this.day);
        this.dateTimeCalendar.set(11, this.hourOfDay);
        this.dateTimeCalendar.set(12, this.minute);
        this.dateTimeCalendar.set(13, 0);
    }

    public void startAtTimeView() {
        this.startAtPosition = 0;
    }

    public void startAtCalendarView() {
        this.startAtPosition = 1;
    }

    public void startAtYearView() {
        this.startAtPosition = 2;
    }

    public void setDefaultYear(int year) {
        this.year = year;
    }

    @Deprecated
    public void setYear(int year) {
        this.setDefaultYear(year);
    }

    public void setDefaultMonth(int month) {
        this.month = month;
    }

    @Deprecated
    public void setMonth(int month) {
        this.setDefaultMonth(month);
    }

    public void setDefaultDay(int day) {
        this.day = day;
    }

    @Deprecated
    public void setDay(int day) {
        this.setDefaultDay(day);
    }

    public void setDefaultHourOfDay(int hourOfDay) {
        this.hourOfDay = hourOfDay;
    }

    @Deprecated
    public void setHour(int hour) {
        this.setDefaultHourOfDay(hour);
    }

    public void setDefaultMinute(int minute) {
        this.minute = minute;
    }

    @Deprecated
    public void setMinute(int minute) {
        this.setDefaultMinute(minute);
    }

    public int getYear() {
        return this.year;
    }

    public int getMonth() {
        return this.month;
    }

    public int getDay() {
        return this.day;
    }

    public int getHourOfDay() {
        return this.hourOfDay;
    }

    public int getMinute() {
        return this.minute;
    }

    public SimpleDateFormat getSimpleDateMonthAndDayFormat() {
        return this.dayAndMonthSimpleDate;
    }

    public void setSimpleDateMonthAndDayFormat(SimpleDateFormat simpleDateFormat) throws SimpleDateMonthAndDayFormatException {
        Pattern patternMonthAndDay = Pattern.compile("(M|w|W|D|d|F|E|u|\\s)*");
        Matcher matcherMonthAndDay = patternMonthAndDay.matcher(simpleDateFormat.toPattern());
        if (!matcherMonthAndDay.matches()) {
            throw new SimpleDateMonthAndDayFormatException(simpleDateFormat.toPattern() + "isn't allowed for " + patternMonthAndDay.pattern());
        }
        this.dayAndMonthSimpleDate = simpleDateFormat;
    }

    public void set24HoursMode(boolean is24HoursMode) {
        this.is24HoursMode = is24HoursMode;
    }

    public class OnClickHeaderElementListener
    implements View.OnClickListener {
        private int positionView;

        OnClickHeaderElementListener(int positionView) {
            this.positionView = positionView;
        }

        public void onClick(View view) {
            Utils.animLabelElement(view);
            if (SwitchDateTimeDialogFragment.this.viewSwitcher.getDisplayedChild() != this.positionView) {
                SwitchDateTimeDialogFragment.this.viewSwitcher.setDisplayedChild(this.positionView);
            }
        }
    }

    public static enum HeaderViewsPosition {
        VIEW_HOURS_AND_MINUTES(0),
        VIEW_MONTH_AND_DAY(1),
        VIEW_YEAR(2);

        private int positionSwitch;

        private HeaderViewsPosition(int position) {
            this.positionSwitch = position;
        }

        public int getPosition() {
            return this.positionSwitch;
        }
    }

    public static interface OnButtonClickListener {
        public void onPositiveButtonClick(Date var1);

        public void onNegativeButtonClick(Date var1);
    }

    public class SimpleDateMonthAndDayFormatException
    extends Exception {
        SimpleDateMonthAndDayFormatException(String message) {
            super(message);
        }
    }
}

