/*
 * Decompiled with CFR 0.152.
 */
package io.ethers.rlp;

import io.ethers.rlp.RlpEncodable;
import java.math.BigInteger;
import java.nio.ByteBuffer;
import java.util.Arrays;
import java.util.List;
import kotlin.Metadata;
import kotlin.UByte;
import kotlin.Unit;
import kotlin.collections.ArraysKt;
import kotlin.jvm.JvmOverloads;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000^\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0010\u0012\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0005\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\t\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u000b\u0018\u00002\u00020\u0001B\u0011\b\u0017\u0012\b\b\u0002\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004B\r\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\u0002\u0010\u0007J\u000e\u0010\u000b\u001a\u00020\u00002\u0006\u0010\f\u001a\u00020\rJ\u001f\u0010\u000e\u001a\u00020\u0000\"\b\b\u0000\u0010\u000f*\u00020\u00102\b\u0010\u0011\u001a\u0004\u0018\u0001H\u000f\u00a2\u0006\u0002\u0010\u0012J\u0010\u0010\u000e\u001a\u00020\u00002\b\u0010\u0011\u001a\u0004\u0018\u00010\u0013J\u0010\u0010\u000e\u001a\u00020\u00002\b\u0010\u0014\u001a\u0004\u0018\u00010\u0006J\u000e\u0010\u000e\u001a\u00020\u00002\u0006\u0010\u0011\u001a\u00020\u0015J\"\u0010\u0016\u001a\u00020\u00002\u0017\u0010\u0017\u001a\u0013\u0012\u0004\u0012\u00020\u0000\u0012\u0004\u0012\u00020\u00190\u0018\u00a2\u0006\u0002\b\u001aH\u0086\bJ\u000e\u0010\u0016\u001a\u00020\u00002\u0006\u0010\u0017\u001a\u00020\u001bJ<\u0010\u0016\u001a\u00020\u0000\"\u0004\b\u0000\u0010\u000f2\f\u0010\u001c\u001a\b\u0012\u0004\u0012\u0002H\u000f0\u001d2\u001d\u0010\u0017\u001a\u0019\u0012\u0004\u0012\u00020\u0000\u0012\u0004\u0012\u0002H\u000f\u0012\u0004\u0012\u00020\u00190\u001e\u00a2\u0006\u0002\b\u001aH\u0086\bJ \u0010\u0016\u001a\u00020\u0000\"\b\b\u0000\u0010\u000f*\u00020\u00102\u000e\u0010\u001c\u001a\n\u0012\u0004\u0012\u0002H\u000f\u0018\u00010\u001dJ\u0018\u0010\u001f\u001a\u00020\u00192\u0006\u0010 \u001a\u00020\u00032\u0006\u0010!\u001a\u00020\u0003H\u0002J\u000e\u0010\"\u001a\u00020\u00192\u0006\u0010#\u001a\u00020\u0003J\u0010\u0010$\u001a\u00020\u00032\u0006\u0010!\u001a\u00020\u0003H\u0002J\u0006\u0010%\u001a\u00020\u0003J\u0006\u0010&\u001a\u00020\u0006J\u0014\u0010'\u001a\u00020\t*\u00020\t2\u0006\u0010(\u001a\u00020\u0003H\u0002R\u000e\u0010\b\u001a\u00020\tX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u0003X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006)"}, d2={"Lio/ethers/rlp/RlpEncoder;", "", "initialCapacity", "", "(I)V", "array", "", "([B)V", "buffer", "Ljava/nio/ByteBuffer;", "startedListCount", "appendRaw", "byte", "", "encode", "T", "Lio/ethers/rlp/RlpEncodable;", "value", "(Lio/ethers/rlp/RlpEncodable;)Lio/ethers/rlp/RlpEncoder;", "Ljava/math/BigInteger;", "bytes", "", "encodeList", "action", "Lkotlin/Function1;", "", "Lkotlin/ExtensionFunctionType;", "Ljava/lang/Runnable;", "list", "", "Lkotlin/Function2;", "encodeSize", "lengthOfSize", "size", "finishList", "bufferStartPosition", "lengthOfSizeInBytes", "startList", "toByteArray", "ensureCapacity", "sizeIncrement", "ethers-rlp"})
@SourceDebugExtension(value={"SMAP\nRlpEncoder.kt\nKotlin\n*S Kotlin\n*F\n+ 1 RlpEncoder.kt\nio/ethers/rlp/RlpEncoder\n+ 2 _Arrays.kt\nkotlin/collections/ArraysKt___ArraysKt\n*L\n1#1,322:1\n78#1,5:323\n78#1,5:328\n1639#2,6:333\n*S KotlinDebug\n*F\n+ 1 RlpEncoder.kt\nio/ethers/rlp/RlpEncoder\n*L\n41#1:323,5\n54#1:328,5\n172#1:333,6\n*E\n"})
public final class RlpEncoder {
    @NotNull
    private ByteBuffer buffer;
    private int startedListCount;

    public RlpEncoder(@NotNull byte[] array) {
        this.buffer = ByteBuffer.wrap(array);
    }

    @JvmOverloads
    public RlpEncoder(int initialCapacity) {
        this(new byte[initialCapacity]);
    }

    public /* synthetic */ RlpEncoder(int n, int n2, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n2 & 1) != 0) {
            n = 512;
        }
        this(n);
    }

    @NotNull
    public final byte[] toByteArray() {
        if (this.startedListCount != 0) {
            throw new IllegalStateException("Not all list encodings were finished. Need to close " + this.startedListCount + " more.");
        }
        byte[] byArray = this.buffer.array();
        int n = 0;
        int n2 = this.buffer.position();
        return ArraysKt.copyOfRange((byte[])byArray, (int)n, (int)n2);
    }

    @NotNull
    public final RlpEncoder appendRaw(byte by) {
        this.ensureCapacity(this.buffer, 1).put(by);
        return this;
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final <T extends RlpEncodable> RlpEncoder encodeList(@Nullable List<? extends T> list) {
        void var2_2;
        RlpEncoder this_$iv = this;
        boolean $i$f$encodeList = false;
        int bufferStartPosition$iv = this_$iv.startList();
        RlpEncoder $this$encodeList_u24lambda_u240 = this_$iv;
        boolean bl = false;
        if (list != null) {
            int n = list.size();
            for (int i = 0; i < n; ++i) {
                ((RlpEncodable)list.get(i)).rlpEncode($this$encodeList_u24lambda_u240);
            }
        }
        this_$iv.finishList(bufferStartPosition$iv);
        return var2_2;
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final RlpEncoder encodeList(@NotNull Runnable action) {
        void var2_2;
        RlpEncoder this_$iv = this;
        boolean $i$f$encodeList = false;
        int bufferStartPosition$iv = this_$iv.startList();
        RlpEncoder $this$encodeList_u24lambda_u241 = this_$iv;
        boolean bl = false;
        action.run();
        this_$iv.finishList(bufferStartPosition$iv);
        return var2_2;
    }

    @NotNull
    public final <T> RlpEncoder encodeList(@NotNull List<? extends T> list, @NotNull Function2<? super RlpEncoder, ? super T, Unit> action) {
        boolean $i$f$encodeList = false;
        int bufferStartPosition = this.startList();
        int n = list.size();
        for (int i = 0; i < n; ++i) {
            action.invoke((Object)this, list.get(i));
        }
        this.finishList(bufferStartPosition);
        return this;
    }

    @NotNull
    public final RlpEncoder encodeList(@NotNull Function1<? super RlpEncoder, Unit> action) {
        boolean $i$f$encodeList = false;
        int bufferStartPosition = this.startList();
        action.invoke((Object)this);
        this.finishList(bufferStartPosition);
        return this;
    }

    public final int startList() {
        int bufferStartPosition = this.buffer.position();
        this.ensureCapacity(this.buffer, 1).put((byte)-64);
        int n = this.startedListCount;
        this.startedListCount = n + 1;
        return bufferStartPosition;
    }

    public final void finishList(int bufferStartPosition) {
        int bufferEndPosition = this.buffer.position();
        int size = bufferEndPosition - bufferStartPosition - 1;
        if (size != 0) {
            if (size <= 55) {
                this.buffer.put(bufferStartPosition, (byte)(192 + size));
            } else {
                int lengthOfSize = this.lengthOfSizeInBytes(size);
                this.buffer.put(bufferStartPosition, (byte)(247 + lengthOfSize));
                int startIndex = bufferStartPosition + 1;
                this.ensureCapacity(this.buffer, lengthOfSize);
                ArraysKt.copyInto((byte[])this.buffer.array(), (byte[])this.buffer.array(), (int)(startIndex + lengthOfSize), (int)startIndex, (int)bufferEndPosition);
                this.buffer.position(startIndex);
                this.encodeSize(lengthOfSize, size);
                this.buffer.position(bufferEndPosition + lengthOfSize);
            }
        }
        int n = this.startedListCount;
        this.startedListCount = n + -1;
    }

    @NotNull
    public final <T extends RlpEncodable> RlpEncoder encode(@Nullable T value) {
        if (value == null) {
            this.ensureCapacity(this.buffer, 1).put((byte)-128);
        } else {
            value.rlpEncode(this);
        }
        return this;
    }

    @NotNull
    public final RlpEncoder encode(@Nullable BigInteger value) {
        int n;
        int n2;
        byte[] bytes;
        block7: {
            if (value == null) {
                this.ensureCapacity(this.buffer, 1).put((byte)-128);
                return this;
            }
            if (value.compareTo(BigInteger.ZERO) < 0) {
                throw new IllegalArgumentException("Negative values are not supported: " + value);
            }
            if (Intrinsics.areEqual((Object)value, (Object)BigInteger.ZERO)) {
                this.ensureCapacity(this.buffer, 1).put((byte)-128);
                return this;
            }
            bytes = value.toByteArray();
            n2 = 0;
            byte[] $this$indexOfFirst$iv = bytes;
            boolean $i$f$indexOfFirst = false;
            int n3 = $this$indexOfFirst$iv.length;
            for (int index$iv = 0; index$iv < n3; ++index$iv) {
                byte it = $this$indexOfFirst$iv[index$iv];
                boolean bl = false;
                if (!(it != 0)) continue;
                n = index$iv;
                break block7;
            }
            n = -1;
        }
        int n4 = n;
        int offset = Math.max(n2, n4);
        int nonZeroLength = bytes.length - offset;
        if (nonZeroLength > 32) {
            throw new IllegalArgumentException("Value too big, max 32 bytes are supported: " + value);
        }
        if (nonZeroLength == 1 && (UByte.constructor-impl((byte)bytes[0]) & 0xFF) < 128) {
            this.ensureCapacity(this.buffer, 1).put(bytes[0]);
        } else {
            this.ensureCapacity(this.buffer, 1 + nonZeroLength);
            this.buffer.put((byte)(128 + nonZeroLength));
            this.buffer.put(bytes, offset, nonZeroLength);
        }
        return this;
    }

    @NotNull
    public final RlpEncoder encode(long value) {
        int bitShift;
        if (value < 0L) {
            throw new IllegalArgumentException("Negative values are not supported: " + value);
        }
        if (value == 0L) {
            this.ensureCapacity(this.buffer, 1).put((byte)-128);
            return this;
        }
        for (bitShift = 56; bitShift >= 0 && value >> bitShift == 0L; bitShift -= 8) {
        }
        int nonZeroLength = bitShift / 8 + 1;
        if (nonZeroLength == 1 && value < 128L) {
            this.ensureCapacity(this.buffer, 1).put((byte)value);
        } else {
            this.ensureCapacity(this.buffer, 1 + nonZeroLength);
            this.buffer.put((byte)(128 + nonZeroLength));
            while (bitShift >= 0) {
                this.buffer.put((byte)(value >> bitShift & 0xFFL));
                bitShift -= 8;
            }
        }
        return this;
    }

    @NotNull
    public final RlpEncoder encode(@Nullable byte[] bytes) {
        if (bytes == null || bytes.length == 0) {
            this.ensureCapacity(this.buffer, 1).put((byte)-128);
            return this;
        }
        if (bytes.length == 1 && bytes[0] == 0) {
            this.ensureCapacity(this.buffer, 1).put((byte)-128);
        } else if (bytes.length == 1 && (UByte.constructor-impl((byte)bytes[0]) & 0xFF) < 128) {
            this.ensureCapacity(this.buffer, 1).put(bytes[0]);
        } else if (bytes.length <= 55) {
            this.ensureCapacity(this.buffer, 1 + bytes.length);
            this.buffer.put((byte)(128 + bytes.length));
            this.buffer.put(bytes);
        } else {
            int lengthOfSize = this.lengthOfSizeInBytes(bytes.length);
            this.ensureCapacity(this.buffer, 1 + lengthOfSize + bytes.length);
            this.buffer.put((byte)(183 + lengthOfSize));
            this.encodeSize(lengthOfSize, bytes.length);
            this.buffer.put(bytes);
        }
        return this;
    }

    private final int lengthOfSizeInBytes(int size) {
        return size <= 255 ? 1 : (size <= 65535 ? 2 : (size <= 0xFFFFFF ? 3 : 4));
    }

    private final void encodeSize(int lengthOfSize, int size) {
        switch (lengthOfSize) {
            case 1: {
                this.buffer.put((byte)(size & 0xFF));
                break;
            }
            case 2: {
                this.buffer.put((byte)(size >> 8 & 0xFF));
                this.buffer.put((byte)(size & 0xFF));
                break;
            }
            case 3: {
                this.buffer.put((byte)(size >> 16 & 0xFF));
                this.buffer.put((byte)(size >> 8 & 0xFF));
                this.buffer.put((byte)(size & 0xFF));
                break;
            }
            case 4: {
                this.buffer.put((byte)(size >> 24 & 0xFF));
                this.buffer.put((byte)(size >> 16 & 0xFF));
                this.buffer.put((byte)(size >> 8 & 0xFF));
                this.buffer.put((byte)(size & 0xFF));
            }
        }
    }

    private final ByteBuffer ensureCapacity(ByteBuffer $this$ensureCapacity, int sizeIncrement) {
        if ($this$ensureCapacity.remaining() >= sizeIncrement) {
            return $this$ensureCapacity;
        }
        int newCapacity = Math.max($this$ensureCapacity.capacity() + sizeIncrement, (int)((double)$this$ensureCapacity.capacity() * 1.5));
        byte[] byArray = Arrays.copyOf(this.buffer.array(), newCapacity);
        Intrinsics.checkNotNullExpressionValue((Object)byArray, (String)"copyOf(...)");
        byte[] newBuffer = byArray;
        int originalPosition = $this$ensureCapacity.position();
        this.buffer = ByteBuffer.wrap(newBuffer);
        this.buffer.position(originalPosition);
        return this.buffer;
    }

    @JvmOverloads
    public RlpEncoder() {
        this(0, 1, null);
    }
}

