/*
 * Decompiled with CFR 0.152.
 */
package io.ethers.crypto;

import io.ethers.crypto.ECDSASignerRecoverable;
import java.math.BigInteger;
import kotlin.Metadata;
import kotlin.collections.ArraysKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.bouncycastle.asn1.x9.X9ECParameters;
import org.bouncycastle.asn1.x9.X9IntegerConverter;
import org.bouncycastle.crypto.CipherParameters;
import org.bouncycastle.crypto.Digest;
import org.bouncycastle.crypto.digests.SHA256Digest;
import org.bouncycastle.crypto.ec.CustomNamedCurves;
import org.bouncycastle.crypto.params.ECDomainParameters;
import org.bouncycastle.crypto.params.ECPrivateKeyParameters;
import org.bouncycastle.crypto.signers.DSAKCalculator;
import org.bouncycastle.crypto.signers.HMacDSAKCalculator;
import org.bouncycastle.jcajce.provider.digest.Keccak;
import org.bouncycastle.math.ec.ECAlgorithms;
import org.bouncycastle.math.ec.ECPoint;
import org.bouncycastle.math.ec.FixedPointCombMultiplier;
import org.bouncycastle.math.ec.custom.sec.SecP256K1Curve;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000P\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0005\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0012\n\u0002\b\n\n\u0002\u0010\t\n\u0002\b\u0003\b\u00c6\u0002\u0018\u00002\u00020\u0001:\u0001#B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0018\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u00062\u0006\u0010\u0013\u001a\u00020\u0014H\u0002J\u0016\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u0017\u001a\u00020\u00162\u0006\u0010\u0018\u001a\u00020\u0016J\u000e\u0010\u0019\u001a\u00020\u00162\u0006\u0010\u001a\u001a\u00020\u0016J\u000e\u0010\u001b\u001a\u00020\u00112\u0006\u0010\u0017\u001a\u00020\u0006J(\u0010\u001c\u001a\u0004\u0018\u00010\u00162\u0006\u0010\u001d\u001a\u00020\u00162\u0006\u0010\u001e\u001a\u00020\u00062\u0006\u0010\u001f\u001a\u00020\u00062\u0006\u0010 \u001a\u00020!J\f\u0010\"\u001a\u00020\u0016*\u00020\u0006H\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010\u0007\u001a\n \t*\u0004\u0018\u00010\b0\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\rX\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000e\u001a\u00020\u000fX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006$"}, d2={"Lio/ethers/crypto/Secp256k1;", "", "()V", "CURVE", "Lorg/bouncycastle/crypto/params/ECDomainParameters;", "CURVE_HALF_ORDER", "Ljava/math/BigInteger;", "CURVE_PARAMS", "Lorg/bouncycastle/asn1/x9/X9ECParameters;", "kotlin.jvm.PlatformType", "FIXED_POINT_MULTIPLIER", "Lorg/bouncycastle/math/ec/FixedPointCombMultiplier;", "UNCOMPRESSED_KEY_FLAG", "", "X9_CONVERTER", "Lorg/bouncycastle/asn1/x9/X9IntegerConverter;", "decompressKey", "Lorg/bouncycastle/math/ec/ECPoint;", "xBN", "yBit", "", "privateKeyAdd", "", "privateKey", "add", "publicKeyToAddress", "publicKey", "publicPointFromPrivateKey", "recoverPublicKey", "hash", "r", "s", "recId", "", "toUnsignedByteArray32", "SigningKey", "ethers-crypto"})
@SourceDebugExtension(value={"SMAP\nSecp256k1.kt\nKotlin\n*S Kotlin\n*F\n+ 1 Secp256k1.kt\nio/ethers/crypto/Secp256k1\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,230:1\n1#2:231\n*E\n"})
public final class Secp256k1 {
    @NotNull
    public static final Secp256k1 INSTANCE = new Secp256k1();
    private static final X9ECParameters CURVE_PARAMS = CustomNamedCurves.getByName((String)"secp256k1");
    @NotNull
    private static final ECDomainParameters CURVE = new ECDomainParameters(CURVE_PARAMS.getCurve(), CURVE_PARAMS.getG(), CURVE_PARAMS.getN(), CURVE_PARAMS.getH());
    @NotNull
    private static final BigInteger CURVE_HALF_ORDER;
    @NotNull
    private static final FixedPointCombMultiplier FIXED_POINT_MULTIPLIER;
    @NotNull
    private static final X9IntegerConverter X9_CONVERTER;
    private static final byte UNCOMPRESSED_KEY_FLAG = 4;

    private Secp256k1() {
    }

    @NotNull
    public final byte[] privateKeyAdd(@NotNull byte[] privateKey, @NotNull byte[] add) {
        BigInteger a = new BigInteger(1, privateKey);
        if (a.compareTo(CURVE.getN()) >= 0) {
            throw new IllegalArgumentException("Provided private key is greater than curve order");
        }
        BigInteger b = new BigInteger(1, add);
        BigInteger c = a.add(b).mod(CURVE.getN());
        if (Intrinsics.areEqual((Object)c, (Object)BigInteger.ZERO)) {
            throw new IllegalArgumentException("Resulting private key is zero");
        }
        return this.toUnsignedByteArray32(c);
    }

    @NotNull
    public final ECPoint publicPointFromPrivateKey(@NotNull BigInteger privateKey) {
        BigInteger pk = privateKey;
        if (pk.bitLength() > CURVE.getN().bitLength()) {
            pk = pk.mod(CURVE.getN());
        }
        return FIXED_POINT_MULTIPLIER.multiply(CURVE.getG(), pk);
    }

    @NotNull
    public final byte[] publicKeyToAddress(@NotNull byte[] publicKey) {
        byte[] hash;
        Keccak.Digest256 digest256;
        if (publicKey[0] != 4) {
            throw new IllegalArgumentException("Public key is compressed");
        }
        Keccak.Digest256 $this$publicKeyToAddress_u24lambda_u240 = digest256 = new Keccak.Digest256();
        boolean bl = false;
        $this$publicKeyToAddress_u24lambda_u240.update(publicKey, 1, publicKey.length - 1);
        Keccak.Digest256 keccak = digest256;
        byte[] byArray = hash = keccak.digest();
        int n = hash.length - 20;
        int n2 = hash.length;
        return ArraysKt.copyOfRange((byte[])byArray, (int)n, (int)n2);
    }

    @Nullable
    public final byte[] recoverPublicKey(@NotNull byte[] hash, @NotNull BigInteger r, @NotNull BigInteger s, long recId) {
        BigInteger prime;
        if (recId < 0L) {
            throw new IllegalArgumentException("Parameter 'recId' must be positive.");
        }
        if (r.compareTo(BigInteger.ZERO) < 0) {
            throw new IllegalArgumentException("Parameter 'r' must be positive.");
        }
        if (s.compareTo(BigInteger.ZERO) < 0) {
            throw new IllegalArgumentException("Parameter 's' must be positive.");
        }
        BigInteger n = CURVE.getN();
        BigInteger i = BigInteger.valueOf(recId / (long)2);
        BigInteger x = r.add(i.multiply(n));
        if (x.compareTo(prime = SecP256K1Curve.q) >= 0) {
            return null;
        }
        ECPoint R = this.decompressKey(x, (recId & 1L) == 1L);
        if (!R.multiply(n).isInfinity()) {
            return null;
        }
        BigInteger e = new BigInteger(1, hash);
        BigInteger eInv = BigInteger.ZERO.subtract(e).mod(n);
        BigInteger rInv = r.modInverse(n);
        BigInteger srInv = rInv.multiply(s).mod(n);
        BigInteger eInvrInv = rInv.multiply(eInv).mod(n);
        ECPoint q = ECAlgorithms.sumOfTwoMultiplies((ECPoint)CURVE.getG(), (BigInteger)eInvrInv, (ECPoint)R, (BigInteger)srInv);
        return q.getEncoded(false);
    }

    private final ECPoint decompressKey(BigInteger xBN, boolean yBit) {
        byte[] compEnc = X9_CONVERTER.integerToBytes(xBN, 1 + X9_CONVERTER.getByteLength(CURVE.getCurve()));
        compEnc[0] = (byte)(yBit ? 3 : 2);
        return CURVE.getCurve().decodePoint(compEnc);
    }

    private final byte[] toUnsignedByteArray32(BigInteger $this$toUnsignedByteArray32) {
        byte[] bytes = $this$toUnsignedByteArray32.toByteArray();
        if (bytes.length > 33 || bytes.length == 33 && bytes[0] != 0) {
            throw new IllegalArgumentException("Input is too large to put in byte array of size 32");
        }
        if (bytes.length == 32) {
            return bytes;
        }
        if (bytes.length == 33 && bytes[0] == 0) {
            byte[] byArray = bytes;
            int n = 1;
            int n2 = 33;
            return ArraysKt.copyOfRange((byte[])byArray, (int)n, (int)n2);
        }
        byte[] ret = new byte[32];
        System.arraycopy(bytes, 0, ret, 32 - bytes.length, bytes.length);
        return ret;
    }

    static {
        BigInteger bigInteger = CURVE_PARAMS.getN().shiftRight(1);
        Intrinsics.checkNotNullExpressionValue((Object)bigInteger, (String)"shiftRight(...)");
        CURVE_HALF_ORDER = bigInteger;
        FIXED_POINT_MULTIPLIER = new FixedPointCombMultiplier();
        X9_CONVERTER = new X9IntegerConverter();
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0012\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0011\n\u0002\b\u0003\u0018\u00002\u00020\u0001B\u000f\b\u0016\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\u0019\u0010\u0011\u001a\b\u0012\u0004\u0012\u00020\u00030\u00122\u0006\u0010\u0013\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0014R\u0011\u0010\u0002\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR\u000e\u0010\t\u001a\u00020\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u000b\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\bR\u0011\u0010\r\u001a\u00020\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\u0010\u00a8\u0006\u0015"}, d2={"Lio/ethers/crypto/Secp256k1$SigningKey;", "", "privateKey", "Ljava/math/BigInteger;", "(Ljava/math/BigInteger;)V", "", "([B)V", "getPrivateKey", "()[B", "privateKeyParams", "Lorg/bouncycastle/crypto/params/ECPrivateKeyParameters;", "publicKey", "getPublicKey", "publicPoint", "Lorg/bouncycastle/math/ec/ECPoint;", "getPublicPoint", "()Lorg/bouncycastle/math/ec/ECPoint;", "signHash", "", "hash", "([B)[Ljava/math/BigInteger;", "ethers-crypto"})
    public static final class SigningKey {
        @NotNull
        private final byte[] privateKey;
        @NotNull
        private final ECPrivateKeyParameters privateKeyParams;
        @NotNull
        private final ECPoint publicPoint;
        @NotNull
        private final byte[] publicKey;

        public SigningKey(@NotNull byte[] privateKey) {
            this.privateKey = privateKey;
            this.privateKeyParams = new ECPrivateKeyParameters(new BigInteger(1, this.privateKey), CURVE);
            ECPoint point = INSTANCE.publicPointFromPrivateKey(this.privateKeyParams.getD());
            byte[] encoded = point.getEncoded(false);
            if (encoded[0] != 4) {
                throw new IllegalArgumentException("Invalid encoded point. Expected 0x04 prefix, got " + encoded[0]);
            }
            this.publicPoint = point;
            this.publicKey = encoded;
        }

        @NotNull
        public final byte[] getPrivateKey() {
            return this.privateKey;
        }

        public SigningKey(@NotNull BigInteger privateKey) {
            this(INSTANCE.toUnsignedByteArray32(privateKey));
        }

        @NotNull
        public final ECPoint getPublicPoint() {
            return this.publicPoint;
        }

        @NotNull
        public final byte[] getPublicKey() {
            return this.publicKey;
        }

        @NotNull
        public final BigInteger[] signHash(@NotNull byte[] hash) {
            BigInteger v;
            ECDSASignerRecoverable signer = new ECDSASignerRecoverable((DSAKCalculator)new HMacDSAKCalculator((Digest)new SHA256Digest()));
            signer.init(true, (CipherParameters)this.privateKeyParams);
            BigInteger[] sig = signer.generateSignatureWithY(hash);
            boolean yIsEven = Intrinsics.areEqual((Object)sig[2].and(BigInteger.ONE), (Object)BigInteger.ZERO);
            if (sig[1].compareTo(CURVE_HALF_ORDER) > 0) {
                sig[1] = CURVE.getN().subtract(sig[1]);
                yIsEven = !yIsEven;
            }
            sig[2] = v = yIsEven ? BigInteger.ZERO : BigInteger.ONE;
            return sig;
        }
    }
}

