/*
 * Decompiled with CFR 0.152.
 */
package io.ethers.abi.call;

import io.ethers.abi.call.ReadContractCall;
import io.ethers.core.Result;
import io.ethers.core.types.Address;
import io.ethers.core.types.Bytes;
import io.ethers.core.types.CallRequest;
import io.ethers.core.types.transaction.TransactionSigned;
import io.ethers.core.types.transaction.TransactionUnsigned;
import io.ethers.core.types.transaction.TxAccessList;
import io.ethers.core.types.transaction.TxDynamicFee;
import io.ethers.core.types.transaction.TxLegacy;
import io.ethers.providers.RpcError;
import io.ethers.providers.middleware.Middleware;
import io.ethers.providers.types.PendingInclusion;
import io.ethers.providers.types.PendingTransaction;
import io.ethers.providers.types.RpcRequest;
import io.ethers.signers.Signer;
import java.math.BigInteger;
import java.util.List;
import kotlin.Function;
import kotlin.Metadata;
import kotlin.jvm.internal.FunctionAdapter;
import kotlin.jvm.internal.FunctionReferenceImpl;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000D\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\b&\u0018\u0000*\u0004\b\u0000\u0010\u0001*\f\b\u0001\u0010\u0002*\u0006\u0012\u0002\b\u00030\u0003*\u001a\b\u0002\u0010\u0004*\u0014\u0012\u0004\u0012\u0002H\u0001\u0012\u0004\u0012\u0002H\u0002\u0012\u0004\u0012\u0002H\u00040\u00002\u000e\u0012\u0004\u0012\u0002H\u0001\u0012\u0004\u0012\u0002H\u00040\u0005B\r\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0002\u0010\bJ\u0015\u0010\t\u001a\u00028\u00012\u0006\u0010\n\u001a\u00020\u000bH$\u00a2\u0006\u0002\u0010\fJ\u001a\u0010\r\u001a\u000e\u0012\u0004\u0012\u00028\u0001\u0012\u0004\u0012\u00020\u000f0\u000e2\u0006\u0010\u0010\u001a\u00020\u0011J\u0010\u0010\u0012\u001a\u0004\u0018\u00010\u00132\u0006\u0010\u0010\u001a\u00020\u0011J\u000e\u0010\u0014\u001a\u0004\u0018\u00010\u0015*\u00020\u0016H\u0002\u00a8\u0006\u0017"}, d2={"Lio/ethers/abi/call/ReadWriteContractCall;", "C", "S", "Lio/ethers/providers/types/PendingInclusion;", "B", "Lio/ethers/abi/call/ReadContractCall;", "provider", "Lio/ethers/providers/middleware/Middleware;", "(Lio/ethers/providers/middleware/Middleware;)V", "handleSendResult", "result", "Lio/ethers/providers/types/PendingTransaction;", "(Lio/ethers/providers/types/PendingTransaction;)Lio/ethers/providers/types/PendingInclusion;", "send", "Lio/ethers/providers/types/RpcRequest;", "Lio/ethers/providers/RpcError;", "signer", "Lio/ethers/signers/Signer;", "sign", "Lio/ethers/core/types/transaction/TransactionSigned;", "toTransaction", "Lio/ethers/core/types/transaction/TransactionUnsigned;", "Lio/ethers/core/types/CallRequest;", "ethers-abi"})
public abstract class ReadWriteContractCall<C, S extends PendingInclusion<?>, B extends ReadWriteContractCall<C, S, B>>
extends ReadContractCall<C, B> {
    public ReadWriteContractCall(@NotNull Middleware provider) {
        super(provider);
    }

    @Nullable
    public final TransactionSigned sign(@NotNull Signer signer) {
        TransactionUnsigned transactionUnsigned = this.toTransaction(this.getCall().from(signer.getAddress()));
        if (transactionUnsigned == null) {
            return null;
        }
        TransactionUnsigned tx = transactionUnsigned;
        return signer.signTransaction(tx);
    }

    @NotNull
    public final RpcRequest<S, RpcError> send(@NotNull Signer signer) {
        TransactionSigned signed = this.sign(signer);
        if (signed != null) {
            return this.getProvider().sendRawTransaction(signed).map(new Result.Transformer(this){
                final /* synthetic */ ReadWriteContractCall<C, S, B> $tmp0;
                {
                    this.$tmp0 = $tmp0;
                }

                @NotNull
                public final S invoke(@NotNull PendingTransaction p0) {
                    return this.$tmp0.handleSendResult(p0);
                }

                @NotNull
                public final Function<?> getFunctionDelegate() {
                    return (Function)new FunctionReferenceImpl(1, this.$tmp0, ReadWriteContractCall.class, "handleSendResult", "handleSendResult(Lio/ethers/providers/types/PendingTransaction;)Lio/ethers/providers/types/PendingInclusion;", 0);
                }

                public final boolean equals(@Nullable Object other) {
                    return other instanceof Result.Transformer ? (other instanceof FunctionAdapter ? Intrinsics.areEqual(this.getFunctionDelegate(), (Object)((FunctionAdapter)other).getFunctionDelegate()) : false) : false;
                }

                public final int hashCode() {
                    return this.getFunctionDelegate().hashCode();
                }
            });
        }
        return this.getProvider().fillTransaction(this.getCall()).andThen(arg_0 -> ReadWriteContractCall.send$lambda$0(signer, this, arg_0));
    }

    @NotNull
    protected abstract S handleSendResult(@NotNull PendingTransaction var1);

    private final TransactionUnsigned toTransaction(CallRequest $this$toTransaction) {
        if ($this$toTransaction.getNonce() < 0L) {
            return null;
        }
        if ($this$toTransaction.getGas() < 21000L) {
            return null;
        }
        if ($this$toTransaction.getGasFeeCap() != null && $this$toTransaction.getGasTipCap() != null) {
            Address address = $this$toTransaction.getTo();
            BigInteger bigInteger = $this$toTransaction.getValue();
            if (bigInteger == null) {
                bigInteger = BigInteger.ZERO;
            }
            long l = $this$toTransaction.getNonce();
            long l2 = $this$toTransaction.getGas();
            BigInteger bigInteger2 = $this$toTransaction.getGasFeeCap();
            Intrinsics.checkNotNull((Object)bigInteger2);
            BigInteger bigInteger3 = $this$toTransaction.getGasTipCap();
            Intrinsics.checkNotNull((Object)bigInteger3);
            return (TransactionUnsigned)new TxDynamicFee(address, bigInteger, l, l2, bigInteger2, bigInteger3, $this$toTransaction.getData(), $this$toTransaction.getChainId(), $this$toTransaction.getAccessList());
        }
        if ($this$toTransaction.getGasPrice() != null) {
            if ($this$toTransaction.getAccessList() != null) {
                Address address = $this$toTransaction.getTo();
                BigInteger bigInteger = $this$toTransaction.getValue();
                if (bigInteger == null) {
                    bigInteger = BigInteger.ZERO;
                }
                long l = $this$toTransaction.getNonce();
                long l3 = $this$toTransaction.getGas();
                BigInteger bigInteger4 = $this$toTransaction.getGasPrice();
                Intrinsics.checkNotNull((Object)bigInteger4);
                Bytes bytes = $this$toTransaction.getData();
                long l4 = $this$toTransaction.getChainId();
                List list = $this$toTransaction.getAccessList();
                Intrinsics.checkNotNull((Object)list);
                return (TransactionUnsigned)new TxAccessList(address, bigInteger, l, l3, bigInteger4, bytes, l4, list);
            }
            Address address = $this$toTransaction.getTo();
            BigInteger bigInteger = $this$toTransaction.getValue();
            if (bigInteger == null) {
                bigInteger = BigInteger.ZERO;
            }
            long l = $this$toTransaction.getNonce();
            long l5 = $this$toTransaction.getGas();
            BigInteger bigInteger5 = $this$toTransaction.getGasPrice();
            Intrinsics.checkNotNull((Object)bigInteger5);
            return (TransactionUnsigned)new TxLegacy(address, bigInteger, l, l5, bigInteger5, $this$toTransaction.getData(), $this$toTransaction.getChainId());
        }
        return null;
    }

    private static final Result send$lambda$0(Signer $signer, ReadWriteContractCall this$0, TransactionUnsigned unsigned) {
        TransactionSigned tx = $signer.signTransaction(unsigned);
        return this$0.getProvider().sendRawTransaction(tx).map(new Result.Transformer(this$0){
            final /* synthetic */ ReadWriteContractCall<C, S, B> $tmp0;
            {
                this.$tmp0 = $tmp0;
            }

            @NotNull
            public final S invoke(@NotNull PendingTransaction p0) {
                return this.$tmp0.handleSendResult(p0);
            }

            @NotNull
            public final Function<?> getFunctionDelegate() {
                return (Function)new FunctionReferenceImpl(1, this.$tmp0, ReadWriteContractCall.class, "handleSendResult", "handleSendResult(Lio/ethers/providers/types/PendingTransaction;)Lio/ethers/providers/types/PendingInclusion;", 0);
            }

            public final boolean equals(@Nullable Object other) {
                return other instanceof Result.Transformer ? (other instanceof FunctionAdapter ? Intrinsics.areEqual(this.getFunctionDelegate(), (Object)((FunctionAdapter)other).getFunctionDelegate()) : false) : false;
            }

            public final int hashCode() {
                return this.getFunctionDelegate().hashCode();
            }
        }).sendAwait();
    }
}

