/*
 * Decompiled with CFR 0.152.
 */
package io.ethers.abi.call;

import io.ethers.abi.AbiContract;
import io.ethers.abi.call.CallDeploy;
import io.ethers.abi.call.ConstructorCallKt;
import io.ethers.abi.call.PendingContractDeploy;
import io.ethers.abi.call.ReadWriteContractCall;
import io.ethers.abi.error.ContractError;
import io.ethers.core.Result;
import io.ethers.core.types.Address;
import io.ethers.core.types.Bytes;
import io.ethers.providers.middleware.Middleware;
import io.ethers.providers.types.PendingTransaction;
import java.math.BigInteger;
import java.util.function.BiFunction;
import kotlin.Metadata;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000J\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\u0018\u0000*\b\b\u0000\u0010\u0001*\u00020\u00022 \u0012\u0004\u0012\u00020\u0004\u0012\n\u0012\b\u0012\u0004\u0012\u0002H\u00010\u0005\u0012\n\u0012\b\u0012\u0004\u0012\u0002H\u00010\u00000\u0003B/\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\t\u0012\u0018\u0010\n\u001a\u0014\u0012\u0004\u0012\u00020\u0007\u0012\u0004\u0012\u00020\f\u0012\u0004\u0012\u00028\u00000\u000b\u00a2\u0006\u0002\u0010\rJ\u001c\u0010\u0017\u001a\u000e\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\u00190\u00182\u0006\u0010\u001a\u001a\u00020\tH\u0014J\u0016\u0010\u001b\u001a\b\u0012\u0004\u0012\u00028\u00000\u00052\u0006\u0010\u001a\u001a\u00020\u001cH\u0014J\u0016\u0010\u0011\u001a\b\u0012\u0004\u0012\u00028\u00000\u00002\b\u0010\u0011\u001a\u0004\u0018\u00010\u0012R \u0010\n\u001a\u0014\u0012\u0004\u0012\u00020\u0007\u0012\u0004\u0012\u00020\f\u0012\u0004\u0012\u00028\u00000\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u000e\u001a\b\u0012\u0004\u0012\u00028\u00000\u00008TX\u0094\u0004\u00a2\u0006\u0006\u001a\u0004\b\u000f\u0010\u0010R(\u0010\u0011\u001a\u0004\u0018\u00010\u00122\b\u0010\u0011\u001a\u0004\u0018\u00010\u00128F@FX\u0086\u000e\u00a2\u0006\f\u001a\u0004\b\u0013\u0010\u0014\"\u0004\b\u0015\u0010\u0016\u00a8\u0006\u001d"}, d2={"Lio/ethers/abi/call/PayableConstructorCall;", "T", "Lio/ethers/abi/AbiContract;", "Lio/ethers/abi/call/ReadWriteContractCall;", "Lio/ethers/abi/call/CallDeploy;", "Lio/ethers/abi/call/PendingContractDeploy;", "provider", "Lio/ethers/providers/middleware/Middleware;", "bytecode", "Lio/ethers/core/types/Bytes;", "constructor", "Ljava/util/function/BiFunction;", "Lio/ethers/core/types/Address;", "(Lio/ethers/providers/middleware/Middleware;Lio/ethers/core/types/Bytes;Ljava/util/function/BiFunction;)V", "self", "getSelf", "()Lio/ethers/abi/call/PayableConstructorCall;", "value", "Ljava/math/BigInteger;", "getValue", "()Ljava/math/BigInteger;", "setValue", "(Ljava/math/BigInteger;)V", "handleCallResult", "Lio/ethers/core/Result;", "Lio/ethers/abi/error/ContractError;", "result", "handleSendResult", "Lio/ethers/providers/types/PendingTransaction;", "ethers-abi"})
public final class PayableConstructorCall<T extends AbiContract>
extends ReadWriteContractCall<CallDeploy, PendingContractDeploy<T>, PayableConstructorCall<T>> {
    @NotNull
    private final BiFunction<Middleware, Address, T> constructor;

    public PayableConstructorCall(@NotNull Middleware provider, @NotNull Bytes bytecode, @NotNull BiFunction<Middleware, Address, T> constructor) {
        super(provider);
        this.constructor = constructor;
        this.getCall().setTo(null);
        this.getCall().setFrom(Address.ZERO);
        this.getCall().setNonce(0L);
        this.getCall().setData(bytecode);
    }

    @Override
    @NotNull
    protected PayableConstructorCall<T> getSelf() {
        return this;
    }

    @Override
    @NotNull
    protected Result<CallDeploy, ContractError> handleCallResult(@NotNull Bytes result) {
        return ConstructorCallKt.access$handleCallResult(this.getCall(), result);
    }

    @Override
    @NotNull
    protected PendingContractDeploy<T> handleSendResult(@NotNull PendingTransaction result) {
        return ConstructorCallKt.access$handleSendResult(this.getProvider(), result, this.constructor);
    }

    @Nullable
    public final BigInteger getValue() {
        return this.getCall().getValue();
    }

    public final /* synthetic */ void setValue(BigInteger value) {
        this.getCall().setValue(value);
    }

    @NotNull
    public final PayableConstructorCall<T> value(@Nullable BigInteger value) {
        this.getCall().setValue(value);
        return this;
    }
}

