/*
 * Decompiled with CFR 0.152.
 */
package io.ethers.abi;

import io.ethers.abi.AbiType;
import io.ethers.abi.ContractStruct;
import io.ethers.abi.StructFactory;
import io.ethers.crypto.Hashing;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.function.Function;
import kotlin.Metadata;
import kotlin.collections.ArraysKt;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.JvmClassMappingKt;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.reflect.KClass;
import kotlin.reflect.full.KClasses;
import kotlin.text.Charsets;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000L\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\f\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\bv\u0018\u0000 \u00112\u00020\u0001:\u000b\r\u000e\u000f\u0010\u0011\u0012\u0013\u0014\u0015\u0016\u0017R\u0012\u0010\u0002\u001a\u00020\u0003X\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0004\u0010\u0005R\u0016\u0010\u0006\u001a\u0006\u0012\u0002\b\u00030\u0007X\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\b\u0010\tR\u0012\u0010\n\u001a\u00020\u000bX\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\n\u0010\f\u0082\u0001\n\u0018\u0019\u001a\u001b\u001c\u001d\u001e\u001f !\u00f8\u0001\u0000\u0082\u0002\u0006\n\u0004\b!0\u0001\u00a8\u0006\"\u00c0\u0006\u0001"}, d2={"Lio/ethers/abi/AbiType;", "", "abiType", "", "getAbiType", "()Ljava/lang/String;", "classType", "Ljava/lang/Class;", "getClassType", "()Ljava/lang/Class;", "isDynamic", "", "()Z", "Address", "Array", "Bool", "Bytes", "Companion", "FixedArray", "FixedBytes", "Int", "String", "Tuple", "UInt", "Lio/ethers/abi/AbiType$Address;", "Lio/ethers/abi/AbiType$Array;", "Lio/ethers/abi/AbiType$Bool;", "Lio/ethers/abi/AbiType$Bytes;", "Lio/ethers/abi/AbiType$FixedArray;", "Lio/ethers/abi/AbiType$FixedBytes;", "Lio/ethers/abi/AbiType$Int;", "Lio/ethers/abi/AbiType$String;", "Lio/ethers/abi/AbiType$Tuple;", "Lio/ethers/abi/AbiType$UInt;", "ethers-abi"})
public interface AbiType {
    @NotNull
    public static final Companion Companion = io.ethers.abi.AbiType$Companion.$$INSTANCE;

    @NotNull
    public java.lang.String getAbiType();

    @NotNull
    public Class<?> getClassType();

    public boolean isDynamic();

    @JvmStatic
    @NotNull
    public static byte[] computeSignatureHash(@NotNull java.lang.String name, @NotNull List<? extends AbiType> types) {
        return Companion.computeSignatureHash(name, types);
    }

    @JvmStatic
    @NotNull
    public static java.lang.String canonicalSignature(@NotNull java.lang.String name, @NotNull List<? extends AbiType> types) {
        return Companion.canonicalSignature(name, types);
    }

    @JvmStatic
    @NotNull
    public static AbiType parseType(@NotNull java.lang.String signature) {
        return Companion.parseType(signature);
    }

    @JvmStatic
    @NotNull
    public static List<AbiType> parseSignature(@NotNull java.lang.String signature) {
        return Companion.parseSignature(signature);
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\b\u00c6\n\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0013\u0010\u000e\u001a\u00020\f2\b\u0010\u000f\u001a\u0004\u0018\u00010\u0010H\u00d6\u0003J\t\u0010\u0011\u001a\u00020\u0012H\u00d6\u0001J\t\u0010\u0013\u001a\u00020\u0004H\u00d6\u0001R\u0014\u0010\u0003\u001a\u00020\u0004X\u0096D\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006R\u0018\u0010\u0007\u001a\u0006\u0012\u0002\b\u00030\bX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\nR\u0014\u0010\u000b\u001a\u00020\fX\u0096D\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\r\u00a8\u0006\u0014"}, d2={"Lio/ethers/abi/AbiType$Address;", "Lio/ethers/abi/AbiType;", "()V", "abiType", "", "getAbiType", "()Ljava/lang/String;", "classType", "Ljava/lang/Class;", "getClassType", "()Ljava/lang/Class;", "isDynamic", "", "()Z", "equals", "other", "", "hashCode", "", "toString", "ethers-abi"})
    public static final class Address
    implements AbiType {
        @NotNull
        public static final Address INSTANCE = new Address();
        @NotNull
        private static final java.lang.String abiType = "address";
        @NotNull
        private static final Class<?> classType = io.ethers.core.types.Address.class;
        private static final boolean isDynamic;

        private Address() {
        }

        @Override
        @NotNull
        public java.lang.String getAbiType() {
            return abiType;
        }

        @Override
        @NotNull
        public Class<?> getClassType() {
            return classType;
        }

        @Override
        public boolean isDynamic() {
            return isDynamic;
        }

        @NotNull
        public java.lang.String toString() {
            return "Address";
        }

        public int hashCode() {
            return 345157513;
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof Address)) {
                return false;
            }
            Address cfr_ignored_0 = (Address)other;
            return true;
        }
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0007\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\b\u0086\b\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0001\u00a2\u0006\u0002\u0010\u0003J\t\u0010\u0011\u001a\u00020\u0001H\u00c6\u0003J\u0013\u0010\u0012\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u0001H\u00c6\u0001J\u0013\u0010\u0013\u001a\u00020\r2\b\u0010\u0014\u001a\u0004\u0018\u00010\u0015H\u00d6\u0003J\t\u0010\u0016\u001a\u00020\u0017H\u00d6\u0001J\t\u0010\u0018\u001a\u00020\u0005H\u00d6\u0001R\u0014\u0010\u0004\u001a\u00020\u0005X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007R\u0018\u0010\b\u001a\u0006\u0012\u0002\b\u00030\tX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000bR\u0014\u0010\f\u001a\u00020\rX\u0096D\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\u000eR\u0011\u0010\u0002\u001a\u00020\u0001\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\u0010\u00a8\u0006\u0019"}, d2={"Lio/ethers/abi/AbiType$Array;", "Lio/ethers/abi/AbiType;", "type", "(Lio/ethers/abi/AbiType;)V", "abiType", "", "getAbiType", "()Ljava/lang/String;", "classType", "Ljava/lang/Class;", "getClassType", "()Ljava/lang/Class;", "isDynamic", "", "()Z", "getType", "()Lio/ethers/abi/AbiType;", "component1", "copy", "equals", "other", "", "hashCode", "", "toString", "ethers-abi"})
    public static final class Array
    implements AbiType {
        @NotNull
        private final AbiType type;
        @NotNull
        private final java.lang.String abiType;
        @NotNull
        private final Class<?> classType;
        private final boolean isDynamic;

        public Array(@NotNull AbiType type) {
            this.type = type;
            this.abiType = this.type.getAbiType() + "[]";
            this.classType = java.lang.reflect.Array.newInstance(this.type.getClassType(), 0).getClass();
            this.isDynamic = true;
        }

        @NotNull
        public final AbiType getType() {
            return this.type;
        }

        @Override
        @NotNull
        public java.lang.String getAbiType() {
            return this.abiType;
        }

        @Override
        @NotNull
        public Class<?> getClassType() {
            return this.classType;
        }

        @Override
        public boolean isDynamic() {
            return this.isDynamic;
        }

        @NotNull
        public final AbiType component1() {
            return this.type;
        }

        @NotNull
        public final Array copy(@NotNull AbiType type) {
            return new Array(type);
        }

        public static /* synthetic */ Array copy$default(Array array, AbiType abiType, int n, Object object) {
            if ((n & 1) != 0) {
                abiType = array.type;
            }
            return array.copy(abiType);
        }

        @NotNull
        public java.lang.String toString() {
            return "Array(type=" + this.type + ")";
        }

        public int hashCode() {
            return this.type.hashCode();
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof Array)) {
                return false;
            }
            Array array = (Array)other;
            return Intrinsics.areEqual((Object)this.type, (Object)array.type);
        }
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\b\u00c6\n\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0013\u0010\u000e\u001a\u00020\f2\b\u0010\u000f\u001a\u0004\u0018\u00010\u0010H\u00d6\u0003J\t\u0010\u0011\u001a\u00020\u0012H\u00d6\u0001J\t\u0010\u0013\u001a\u00020\u0004H\u00d6\u0001R\u0014\u0010\u0003\u001a\u00020\u0004X\u0096D\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006R\u0018\u0010\u0007\u001a\u0006\u0012\u0002\b\u00030\bX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\nR\u0014\u0010\u000b\u001a\u00020\fX\u0096D\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\r\u00a8\u0006\u0014"}, d2={"Lio/ethers/abi/AbiType$Bool;", "Lio/ethers/abi/AbiType;", "()V", "abiType", "", "getAbiType", "()Ljava/lang/String;", "classType", "Ljava/lang/Class;", "getClassType", "()Ljava/lang/Class;", "isDynamic", "", "()Z", "equals", "other", "", "hashCode", "", "toString", "ethers-abi"})
    public static final class Bool
    implements AbiType {
        @NotNull
        public static final Bool INSTANCE = new Bool();
        @NotNull
        private static final java.lang.String abiType = "bool";
        @NotNull
        private static final Class<?> classType = Boolean.TYPE;
        private static final boolean isDynamic;

        private Bool() {
        }

        @Override
        @NotNull
        public java.lang.String getAbiType() {
            return abiType;
        }

        @Override
        @NotNull
        public Class<?> getClassType() {
            return classType;
        }

        @Override
        public boolean isDynamic() {
            return isDynamic;
        }

        @NotNull
        public java.lang.String toString() {
            return "Bool";
        }

        public int hashCode() {
            return -1885546635;
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof Bool)) {
                return false;
            }
            Bool cfr_ignored_0 = (Bool)other;
            return true;
        }
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\b\u00c6\n\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0013\u0010\u000e\u001a\u00020\f2\b\u0010\u000f\u001a\u0004\u0018\u00010\u0010H\u00d6\u0003J\t\u0010\u0011\u001a\u00020\u0012H\u00d6\u0001J\t\u0010\u0013\u001a\u00020\u0004H\u00d6\u0001R\u0014\u0010\u0003\u001a\u00020\u0004X\u0096D\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006R\u0018\u0010\u0007\u001a\u0006\u0012\u0002\b\u00030\bX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\nR\u0014\u0010\u000b\u001a\u00020\fX\u0096D\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\r\u00a8\u0006\u0014"}, d2={"Lio/ethers/abi/AbiType$Bytes;", "Lio/ethers/abi/AbiType;", "()V", "abiType", "", "getAbiType", "()Ljava/lang/String;", "classType", "Ljava/lang/Class;", "getClassType", "()Ljava/lang/Class;", "isDynamic", "", "()Z", "equals", "other", "", "hashCode", "", "toString", "ethers-abi"})
    public static final class Bytes
    implements AbiType {
        @NotNull
        public static final Bytes INSTANCE = new Bytes();
        @NotNull
        private static final java.lang.String abiType = "bytes";
        @NotNull
        private static final Class<?> classType = io.ethers.core.types.Bytes.class;
        private static final boolean isDynamic = true;

        private Bytes() {
        }

        @Override
        @NotNull
        public java.lang.String getAbiType() {
            return abiType;
        }

        @Override
        @NotNull
        public Class<?> getClassType() {
            return classType;
        }

        @Override
        public boolean isDynamic() {
            return isDynamic;
        }

        @NotNull
        public java.lang.String toString() {
            return "Bytes";
        }

        public int hashCode() {
            return 1677899072;
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof Bytes)) {
                return false;
            }
            Bytes cfr_ignored_0 = (Bytes)other;
            return true;
        }
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u0011\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0012\n\u0002\b\u0005\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u001e\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\u00072\f\u0010\t\u001a\b\u0012\u0004\u0012\u00020\u000b0\nH\u0007J\u001e\u0010\f\u001a\u00020\r2\u0006\u0010\b\u001a\u00020\u00072\f\u0010\t\u001a\b\u0012\u0004\u0012\u00020\u000b0\nH\u0007J\u0010\u0010\u000e\u001a\u00020\u00072\u0006\u0010\u000f\u001a\u00020\u0007H\u0002J\u0016\u0010\u0010\u001a\b\u0012\u0004\u0012\u00020\u000b0\n2\u0006\u0010\u000f\u001a\u00020\u0007H\u0007J\u0010\u0010\u0011\u001a\u00020\u000b2\u0006\u0010\u000f\u001a\u00020\u0007H\u0007R\u001c\u0010\u0003\u001a\u0010\u0012\f\b\u0001\u0012\b\u0012\u0004\u0012\u00020\u00010\u00050\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0012"}, d2={"Lio/ethers/abi/AbiType$Companion;", "", "()V", "CLASS_TYPE_TUPLE", "Ljava/lang/Class;", "", "canonicalSignature", "", "name", "types", "", "Lio/ethers/abi/AbiType;", "computeSignatureHash", "", "getNextType", "signature", "parseSignature", "parseType", "ethers-abi"})
    @SourceDebugExtension(value={"SMAP\nAbiType.kt\nKotlin\n*S Kotlin\n*F\n+ 1 AbiType.kt\nio/ethers/abi/AbiType$Companion\n+ 2 ArrayIntrinsics.kt\nkotlin/ArrayIntrinsicsKt\n*L\n1#1,311:1\n26#2:312\n*S KotlinDebug\n*F\n+ 1 AbiType.kt\nio/ethers/abi/AbiType$Companion\n*L\n213#1:312\n*E\n"})
    public static final class Companion {
        static final /* synthetic */ Companion $$INSTANCE;
        @NotNull
        private static final Class<? extends Object[]> CLASS_TYPE_TUPLE;

        private Companion() {
        }

        @JvmStatic
        @NotNull
        public final byte[] computeSignatureHash(@NotNull java.lang.String name, @NotNull List<? extends AbiType> types) {
            byte[] byArray = this.canonicalSignature(name, types).getBytes(Charsets.UTF_8);
            Intrinsics.checkNotNullExpressionValue((Object)byArray, (java.lang.String)"getBytes(...)");
            return Hashing.keccak256((byte[])byArray);
        }

        @JvmStatic
        @NotNull
        public final java.lang.String canonicalSignature(@NotNull java.lang.String name, @NotNull List<? extends AbiType> types) {
            return name + "(" + CollectionsKt.joinToString$default((Iterable)types, (CharSequence)",", null, null, (int)0, null, (Function1)canonicalSignature.1.INSTANCE, (int)30, null) + ")";
        }

        @JvmStatic
        @NotNull
        public final AbiType parseType(@NotNull java.lang.String signature) {
            List<AbiType> types = this.parseSignature(signature);
            if (types.size() != 1) {
                throw new IllegalArgumentException("Expected a single type, got: " + signature);
            }
            return (AbiType)CollectionsKt.single(types);
        }

        @JvmStatic
        @NotNull
        public final List<AbiType> parseSignature(@NotNull java.lang.String signature) {
            java.lang.String signature2 = StringsKt.replace$default((java.lang.String)signature, (java.lang.String)" ", (java.lang.String)"", (boolean)false, (int)4, null);
            ArrayList<AbiType> result = new ArrayList<AbiType>();
            java.lang.String rawType = this.getNextType(signature2);
            while (!StringsKt.isBlank((CharSequence)rawType)) {
                AbiType type;
                switch (rawType) {
                    case "address": {
                        AbiType abiType = Address.INSTANCE;
                        break;
                    }
                    case "bytes": {
                        AbiType abiType = Bytes.INSTANCE;
                        break;
                    }
                    case "int": {
                        AbiType abiType = new Int(256);
                        break;
                    }
                    case "uint": {
                        AbiType abiType = new UInt(256);
                        break;
                    }
                    case "bool": {
                        AbiType abiType = Bool.INSTANCE;
                        break;
                    }
                    case "string": {
                        AbiType abiType = String.INSTANCE;
                        break;
                    }
                    default: {
                        AbiType abiType = type = null;
                    }
                }
                if (type != null) {
                    result.add(type);
                } else if (StringsKt.startsWith$default((java.lang.String)rawType, (java.lang.String)"(", (boolean)false, (int)2, null) && StringsKt.endsWith$default((java.lang.String)rawType, (java.lang.String)")", (boolean)false, (int)2, null)) {
                    java.lang.String string = rawType.substring(1, rawType.length() - 1);
                    Intrinsics.checkNotNullExpressionValue((Object)string, (java.lang.String)"substring(...)");
                    List<AbiType> types = this.parseSignature(string);
                    result.add(Tuple.Companion.raw(types));
                } else if (StringsKt.endsWith$default((java.lang.String)rawType, (java.lang.String)"[]", (boolean)false, (int)2, null)) {
                    java.lang.String string = rawType.substring(0, rawType.length() - 2);
                    Intrinsics.checkNotNullExpressionValue((Object)string, (java.lang.String)"substring(...)");
                    result.add(new Array((AbiType)CollectionsKt.first(this.parseSignature(string))));
                } else if (StringsKt.contains$default((CharSequence)rawType, (CharSequence)"[", (boolean)false, (int)2, null)) {
                    int index = StringsKt.lastIndexOf$default((CharSequence)rawType, (java.lang.String)"[", (int)0, (boolean)false, (int)6, null);
                    java.lang.String string = rawType.substring(index + 1, rawType.length() - 1);
                    Intrinsics.checkNotNullExpressionValue((Object)string, (java.lang.String)"substring(...)");
                    int length = Integer.parseInt(string);
                    java.lang.String string2 = rawType.substring(0, index);
                    Intrinsics.checkNotNullExpressionValue((Object)string2, (java.lang.String)"substring(...)");
                    result.add(new FixedArray(length, (AbiType)CollectionsKt.first(this.parseSignature(string2))));
                } else if (StringsKt.startsWith$default((java.lang.String)rawType, (java.lang.String)"int", (boolean)false, (int)2, null)) {
                    java.lang.String string = rawType.substring(3);
                    Intrinsics.checkNotNullExpressionValue((Object)string, (java.lang.String)"substring(...)");
                    int bitSize = Integer.parseInt(string);
                    result.add(new Int(bitSize));
                } else if (StringsKt.startsWith$default((java.lang.String)rawType, (java.lang.String)"uint", (boolean)false, (int)2, null)) {
                    java.lang.String string = rawType.substring(4);
                    Intrinsics.checkNotNullExpressionValue((Object)string, (java.lang.String)"substring(...)");
                    int bitSize = Integer.parseInt(string);
                    result.add(new UInt(bitSize));
                } else if (StringsKt.startsWith$default((java.lang.String)rawType, (java.lang.String)"bytes", (boolean)false, (int)2, null)) {
                    java.lang.String string = rawType.substring(5);
                    Intrinsics.checkNotNullExpressionValue((Object)string, (java.lang.String)"substring(...)");
                    int length = Integer.parseInt(string);
                    result.add(new FixedBytes(length));
                } else {
                    throw new IllegalArgumentException("Invalid token type: " + rawType);
                }
                signature2 = StringsKt.removePrefix((java.lang.String)StringsKt.removePrefix((java.lang.String)signature2, (CharSequence)rawType), (CharSequence)",");
                rawType = this.getNextType(signature2);
            }
            return result;
        }

        private final java.lang.String getNextType(java.lang.String signature) {
            int nestingDepth = 0;
            int n = signature.length();
            for (int i = 0; i < n; ++i) {
                char c = signature.charAt(i);
                if (c == '(') {
                    ++nestingDepth;
                    continue;
                }
                if (c == ')') {
                    --nestingDepth;
                    continue;
                }
                if (c != ',' || nestingDepth != 0) continue;
                java.lang.String string = signature.substring(0, i);
                Intrinsics.checkNotNullExpressionValue((Object)string, (java.lang.String)"substring(...)");
                return string;
            }
            return signature;
        }

        static {
            $$INSTANCE = new Companion();
            boolean $i$f$emptyArray = false;
            CLASS_TYPE_TUPLE = new Object[0].getClass();
        }
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\n\n\u0002\u0010\u0000\n\u0002\b\u0003\b\u0086\b\u0018\u00002\u00020\u0001B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0001\u00a2\u0006\u0002\u0010\u0005J\t\u0010\u0015\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\u0016\u001a\u00020\u0001H\u00c6\u0003J\u001d\u0010\u0017\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u0001H\u00c6\u0001J\u0013\u0010\u0018\u001a\u00020\u000f2\b\u0010\u0019\u001a\u0004\u0018\u00010\u001aH\u00d6\u0003J\t\u0010\u001b\u001a\u00020\u0003H\u00d6\u0001J\t\u0010\u001c\u001a\u00020\u0007H\u00d6\u0001R\u0014\u0010\u0006\u001a\u00020\u0007X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR\u0018\u0010\n\u001a\u0006\u0012\u0002\b\u00030\u000bX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\rR\u0014\u0010\u000e\u001a\u00020\u000fX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u0010R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0011\u0010\u0012R\u0011\u0010\u0004\u001a\u00020\u0001\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0013\u0010\u0014\u00a8\u0006\u001d"}, d2={"Lio/ethers/abi/AbiType$FixedArray;", "Lio/ethers/abi/AbiType;", "length", "", "type", "(ILio/ethers/abi/AbiType;)V", "abiType", "", "getAbiType", "()Ljava/lang/String;", "classType", "Ljava/lang/Class;", "getClassType", "()Ljava/lang/Class;", "isDynamic", "", "()Z", "getLength", "()I", "getType", "()Lio/ethers/abi/AbiType;", "component1", "component2", "copy", "equals", "other", "", "hashCode", "toString", "ethers-abi"})
    public static final class FixedArray
    implements AbiType {
        private final int length;
        @NotNull
        private final AbiType type;
        @NotNull
        private final java.lang.String abiType;
        @NotNull
        private final Class<?> classType;
        private final boolean isDynamic;

        public FixedArray(int length, @NotNull AbiType type) {
            this.length = length;
            this.type = type;
            this.abiType = this.type.getAbiType() + "[" + this.length + "]";
            this.classType = java.lang.reflect.Array.newInstance(this.type.getClassType(), 0).getClass();
            this.isDynamic = this.type.isDynamic();
        }

        public final int getLength() {
            return this.length;
        }

        @NotNull
        public final AbiType getType() {
            return this.type;
        }

        @Override
        @NotNull
        public java.lang.String getAbiType() {
            return this.abiType;
        }

        @Override
        @NotNull
        public Class<?> getClassType() {
            return this.classType;
        }

        @Override
        public boolean isDynamic() {
            return this.isDynamic;
        }

        public final int component1() {
            return this.length;
        }

        @NotNull
        public final AbiType component2() {
            return this.type;
        }

        @NotNull
        public final FixedArray copy(int length, @NotNull AbiType type) {
            return new FixedArray(length, type);
        }

        public static /* synthetic */ FixedArray copy$default(FixedArray fixedArray, int n, AbiType abiType, int n2, Object object) {
            if ((n2 & 1) != 0) {
                n = fixedArray.length;
            }
            if ((n2 & 2) != 0) {
                abiType = fixedArray.type;
            }
            return fixedArray.copy(n, abiType);
        }

        @NotNull
        public java.lang.String toString() {
            return "FixedArray(length=" + this.length + ", type=" + this.type + ")";
        }

        public int hashCode() {
            int result = Integer.hashCode(this.length);
            result = result * 31 + this.type.hashCode();
            return result;
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof FixedArray)) {
                return false;
            }
            FixedArray fixedArray = (FixedArray)other;
            if (this.length != fixedArray.length) {
                return false;
            }
            return Intrinsics.areEqual((Object)this.type, (Object)fixedArray.type);
        }
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0007\n\u0002\u0010\u0000\n\u0002\b\u0003\b\u0086\b\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\t\u0010\u0012\u001a\u00020\u0003H\u00c6\u0003J\u0013\u0010\u0013\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u0003H\u00c6\u0001J\u0013\u0010\u0014\u001a\u00020\u000e2\b\u0010\u0015\u001a\u0004\u0018\u00010\u0016H\u00d6\u0003J\t\u0010\u0017\u001a\u00020\u0003H\u00d6\u0001J\t\u0010\u0018\u001a\u00020\u0006H\u00d6\u0001R\u0014\u0010\u0005\u001a\u00020\u0006X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR\u0018\u0010\t\u001a\u0006\u0012\u0002\b\u00030\nX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\fR\u0014\u0010\r\u001a\u00020\u000eX\u0096D\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000fR\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\u0011\u00a8\u0006\u0019"}, d2={"Lio/ethers/abi/AbiType$FixedBytes;", "Lio/ethers/abi/AbiType;", "length", "", "(I)V", "abiType", "", "getAbiType", "()Ljava/lang/String;", "classType", "Ljava/lang/Class;", "getClassType", "()Ljava/lang/Class;", "isDynamic", "", "()Z", "getLength", "()I", "component1", "copy", "equals", "other", "", "hashCode", "toString", "ethers-abi"})
    public static final class FixedBytes
    implements AbiType {
        private final int length;
        @NotNull
        private final java.lang.String abiType;
        @NotNull
        private final Class<?> classType;
        private final boolean isDynamic;

        public FixedBytes(int length) {
            this.length = length;
            this.abiType = "bytes" + this.length;
            this.classType = io.ethers.core.types.Bytes.class;
            if (this.length <= 0 || this.length > 32) {
                throw new IllegalArgumentException("FixedBytes length must be between 1 and 32, got: " + this.length);
            }
        }

        public final int getLength() {
            return this.length;
        }

        @Override
        @NotNull
        public java.lang.String getAbiType() {
            return this.abiType;
        }

        @Override
        @NotNull
        public Class<?> getClassType() {
            return this.classType;
        }

        @Override
        public boolean isDynamic() {
            return this.isDynamic;
        }

        public final int component1() {
            return this.length;
        }

        @NotNull
        public final FixedBytes copy(int length) {
            return new FixedBytes(length);
        }

        public static /* synthetic */ FixedBytes copy$default(FixedBytes fixedBytes, int n, int n2, Object object) {
            if ((n2 & 1) != 0) {
                n = fixedBytes.length;
            }
            return fixedBytes.copy(n);
        }

        @NotNull
        public java.lang.String toString() {
            return "FixedBytes(length=" + this.length + ")";
        }

        public int hashCode() {
            return Integer.hashCode(this.length);
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof FixedBytes)) {
                return false;
            }
            FixedBytes fixedBytes = (FixedBytes)other;
            return this.length == fixedBytes.length;
        }
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0005\n\u0002\u0010\u0000\n\u0002\b\u0003\b\u0086\b\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\t\u0010\u0012\u001a\u00020\u0003H\u00c6\u0003J\u0013\u0010\u0013\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u0003H\u00c6\u0001J\u0013\u0010\u0014\u001a\u00020\u00102\b\u0010\u0015\u001a\u0004\u0018\u00010\u0016H\u00d6\u0003J\t\u0010\u0017\u001a\u00020\u0003H\u00d6\u0001J\t\u0010\u0018\u001a\u00020\u0006H\u00d6\u0001R\u0014\u0010\u0005\u001a\u00020\u0006X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\nR\u0018\u0010\u000b\u001a\u0006\u0012\u0002\b\u00030\fX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000eR\u0014\u0010\u000f\u001a\u00020\u0010X\u0096D\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\u0011\u00a8\u0006\u0019"}, d2={"Lio/ethers/abi/AbiType$Int;", "Lio/ethers/abi/AbiType;", "bitSize", "", "(I)V", "abiType", "", "getAbiType", "()Ljava/lang/String;", "getBitSize", "()I", "classType", "Ljava/lang/Class;", "getClassType", "()Ljava/lang/Class;", "isDynamic", "", "()Z", "component1", "copy", "equals", "other", "", "hashCode", "toString", "ethers-abi"})
    public static final class Int
    implements AbiType {
        private final int bitSize;
        @NotNull
        private final java.lang.String abiType;
        @NotNull
        private final Class<?> classType;
        private final boolean isDynamic;

        public Int(int bitSize) {
            this.bitSize = bitSize;
            this.abiType = "int" + this.bitSize;
            this.classType = BigInteger.class;
            if (this.bitSize % 8 != 0 || this.bitSize <= 0 || this.bitSize > 256) {
                throw new IllegalArgumentException("Unsupported bit size: " + this.bitSize + ". Must be a multiple of 8 and between 8 and 256.");
            }
        }

        public final int getBitSize() {
            return this.bitSize;
        }

        @Override
        @NotNull
        public java.lang.String getAbiType() {
            return this.abiType;
        }

        @Override
        @NotNull
        public Class<?> getClassType() {
            return this.classType;
        }

        @Override
        public boolean isDynamic() {
            return this.isDynamic;
        }

        public final int component1() {
            return this.bitSize;
        }

        @NotNull
        public final Int copy(int bitSize) {
            return new Int(bitSize);
        }

        public static /* synthetic */ Int copy$default(Int intVal, int n, int n2, Object object) {
            if ((n2 & 1) != 0) {
                n = intVal.bitSize;
            }
            return intVal.copy(n);
        }

        @NotNull
        public java.lang.String toString() {
            return "Int(bitSize=" + this.bitSize + ")";
        }

        public int hashCode() {
            return Integer.hashCode(this.bitSize);
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof Int)) {
                return false;
            }
            Int intVal = (Int)other;
            return this.bitSize == intVal.bitSize;
        }
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\b\u00c6\n\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0013\u0010\u000e\u001a\u00020\f2\b\u0010\u000f\u001a\u0004\u0018\u00010\u0010H\u00d6\u0003J\t\u0010\u0011\u001a\u00020\u0012H\u00d6\u0001J\t\u0010\u0013\u001a\u00020\u0004H\u00d6\u0001R\u0014\u0010\u0003\u001a\u00020\u0004X\u0096D\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006R\u0018\u0010\u0007\u001a\u0006\u0012\u0002\b\u00030\bX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\nR\u0014\u0010\u000b\u001a\u00020\fX\u0096D\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\r\u00a8\u0006\u0014"}, d2={"Lio/ethers/abi/AbiType$String;", "Lio/ethers/abi/AbiType;", "()V", "abiType", "", "getAbiType", "()Ljava/lang/String;", "classType", "Ljava/lang/Class;", "getClassType", "()Ljava/lang/Class;", "isDynamic", "", "()Z", "equals", "other", "", "hashCode", "", "toString", "ethers-abi"})
    public static final class String
    implements AbiType {
        @NotNull
        public static final String INSTANCE = new String();
        @NotNull
        private static final java.lang.String abiType = "string";
        @NotNull
        private static final Class<?> classType = java.lang.String.class;
        private static final boolean isDynamic = true;

        private String() {
        }

        @Override
        @NotNull
        public java.lang.String getAbiType() {
            return abiType;
        }

        @Override
        @NotNull
        public Class<?> getClassType() {
            return classType;
        }

        @Override
        public boolean isDynamic() {
            return isDynamic;
        }

        @NotNull
        public java.lang.String toString() {
            return "String";
        }

        public int hashCode() {
            return 957285852;
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof String)) {
                return false;
            }
            String cfr_ignored_0 = (String)other;
            return true;
        }
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000>\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u0011\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010 \n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0007\n\u0002\u0010\u000b\n\u0002\b\t\n\u0002\u0010\b\n\u0002\b\u0003\u0018\u0000  2\u00020\u0001:\u0001 B9\b\u0002\u0012\n\u0010\u0002\u001a\u0006\u0012\u0002\b\u00030\u0003\u0012\u0016\u0010\u0004\u001a\u0012\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00070\u0006\u0012\u0002\b\u00030\u0005\u0012\f\u0010\b\u001a\b\u0012\u0004\u0012\u00020\u00010\t\u00a2\u0006\u0002\u0010\nJ\u0019\u0010\u0018\u001a\b\u0012\u0004\u0012\u00020\u00070\u00062\u0006\u0010\u0019\u001a\u00020\u0007\u00a2\u0006\u0002\u0010\u001aJ\u0013\u0010\u001b\u001a\u00020\u00142\b\u0010\u001c\u001a\u0004\u0018\u00010\u0007H\u0096\u0002J\b\u0010\u001d\u001a\u00020\u001eH\u0016J\b\u0010\u001f\u001a\u00020\fH\u0016R\u0014\u0010\u000b\u001a\u00020\fX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000eR\u0018\u0010\u0002\u001a\u0006\u0012\u0002\b\u00030\u0003X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\u0010R!\u0010\u0004\u001a\u0012\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00070\u0006\u0012\u0002\b\u00030\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0011\u0010\u0012R\u0014\u0010\u0013\u001a\u00020\u0014X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0013\u0010\u0015R\u0017\u0010\b\u001a\b\u0012\u0004\u0012\u00020\u00010\t\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0016\u0010\u0017\u00a8\u0006!"}, d2={"Lio/ethers/abi/AbiType$Tuple;", "Lio/ethers/abi/AbiType;", "classType", "Ljava/lang/Class;", "factory", "Ljava/util/function/Function;", "", "", "types", "", "(Ljava/lang/Class;Ljava/util/function/Function;Ljava/util/List;)V", "abiType", "", "getAbiType", "()Ljava/lang/String;", "getClassType", "()Ljava/lang/Class;", "getFactory", "()Ljava/util/function/Function;", "isDynamic", "", "()Z", "getTypes", "()Ljava/util/List;", "dataAsTuple", "data", "(Ljava/lang/Object;)[Ljava/lang/Object;", "equals", "other", "hashCode", "", "toString", "Companion", "ethers-abi"})
    @SourceDebugExtension(value={"SMAP\nAbiType.kt\nKotlin\n*S Kotlin\n*F\n+ 1 AbiType.kt\nio/ethers/abi/AbiType$Tuple\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,311:1\n1747#2,3:312\n*S KotlinDebug\n*F\n+ 1 AbiType.kt\nio/ethers/abi/AbiType$Tuple\n*L\n119#1:312,3\n*E\n"})
    public static final class Tuple
    implements AbiType {
        @NotNull
        public static final Companion Companion = new Companion(null);
        @NotNull
        private final Class<?> classType;
        @NotNull
        private final Function<Object[], ?> factory;
        @NotNull
        private final List<AbiType> types;
        @NotNull
        private final java.lang.String abiType;
        private final boolean isDynamic;

        /*
         * WARNING - void declaration
         */
        private Tuple(Class<?> classType, Function<Object[], ?> factory, List<? extends AbiType> types) {
            boolean bl;
            boolean bl2;
            block5: {
                void $this$any$iv;
                void $this$abiType_u24lambda_u240;
                this.classType = classType;
                this.factory = factory;
                this.types = types;
                Tuple tuple = this;
                Tuple tuple2 = this;
                boolean bl3 = false;
                StringBuilder builder = new StringBuilder("(");
                int n = $this$abiType_u24lambda_u240.types.size();
                for (int i = 0; i < n; ++i) {
                    if (i != 0) {
                        builder.append(",");
                    }
                    builder.append($this$abiType_u24lambda_u240.types.get(i).getAbiType());
                }
                tuple2.abiType = builder.append(")").toString();
                Iterable iterable = this.types;
                tuple2 = this;
                boolean $i$f$any = false;
                if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                    bl2 = false;
                } else {
                    for (Object element$iv : $this$any$iv) {
                        AbiType it = (AbiType)element$iv;
                        boolean bl4 = false;
                        if (!it.isDynamic()) continue;
                        bl2 = true;
                        break block5;
                    }
                    bl2 = false;
                }
            }
            tuple2.isDynamic = bl = bl2;
        }

        @Override
        @NotNull
        public Class<?> getClassType() {
            return this.classType;
        }

        @NotNull
        public final Function<Object[], ?> getFactory() {
            return this.factory;
        }

        @NotNull
        public final List<AbiType> getTypes() {
            return this.types;
        }

        @Override
        @NotNull
        public java.lang.String getAbiType() {
            return this.abiType;
        }

        @Override
        public boolean isDynamic() {
            return this.isDynamic;
        }

        @NotNull
        public final Object[] dataAsTuple(@NotNull Object data) {
            if (Intrinsics.areEqual(this.getClassType(), (Object)io.ethers.abi.AbiType$Companion.CLASS_TYPE_TUPLE)) {
                Intrinsics.checkNotNull((Object)data, (java.lang.String)"null cannot be cast to non-null type kotlin.Array<kotlin.Any>");
                return (Object[])data;
            }
            Intrinsics.checkNotNull((Object)data, (java.lang.String)"null cannot be cast to non-null type io.ethers.abi.ContractStruct");
            return ((ContractStruct)data).getTuple();
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            Object object = other;
            if (!Intrinsics.areEqual(this.getClass(), object != null ? object.getClass() : null)) {
                return false;
            }
            Intrinsics.checkNotNull((Object)other, (java.lang.String)"null cannot be cast to non-null type io.ethers.abi.AbiType.Tuple");
            Tuple cfr_ignored_0 = (Tuple)other;
            if (!Intrinsics.areEqual(this.getClassType(), ((Tuple)other).getClassType())) {
                return false;
            }
            return Intrinsics.areEqual(this.types, ((Tuple)other).types);
        }

        public int hashCode() {
            int result = this.getClassType().hashCode();
            result = 31 * result + ((Object)this.types).hashCode();
            return result;
        }

        @NotNull
        public java.lang.String toString() {
            return "Tuple(classType=" + this.getClassType() + ", types=" + this.types + ")";
        }

        @JvmStatic
        @NotNull
        public static final <T extends ContractStruct> Tuple struct(@NotNull Class<T> classType, @NotNull Function<Object[], T> factory, AbiType ... fieldTypes) {
            return Companion.struct(classType, factory, fieldTypes);
        }

        @JvmStatic
        @NotNull
        public static final <T extends ContractStruct> Tuple struct(@NotNull Class<T> classType, @NotNull Function<Object[], T> factory, @NotNull List<? extends AbiType> fieldTypes) {
            return Companion.struct(classType, factory, fieldTypes);
        }

        @JvmStatic
        @NotNull
        public static final Tuple raw(AbiType ... types) {
            return Companion.raw(types);
        }

        @JvmStatic
        @NotNull
        public static final Tuple raw(@NotNull List<? extends AbiType> types) {
            return Companion.raw(types);
        }

        public /* synthetic */ Tuple(Class classType, Function factory, List types, DefaultConstructorMarker $constructor_marker) {
            this(classType, factory, types);
        }

        @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000@\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0011\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J!\u0010\u0003\u001a\u00020\u00042\u0012\u0010\u0005\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u00070\u0006\"\u00020\u0007H\u0007\u00a2\u0006\u0002\u0010\bJ\u0016\u0010\u0003\u001a\u00020\u00042\f\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00070\tH\u0007JS\u0010\n\u001a\u00020\u0004\"\b\b\u0000\u0010\u000b*\u00020\f2\f\u0010\r\u001a\b\u0012\u0004\u0012\u0002H\u000b0\u000e2\u0018\u0010\u000f\u001a\u0014\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00010\u0006\u0012\u0004\u0012\u0002H\u000b0\u00102\u0012\u0010\u0011\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u00070\u0006\"\u00020\u0007H\u0007\u00a2\u0006\u0002\u0010\u0012JH\u0010\n\u001a\u00020\u0004\"\b\b\u0000\u0010\u000b*\u00020\f2\f\u0010\r\u001a\b\u0012\u0004\u0012\u0002H\u000b0\u000e2\u0018\u0010\u000f\u001a\u0014\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00010\u0006\u0012\u0004\u0012\u0002H\u000b0\u00102\f\u0010\u0011\u001a\b\u0012\u0004\u0012\u00020\u00070\tH\u0007J7\u0010\n\u001a\u00020\u0004\"\b\b\u0000\u0010\u000b*\u00020\f2\f\u0010\r\u001a\b\u0012\u0004\u0012\u0002H\u000b0\u00132\u0012\u0010\u0011\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u00070\u0006\"\u00020\u0007\u00a2\u0006\u0002\u0010\u0014\u00a8\u0006\u0015"}, d2={"Lio/ethers/abi/AbiType$Tuple$Companion;", "", "()V", "raw", "Lio/ethers/abi/AbiType$Tuple;", "types", "", "Lio/ethers/abi/AbiType;", "([Lio/ethers/abi/AbiType;)Lio/ethers/abi/AbiType$Tuple;", "", "struct", "T", "Lio/ethers/abi/ContractStruct;", "classType", "Ljava/lang/Class;", "factory", "Ljava/util/function/Function;", "fieldTypes", "(Ljava/lang/Class;Ljava/util/function/Function;[Lio/ethers/abi/AbiType;)Lio/ethers/abi/AbiType$Tuple;", "Lkotlin/reflect/KClass;", "(Lkotlin/reflect/KClass;[Lio/ethers/abi/AbiType;)Lio/ethers/abi/AbiType$Tuple;", "ethers-abi"})
        public static final class Companion {
            private Companion() {
            }

            public final /* synthetic */ Tuple struct(KClass classType, AbiType ... fieldTypes) {
                Object object = KClasses.getCompanionObject((KClass)classType);
                if (object == null || (object = object.getObjectInstance()) == null) {
                    throw new IllegalArgumentException("Class must have a companion object");
                }
                Object companion = object;
                if (!(companion instanceof StructFactory)) {
                    throw new IllegalArgumentException("Companion object must implement StructFactory");
                }
                StructFactory factory = (StructFactory)companion;
                return this.struct(JvmClassMappingKt.getJavaClass((KClass)classType), arg_0 -> Companion.struct$lambda$0(factory, arg_0), ArraysKt.toList((Object[])fieldTypes));
            }

            @JvmStatic
            @NotNull
            public final <T extends ContractStruct> Tuple struct(@NotNull Class<T> classType, @NotNull Function<Object[], T> factory, AbiType ... fieldTypes) {
                return this.struct(classType, factory, ArraysKt.toList((Object[])fieldTypes));
            }

            @JvmStatic
            @NotNull
            public final <T extends ContractStruct> Tuple struct(@NotNull Class<T> classType, @NotNull Function<Object[], T> factory, @NotNull List<? extends AbiType> fieldTypes) {
                return new Tuple(classType, factory, fieldTypes, null);
            }

            @JvmStatic
            @NotNull
            public final Tuple raw(AbiType ... types) {
                return this.raw(ArraysKt.toList((Object[])types));
            }

            @JvmStatic
            @NotNull
            public final Tuple raw(@NotNull List<? extends AbiType> types) {
                return new Tuple(io.ethers.abi.AbiType$Companion.CLASS_TYPE_TUPLE, Function.identity(), types, null);
            }

            private static final ContractStruct struct$lambda$0(StructFactory $factory, Object[] it) {
                return $factory.fromTuple(it);
            }

            public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
                this();
            }
        }
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0005\n\u0002\u0010\u0000\n\u0002\b\u0003\b\u0086\b\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\t\u0010\u0012\u001a\u00020\u0003H\u00c6\u0003J\u0013\u0010\u0013\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u0003H\u00c6\u0001J\u0013\u0010\u0014\u001a\u00020\u00102\b\u0010\u0015\u001a\u0004\u0018\u00010\u0016H\u00d6\u0003J\t\u0010\u0017\u001a\u00020\u0003H\u00d6\u0001J\t\u0010\u0018\u001a\u00020\u0006H\u00d6\u0001R\u0014\u0010\u0005\u001a\u00020\u0006X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\nR\u0018\u0010\u000b\u001a\u0006\u0012\u0002\b\u00030\fX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000eR\u0014\u0010\u000f\u001a\u00020\u0010X\u0096D\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\u0011\u00a8\u0006\u0019"}, d2={"Lio/ethers/abi/AbiType$UInt;", "Lio/ethers/abi/AbiType;", "bitSize", "", "(I)V", "abiType", "", "getAbiType", "()Ljava/lang/String;", "getBitSize", "()I", "classType", "Ljava/lang/Class;", "getClassType", "()Ljava/lang/Class;", "isDynamic", "", "()Z", "component1", "copy", "equals", "other", "", "hashCode", "toString", "ethers-abi"})
    public static final class UInt
    implements AbiType {
        private final int bitSize;
        @NotNull
        private final java.lang.String abiType;
        @NotNull
        private final Class<?> classType;
        private final boolean isDynamic;

        public UInt(int bitSize) {
            this.bitSize = bitSize;
            this.abiType = "uint" + this.bitSize;
            this.classType = BigInteger.class;
            if (this.bitSize % 8 != 0 || this.bitSize <= 0 || this.bitSize > 256) {
                throw new IllegalArgumentException("Unsupported bit size: " + this.bitSize + ". Must be a multiple of 8 and between 8 and 256.");
            }
        }

        public final int getBitSize() {
            return this.bitSize;
        }

        @Override
        @NotNull
        public java.lang.String getAbiType() {
            return this.abiType;
        }

        @Override
        @NotNull
        public Class<?> getClassType() {
            return this.classType;
        }

        @Override
        public boolean isDynamic() {
            return this.isDynamic;
        }

        public final int component1() {
            return this.bitSize;
        }

        @NotNull
        public final UInt copy(int bitSize) {
            return new UInt(bitSize);
        }

        public static /* synthetic */ UInt copy$default(UInt uInt, int n, int n2, Object object) {
            if ((n2 & 1) != 0) {
                n = uInt.bitSize;
            }
            return uInt.copy(n);
        }

        @NotNull
        public java.lang.String toString() {
            return "UInt(bitSize=" + this.bitSize + ")";
        }

        public int hashCode() {
            return Integer.hashCode(this.bitSize);
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof UInt)) {
                return false;
            }
            UInt uInt = (UInt)other;
            return this.bitSize == uInt.bitSize;
        }
    }
}

