/*
 * Decompiled with CFR 0.152.
 */
package io.ethers.abi;

import io.ethers.abi.AbiCodec;
import io.ethers.abi.AbiType;
import io.ethers.core.types.Bytes;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.ArraysKt;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.MatchResult;
import kotlin.text.Regex;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000B\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0010\u0012\n\u0002\b\u0007\n\u0002\u0010\u0011\n\u0000\n\u0002\u0018\u0002\n\u0002\b\t\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0003\b\u0086\b\u0018\u0000 (2\u00020\u0001:\u0001(B)\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\f\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005\u0012\f\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005\u00a2\u0006\u0002\u0010\bJ\t\u0010\u0012\u001a\u00020\u0003H\u00c6\u0003J\u000f\u0010\u0013\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005H\u00c6\u0003J\u000f\u0010\u0014\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005H\u00c6\u0003J3\u0010\u0015\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\u000e\b\u0002\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u00052\u000e\b\u0002\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005H\u00c6\u0001J\u0019\u0010\u0016\u001a\b\u0012\u0004\u0012\u00020\u00010\u00172\u0006\u0010\u0018\u001a\u00020\u0019\u00a2\u0006\u0002\u0010\u001aJ\u0019\u0010\u001b\u001a\b\u0012\u0004\u0012\u00020\u00010\u00172\u0006\u0010\u0018\u001a\u00020\u0019\u00a2\u0006\u0002\u0010\u001aJ\u0019\u0010\u001c\u001a\b\u0012\u0004\u0012\u00020\u00010\u00172\u0006\u0010\u0018\u001a\u00020\u0019\u00a2\u0006\u0002\u0010\u001aJ\u001b\u0010\u001d\u001a\u00020\u00192\u000e\u0010\u001e\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u00010\u0017\u00a2\u0006\u0002\u0010\u001fJ\u001b\u0010 \u001a\u00020\u00192\u000e\u0010\u001e\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u00010\u0017\u00a2\u0006\u0002\u0010\u001fJ\u001b\u0010!\u001a\u00020\u00192\u000e\u0010\u0018\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u00010\u0017\u00a2\u0006\u0002\u0010\u001fJ\u0013\u0010\"\u001a\u00020#2\b\u0010$\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010%\u001a\u00020&H\u00d6\u0001J\t\u0010'\u001a\u00020\u0003H\u00d6\u0001R\u0017\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\nR\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\fR\u0017\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\nR\u0011\u0010\u000e\u001a\u00020\u000f\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\u0011\u00a8\u0006)"}, d2={"Lio/ethers/abi/AbiFunction;", "", "name", "", "inputs", "", "Lio/ethers/abi/AbiType;", "outputs", "(Ljava/lang/String;Ljava/util/List;Ljava/util/List;)V", "getInputs", "()Ljava/util/List;", "getName", "()Ljava/lang/String;", "getOutputs", "selector", "", "getSelector", "()[B", "component1", "component2", "component3", "copy", "decodeArgs", "", "data", "Lio/ethers/core/types/Bytes;", "(Lio/ethers/core/types/Bytes;)[Ljava/lang/Object;", "decodeCall", "decodeResponse", "encodeArgs", "args", "([Ljava/lang/Object;)Lio/ethers/core/types/Bytes;", "encodeCall", "encodeResponse", "equals", "", "other", "hashCode", "", "toString", "Companion", "ethers-abi"})
public final class AbiFunction {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final String name;
    @NotNull
    private final List<AbiType> inputs;
    @NotNull
    private final List<AbiType> outputs;
    @NotNull
    private final byte[] selector;
    @NotNull
    private static final Regex SIGNATURE_REGEX = new Regex("(\\w+)\\((.*?)\\)\\s*?(\\((.*)\\))?");

    public AbiFunction(@NotNull String name, @NotNull List<? extends AbiType> inputs, @NotNull List<? extends AbiType> outputs) {
        this.name = name;
        this.inputs = inputs;
        this.outputs = outputs;
        byte[] byArray = AbiType.Companion.computeSignatureHash(this.name, this.inputs);
        int n = 0;
        int n2 = 4;
        this.selector = ArraysKt.copyOfRange((byte[])byArray, (int)n, (int)n2);
    }

    @NotNull
    public final String getName() {
        return this.name;
    }

    @NotNull
    public final List<AbiType> getInputs() {
        return this.inputs;
    }

    @NotNull
    public final List<AbiType> getOutputs() {
        return this.outputs;
    }

    @NotNull
    public final byte[] getSelector() {
        return this.selector;
    }

    @NotNull
    public final Bytes encodeCall(@NotNull Object[] args) {
        return new Bytes(AbiCodec.encodeWithPrefix(this.selector, this.inputs, args));
    }

    @NotNull
    public final Object[] decodeCall(@NotNull Bytes data) {
        return AbiCodec.decodeWithPrefix(this.selector.length, this.inputs, data.getValue());
    }

    @NotNull
    public final Bytes encodeArgs(@NotNull Object[] args) {
        return new Bytes(AbiCodec.encode(this.inputs, args));
    }

    @NotNull
    public final Object[] decodeArgs(@NotNull Bytes data) {
        return AbiCodec.decode(this.inputs, data.getValue());
    }

    @NotNull
    public final Bytes encodeResponse(@NotNull Object[] data) {
        return new Bytes(AbiCodec.encode(this.outputs, data));
    }

    @NotNull
    public final Object[] decodeResponse(@NotNull Bytes data) {
        return AbiCodec.decode(this.outputs, data.getValue());
    }

    @NotNull
    public final String component1() {
        return this.name;
    }

    @NotNull
    public final List<AbiType> component2() {
        return this.inputs;
    }

    @NotNull
    public final List<AbiType> component3() {
        return this.outputs;
    }

    @NotNull
    public final AbiFunction copy(@NotNull String name, @NotNull List<? extends AbiType> inputs, @NotNull List<? extends AbiType> outputs) {
        return new AbiFunction(name, inputs, outputs);
    }

    public static /* synthetic */ AbiFunction copy$default(AbiFunction abiFunction, String string, List list, List list2, int n, Object object) {
        if ((n & 1) != 0) {
            string = abiFunction.name;
        }
        if ((n & 2) != 0) {
            list = abiFunction.inputs;
        }
        if ((n & 4) != 0) {
            list2 = abiFunction.outputs;
        }
        return abiFunction.copy(string, list, list2);
    }

    @NotNull
    public String toString() {
        return "AbiFunction(name=" + this.name + ", inputs=" + this.inputs + ", outputs=" + this.outputs + ")";
    }

    public int hashCode() {
        int result = this.name.hashCode();
        result = result * 31 + ((Object)this.inputs).hashCode();
        result = result * 31 + ((Object)this.outputs).hashCode();
        return result;
    }

    public boolean equals(@Nullable Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof AbiFunction)) {
            return false;
        }
        AbiFunction abiFunction = (AbiFunction)other;
        if (!Intrinsics.areEqual((Object)this.name, (Object)abiFunction.name)) {
            return false;
        }
        if (!Intrinsics.areEqual(this.inputs, abiFunction.inputs)) {
            return false;
        }
        return Intrinsics.areEqual(this.outputs, abiFunction.outputs);
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u000e\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\bR\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\t"}, d2={"Lio/ethers/abi/AbiFunction$Companion;", "", "()V", "SIGNATURE_REGEX", "Lkotlin/text/Regex;", "parseSignature", "Lio/ethers/abi/AbiFunction;", "signature", "", "ethers-abi"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final AbiFunction parseSignature(@NotNull String signature) {
            MatchResult matchResult = SIGNATURE_REGEX.matchEntire((CharSequence)((Object)StringsKt.trim((CharSequence)StringsKt.replace$default((String)StringsKt.replace$default((String)signature, (String)"function", (String)"", (boolean)false, (int)4, null), (String)"returns", (String)"", (boolean)false, (int)4, null))).toString());
            if (matchResult == null) {
                throw new IllegalArgumentException("Invalid signature: " + signature);
            }
            MatchResult match = matchResult;
            String name = (String)CollectionsKt.getOrNull((List)match.getGroupValues(), (int)1);
            CharSequence charSequence = name;
            if (charSequence == null || StringsKt.isBlank((CharSequence)charSequence)) {
                throw new IllegalArgumentException("Invalid signature, function has no name: " + signature);
            }
            String inputsRaw = (String)CollectionsKt.getOrNull((List)match.getGroupValues(), (int)2);
            String outputsRaw = (String)CollectionsKt.getOrNull((List)match.getGroupValues(), (int)4);
            CharSequence charSequence2 = inputsRaw;
            List<AbiType> inputs = charSequence2 == null || StringsKt.isBlank((CharSequence)charSequence2) ? CollectionsKt.emptyList() : AbiType.Companion.parseSignature(inputsRaw);
            CharSequence charSequence3 = outputsRaw;
            List<AbiType> outputs = charSequence3 == null || StringsKt.isBlank((CharSequence)charSequence3) ? CollectionsKt.emptyList() : AbiType.Companion.parseSignature(outputsRaw);
            return new AbiFunction(name, inputs, outputs);
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

