/*
 * Decompiled with CFR 0.152.
 */
package com.kennyc.bottomsheet.adapters;

import android.content.Context;
import android.graphics.ColorFilter;
import android.graphics.LightingColorFilter;
import android.graphics.drawable.Drawable;
import android.os.Build;
import android.support.annotation.StyleRes;
import android.view.LayoutInflater;
import android.view.MenuItem;
import android.view.View;
import android.view.ViewGroup;
import android.widget.BaseAdapter;
import com.kennyc.bottomsheet.R;
import com.kennyc.bottomsheet.adapters.ViewHolder;
import java.util.List;

public class GridAdapter
extends BaseAdapter {
    private final List<MenuItem> mItems;
    private final LayoutInflater mInflater;
    private boolean mIsGrid;
    @StyleRes
    private int mListStyle;
    @StyleRes
    private int mGridStyle;
    private int mTintColor;

    public GridAdapter(Context context, List<MenuItem> items, boolean isGrid, @StyleRes int listStyle, @StyleRes int gridStyle, int menuItemTintColor) {
        this.mItems = items;
        this.mIsGrid = isGrid;
        this.mInflater = LayoutInflater.from((Context)context);
        this.mListStyle = listStyle;
        this.mGridStyle = gridStyle;
        this.mTintColor = menuItemTintColor;
    }

    public int getCount() {
        return this.mItems.size();
    }

    public MenuItem getItem(int position) {
        return this.mItems.get(position);
    }

    public long getItemId(int position) {
        return this.getItem(position).getItemId();
    }

    public View getView(int position, View convertView, ViewGroup parent) {
        ViewHolder holder;
        MenuItem item = this.getItem(position);
        if (convertView == null) {
            int textAppearance;
            convertView = this.mInflater.inflate(this.mIsGrid ? R.layout.bottom_sheet_grid_item : R.layout.bottom_sheet_list_item, parent, false);
            holder = new ViewHolder(convertView);
            int n = textAppearance = this.mIsGrid ? this.mGridStyle : this.mListStyle;
            if (Build.VERSION.SDK_INT >= 23) {
                holder.title.setTextAppearance(textAppearance);
            } else {
                holder.title.setTextAppearance(convertView.getContext(), textAppearance);
            }
        } else {
            holder = (ViewHolder)convertView.getTag();
        }
        Drawable menuIcon = item.getIcon();
        if (this.mTintColor != Integer.MIN_VALUE && menuIcon != null) {
            menuIcon = menuIcon.mutate();
            menuIcon.setColorFilter((ColorFilter)new LightingColorFilter(-16777216, this.mTintColor));
        }
        holder.icon.setImageDrawable(menuIcon);
        holder.icon.setVisibility(menuIcon != null ? 0 : 8);
        holder.title.setText(item.getTitle());
        return convertView;
    }
}

