/*
 * Decompiled with CFR 0.152.
 */
package com.kennyc.bottomsheet;

import android.app.Dialog;
import android.content.ComponentName;
import android.content.Context;
import android.content.DialogInterface;
import android.content.Intent;
import android.content.pm.PackageManager;
import android.content.pm.ResolveInfo;
import android.content.res.Resources;
import android.graphics.drawable.Drawable;
import android.os.Bundle;
import android.text.TextUtils;
import android.view.LayoutInflater;
import android.view.Menu;
import android.view.MenuInflater;
import android.view.MenuItem;
import android.view.View;
import android.view.ViewGroup;
import android.widget.AdapterView;
import android.widget.BaseAdapter;
import android.widget.GridView;
import android.widget.LinearLayout;
import android.widget.ListAdapter;
import android.widget.TextView;
import androidx.annotation.IntegerRes;
import androidx.annotation.MenuRes;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import androidx.annotation.StringRes;
import androidx.annotation.StyleRes;
import androidx.appcompat.view.ContextThemeWrapper;
import androidx.coordinatorlayout.widget.CoordinatorLayout;
import androidx.fragment.app.DialogFragment;
import androidx.fragment.app.FragmentManager;
import com.google.android.material.bottomsheet.BottomSheetBehavior;
import com.google.android.material.bottomsheet.BottomSheetDialog;
import com.google.android.material.bottomsheet.BottomSheetDialogFragment;
import com.kennyc.bottomsheet.BottomSheetListener;
import com.kennyc.bottomsheet.R;
import com.kennyc.bottomsheet.adapters.AppAdapter;
import com.kennyc.bottomsheet.adapters.GridAdapter;
import com.kennyc.bottomsheet.menu.BottomSheetMenu;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.Set;

public class BottomSheetMenuDialogFragment
extends BottomSheetDialogFragment
implements AdapterView.OnItemClickListener {
    private static final int MIN_LIST_TABLET_ITEMS = 6;
    private static final int GRID_MIN_COLUMNS = 3;
    private static final int GRID_MAX_COLUMN = 4;
    private Builder builder;
    private TextView title;
    private GridView gridView;
    private LinearLayout container;
    private BottomSheetListener listener;
    private BaseAdapter adapter;
    private int dismissEvent = -5;

    public BottomSheetMenuDialogFragment() {
    }

    private BottomSheetMenuDialogFragment(@NonNull Builder builder) {
        this.builder = builder;
        this.listener = builder.listener;
    }

    @Nullable
    public View onCreateView(@NonNull LayoutInflater inflater, @Nullable ViewGroup container, @Nullable Bundle savedInstanceState) {
        return inflater.inflate(R.layout.bottom_sheet_menu, container, false);
    }

    @NonNull
    public Dialog onCreateDialog(Bundle savedInstanceState) {
        BottomSheetDialog dialog = new BottomSheetDialog((Context)this.requireActivity(), this.builder.style);
        dialog.setOnShowListener(new DialogInterface.OnShowListener(){

            public void onShow(DialogInterface dialog) {
                if (BottomSheetMenuDialogFragment.this.container == null || BottomSheetMenuDialogFragment.this.container.getParent() == null) {
                    return;
                }
                CoordinatorLayout.LayoutParams params = (CoordinatorLayout.LayoutParams)((View)BottomSheetMenuDialogFragment.this.container.getParent()).getLayoutParams();
                CoordinatorLayout.Behavior behavior = params.getBehavior();
                if (behavior instanceof BottomSheetBehavior) {
                    ((BottomSheetBehavior)behavior).setBottomSheetCallback(new BottomSheetBehavior.BottomSheetCallback(){

                        public void onStateChanged(@NonNull View bottomSheet, int state) {
                            if (state == 5) {
                                BottomSheetMenuDialogFragment.this.dismissEvent = -4;
                                BottomSheetMenuDialogFragment.this.dismiss();
                            }
                        }

                        public void onSlide(@NonNull View bottomSheet, float slideOffSet) {
                        }
                    });
                }
            }
        });
        return dialog;
    }

    public void onViewCreated(@NonNull View view, @Nullable Bundle savedInstanceState) {
        super.onViewCreated(view, savedInstanceState);
        Objects.requireNonNull(this.builder);
        this.container = (LinearLayout)view.findViewById(R.id.bottom_sheet_container);
        this.title = (TextView)this.container.findViewById(R.id.bottom_sheet_title);
        this.gridView = (GridView)this.container.findViewById(R.id.bottom_sheet_grid);
        this.initUi();
        if (!this.builder.menuItems.isEmpty()) {
            this.adapter = new GridAdapter((Context)new ContextThemeWrapper((Context)this.requireActivity(), this.builder.style), this.builder.menuItems, this.builder.isGrid);
            this.gridView.setAdapter((ListAdapter)this.adapter);
            this.gridView.setOnItemClickListener((AdapterView.OnItemClickListener)this);
        } else {
            this.adapter = new AppAdapter((Context)new ContextThemeWrapper((Context)this.requireActivity(), this.builder.style), this.builder.apps, this.builder.isGrid);
            this.gridView.setAdapter((ListAdapter)this.adapter);
        }
        if (this.listener != null) {
            this.listener.onSheetShown(this, this.builder.object);
        }
    }

    public void onItemClick(AdapterView<?> parent, View view, int position, long id2) {
        this.dismissEvent = -6;
        if (this.adapter instanceof GridAdapter) {
            if (this.listener != null) {
                MenuItem item = ((GridAdapter)this.adapter).getItem(position);
                if (this.listener != null) {
                    this.listener.onSheetItemSelected(this, item, this.builder.object);
                }
                this.dismiss();
            }
        } else if (this.adapter instanceof AppAdapter) {
            AppAdapter.AppInfo info = ((AppAdapter)this.adapter).getItem(position);
            Intent intent = new Intent(this.builder.shareIntent);
            intent.setComponent(new ComponentName(info.packageName, info.name));
            intent.setFlags(0x10000000);
            this.requireContext().startActivity(intent);
        }
    }

    private void initUi() {
        boolean hasTitle;
        boolean bl = hasTitle = !TextUtils.isEmpty((CharSequence)this.builder.title);
        if (hasTitle) {
            this.title.setText((CharSequence)this.builder.title);
        } else {
            this.title.setVisibility(8);
        }
        if (!this.builder.isGrid) {
            int padding = this.getResources().getDimensionPixelSize(R.dimen.bottom_sheet_menu_list_padding);
            this.gridView.setPadding(0, hasTitle ? 0 : padding, 0, padding);
        }
        this.gridView.setNumColumns(this.getNumberColumns());
    }

    public void onDestroyView() {
        this.title = null;
        this.gridView = null;
        this.container = null;
        super.onDestroyView();
    }

    public void onDismiss(DialogInterface dialog) {
        if (this.listener != null) {
            this.listener.onSheetDismissed(this, this.builder.object, this.dismissEvent);
        }
        super.onDismiss(dialog);
    }

    private int getNumberColumns() {
        if (this.builder.columnCount > 0) {
            return this.builder.columnCount;
        }
        boolean isTablet = this.getResources().getBoolean(R.bool.bottom_sheet_menu_it_tablet);
        int numItems = this.builder.menuItems.size();
        if (this.builder.isGrid) {
            if ((numItems >= 7 || numItems == 4) && isTablet) {
                return 4;
            }
            return 3;
        }
        if (isTablet) {
            return numItems >= 6 ? 2 : 1;
        }
        return 1;
    }

    @Nullable
    public static DialogFragment createShareBottomSheet(Context context, Intent intent, String shareTitle, boolean isGrid, @Nullable Set<String> appsFilter, @Nullable Set<String> toExclude) {
        if (context == null || intent == null) {
            return null;
        }
        PackageManager manager = context.getPackageManager();
        List apps = manager.queryIntentActivities(intent, 0);
        if (apps != null && !apps.isEmpty()) {
            ArrayList<AppAdapter.AppInfo> appResources = new ArrayList<AppAdapter.AppInfo>(apps.size());
            boolean shouldCheckPackages = appsFilter != null && !appsFilter.isEmpty();
            for (ResolveInfo resolveInfo : apps) {
                String packageName = resolveInfo.activityInfo.packageName;
                if (shouldCheckPackages && !appsFilter.contains(packageName)) continue;
                String title = resolveInfo.loadLabel(manager).toString();
                String name = resolveInfo.activityInfo.name;
                Drawable drawable = resolveInfo.loadIcon(manager);
                appResources.add(new AppAdapter.AppInfo(title, packageName, name, drawable));
            }
            if (toExclude != null && !toExclude.isEmpty()) {
                ArrayList<AppAdapter.AppInfo> toRemove = new ArrayList<AppAdapter.AppInfo>();
                for (AppAdapter.AppInfo appInfo : appResources) {
                    if (!toExclude.contains(appInfo.packageName)) continue;
                    toRemove.add(appInfo);
                }
                if (!toRemove.isEmpty()) {
                    appResources.removeAll(toRemove);
                }
            }
            Builder b = new Builder(context).setApps(appResources, intent).setTitle(shareTitle);
            if (isGrid) {
                b.grid();
            }
            return b.create();
        }
        return null;
    }

    @Nullable
    public static DialogFragment createShareBottomSheet(Context context, Intent intent, @StringRes int shareTitle, boolean isGrid, @Nullable Set<String> appsFilter, @Nullable Set<String> toExclude) {
        return BottomSheetMenuDialogFragment.createShareBottomSheet(context, intent, context.getString(shareTitle), isGrid, appsFilter, toExclude);
    }

    @Nullable
    public static DialogFragment createShareBottomSheet(Context context, Intent intent, @StringRes int shareTitle, boolean isGrid) {
        return BottomSheetMenuDialogFragment.createShareBottomSheet(context, intent, context.getString(shareTitle), isGrid, null, null);
    }

    public static DialogFragment createShareBottomSheet(Context context, Intent intent, String shareTitle, boolean isGrid) {
        return BottomSheetMenuDialogFragment.createShareBottomSheet(context, intent, shareTitle, isGrid, null, null);
    }

    @Nullable
    public static DialogFragment createShareBottomSheet(Context context, Intent intent, String shareTitle) {
        return BottomSheetMenuDialogFragment.createShareBottomSheet(context, intent, shareTitle, false, null, null);
    }

    @Nullable
    public static DialogFragment createShareBottomSheet(Context context, Intent intent, @StringRes int shareTitle) {
        return BottomSheetMenuDialogFragment.createShareBottomSheet(context, intent, context.getString(shareTitle), false, null, null);
    }

    public static class Builder {
        @StyleRes
        int style;
        int columnCount = -1;
        String title = null;
        boolean cancelable = true;
        boolean isGrid = false;
        List<MenuItem> menuItems = new ArrayList<MenuItem>();
        Context context;
        Resources resources;
        BottomSheetListener listener;
        @Nullable
        Object object;
        List<AppAdapter.AppInfo> apps = new ArrayList<AppAdapter.AppInfo>();
        Intent shareIntent;

        public Builder(Context context) {
            this(context, R.style.Theme_BottomSheetMenuDialog_Light);
        }

        public Builder(Context context, @StyleRes int style2) {
            this.context = context;
            this.style = style2;
            this.resources = context.getResources();
        }

        public Builder dark() {
            this.style = R.style.Theme_BottomSheetMenuDialog;
            return this;
        }

        public Builder setStyle(@StyleRes int style2) {
            this.style = style2;
            return this;
        }

        public Builder setTitle(String title) {
            this.title = title;
            return this;
        }

        public Builder setTitle(@StringRes int title) {
            return this.setTitle(this.resources.getString(title));
        }

        public Builder grid() {
            this.isGrid = true;
            return this;
        }

        public Builder setCancelable(boolean cancelable) {
            this.cancelable = cancelable;
            return this;
        }

        public Builder setListener(BottomSheetListener listener) {
            this.listener = listener;
            return this;
        }

        public Builder setSheet(@MenuRes int sheetItems) {
            BottomSheetMenu menu = new BottomSheetMenu(this.context);
            new MenuInflater(this.context).inflate(sheetItems, (Menu)menu);
            return this.setMenu(menu);
        }

        public Builder setMenu(@Nullable Menu menu) {
            if (menu != null) {
                ArrayList<MenuItem> items = new ArrayList<MenuItem>(menu.size());
                for (int i = 0; i < menu.size(); ++i) {
                    items.add(menu.getItem(i));
                }
                return this.setMenuItems(items);
            }
            return this;
        }

        public Builder setMenuItems(@Nullable List<MenuItem> menuItems) {
            this.menuItems.addAll(menuItems);
            return this;
        }

        public Builder addMenuItem(MenuItem item) {
            this.menuItems.add(item);
            return this;
        }

        public Builder setColumnCount(int columnCount) {
            this.columnCount = columnCount;
            return this;
        }

        public Builder setColumnCountResource(@IntegerRes int columnCount) {
            return this.setColumnCount(this.resources.getInteger(columnCount));
        }

        public Builder object(@Nullable Object object) {
            this.object = object;
            return this;
        }

        private Builder setApps(List<AppAdapter.AppInfo> apps, Intent intent) {
            this.apps = apps;
            this.shareIntent = intent;
            return this;
        }

        public BottomSheetMenuDialogFragment create() {
            return new BottomSheetMenuDialogFragment(this);
        }

        public void show(@NonNull FragmentManager manager) {
            this.show(manager, null);
        }

        public void show(@NonNull FragmentManager manager, @Nullable String tag) {
            this.create().show(manager, tag);
        }
    }
}

