/*
 * Decompiled with CFR 0.152.
 */
package com.queue.library;

import android.os.Build;
import android.os.Handler;
import android.os.Looper;
import android.os.Message;
import android.os.MessageQueue;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import com.queue.library.BlockingRunnable;
import com.queue.library.DispatchPairExchanger;
import com.queue.library.SameThreadExchanger;
import java.lang.reflect.Field;
import java.util.concurrent.Callable;
import java.util.concurrent.Exchanger;
import java.util.concurrent.Executor;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;

public class Dispatch
implements Executor {
    private volatile Handler handler = null;
    private static final String TAG = Dispatch.class.getSimpleName();
    private Looper mLooper = null;
    private long ms = 5000L;
    private static final Object T_OBJECT = new Object();
    private MessageQueue mMessageQueue;
    protected int mPriority;
    private final SameThreadExchanger<Object> exchanger = new SameThreadExchanger();
    private static final ThreadLocal<Exchanger<Object>> EXCHANGER_THREAD_LOCAL = new ThreadLocal<Exchanger<Object>>(){

        @Override
        protected Exchanger<Object> initialValue() {
            return new DispatchPairExchanger<Object>();
        }
    };

    public static <T> T requireNonNull(T obj) {
        if (obj == null) {
            throw new NullPointerException();
        }
        return obj;
    }

    public Dispatch() {
        this(Dispatch.requireNonNull(Looper.myLooper()));
    }

    public Dispatch(@NonNull Looper looper) {
        Dispatch.requireNonNull(looper);
        this.mLooper = looper;
        this.handler = new Handler(looper);
    }

    public void sendMessage(Message msg) {
        this.sendMessage(msg, 0);
    }

    public void sendMessage(Message msg, int delay) {
        if (delay <= 0) {
            this.handler.sendMessage(msg);
        } else {
            this.handler.sendMessageDelayed(msg, (long)delay);
        }
    }

    public void cancelRunnable(@Nullable Runnable runnable) {
        this.handler.removeCallbacks(runnable);
    }

    @NonNull
    public <T> Exchanger<T> exchange(final @NonNull Callable<T> callable) {
        try {
            if (Looper.myLooper() == this.getLooper()) {
                Object t = null;
                try {
                    t = callable.call();
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
                this.exchanger.setV(t);
                return this.exchanger;
            }
            final DispatchPairExchanger exchanger = (DispatchPairExchanger)EXCHANGER_THREAD_LOCAL.get();
            this.handler.post(new Runnable(){

                @Override
                public void run() {
                    Object t = null;
                    try {
                        t = callable.call();
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                    }
                    try {
                        if (Dispatch.this.ms < 0L) {
                            exchanger.exchange0(t);
                        } else {
                            exchanger.exchange0(t, Dispatch.this.ms, TimeUnit.MILLISECONDS);
                        }
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                    }
                }
            });
            return exchanger;
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new UnknownError("UnknownError exchange error ");
        }
    }

    public <T> T call(@NonNull Callable<T> callable) {
        try {
            return this.call(callable, -1L);
        }
        catch (TimeoutException e) {
            e.printStackTrace();
            throw new UnknownError("UnknownError exchange error ");
        }
    }

    public <T> T call(@NonNull Callable<T> callable, long timeout) throws TimeoutException {
        Exchanger<T> exchanger = this.exchange(callable);
        try {
            if (timeout < 0L) {
                return (T)exchanger.exchange(T_OBJECT);
            }
            return (T)exchanger.exchange(T_OBJECT, timeout, TimeUnit.MILLISECONDS);
        }
        catch (InterruptedException e) {
            e.printStackTrace();
            return null;
        }
    }

    public void postRunnableBlocking(final Runnable runnable) {
        this.call(new Callable<Void>(){

            @Override
            public Void call() throws Exception {
                runnable.run();
                return null;
            }
        });
    }

    public void postRunnableScissors(Runnable runnable) {
        this.postRunnableScissors(runnable, -1L);
    }

    public void postRunnableScissors(Runnable runnable, long timeout) {
        if (Looper.myLooper() == this.getLooper()) {
            runnable.run();
            return;
        }
        new BlockingRunnable(runnable).postAndWait(this.handler, timeout);
    }

    public void postRunnable(Runnable runnable) {
        this.postRunnable(runnable, 0L);
    }

    public void postRunnable(Runnable runnable, long delay) {
        if (delay <= 0L) {
            this.handler.post(runnable);
        } else {
            this.handler.postDelayed(runnable, delay);
        }
    }

    public void postRunnableImmediately(Runnable runnable) {
        if (Looper.myLooper() == this.getLooper()) {
            runnable.run();
            return;
        }
        this.postAtFont(runnable);
    }

    public void post(Runnable runnable) {
        if (Looper.myLooper() == this.getLooper()) {
            runnable.run();
            return;
        }
        this.postRunnable(runnable);
    }

    public void postAtFont(Runnable runnable) {
        this.handler.postAtFrontOfQueue(runnable);
    }

    public void cleanupQueue() {
        this.handler.removeCallbacksAndMessages(null);
    }

    public Handler getHandler() {
        return this.handler;
    }

    public Looper getLooper() {
        return this.mLooper;
    }

    public boolean addIdleHandler(MessageQueue.IdleHandler idleHandler) {
        MessageQueue messageQueue = this.getMessageQueue();
        if (messageQueue == null) {
            return false;
        }
        messageQueue.addIdleHandler(idleHandler);
        return true;
    }

    public boolean postRunnableInIdleRunning(final Runnable runnable) {
        MessageQueue messageQueue = this.getMessageQueue();
        if (messageQueue == null) {
            return false;
        }
        messageQueue.addIdleHandler(new MessageQueue.IdleHandler(){

            public boolean queueIdle() {
                runnable.run();
                return false;
            }
        });
        return true;
    }

    synchronized MessageQueue getMessageQueue() {
        if (null != this.mMessageQueue) {
            return this.mMessageQueue;
        }
        if (Build.VERSION.SDK_INT >= 23) {
            this.mMessageQueue = this.mLooper.getQueue();
            return this.mMessageQueue;
        }
        Class<?> clazz = this.mLooper.getClass();
        try {
            Field field = clazz.getDeclaredField("mQueue");
            field.setAccessible(true);
            Object mQueue = field.get(this.mLooper);
            if (mQueue instanceof MessageQueue) {
                this.mMessageQueue = (MessageQueue)mQueue;
            }
        }
        catch (NoSuchFieldException e) {
            e.printStackTrace();
        }
        catch (IllegalAccessException e) {
            e.printStackTrace();
        }
        return this.mMessageQueue;
    }

    public boolean quit() {
        Looper looper = this.getLooper();
        if (looper != null) {
            looper.quit();
            return true;
        }
        return false;
    }

    @Override
    public void execute(Runnable command) {
        this.postRunnable(command);
    }
}

