/*
 * Decompiled with CFR 0.152.
 */
package com.download.library;

import android.os.AsyncTask;
import java.util.ArrayDeque;
import java.util.concurrent.Executor;

public class SerialExecutor
implements Executor {
    static final Executor THREAD_POOL_EXECUTOR = AsyncTask.THREAD_POOL_EXECUTOR;
    final ArrayDeque<Runnable> mTasks = new ArrayDeque();
    Runnable mActive;

    @Override
    public synchronized void execute(final Runnable r) {
        this.mTasks.offer(new Runnable(){

            @Override
            public void run() {
                try {
                    r.run();
                }
                finally {
                    SerialExecutor.this.scheduleNext();
                }
            }
        });
        if (this.mActive == null) {
            this.scheduleNext();
        }
    }

    protected synchronized void scheduleNext() {
        this.mActive = this.mTasks.poll();
        if (this.mActive != null) {
            THREAD_POOL_EXECUTOR.execute(this.mActive);
        }
    }
}

