/*
 * Decompiled with CFR 0.152.
 */
package com.download.library;

import android.content.BroadcastReceiver;
import android.content.Context;
import android.content.IntentFilter;
import android.text.TextUtils;
import androidx.annotation.NonNull;
import com.download.library.DownloadNotifier;
import com.download.library.DownloadSubmitterImpl;
import com.download.library.DownloadTask;
import com.download.library.ExecuteTasksMap;
import com.download.library.NotificationCancelReceiver;
import com.download.library.ResourceRequest;
import com.download.library.Runtime;
import java.io.File;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;

public final class DownloadImpl {
    private static volatile DownloadImpl sInstance;
    private final ConcurrentHashMap<String, DownloadTask> mTasks = new ConcurrentHashMap();
    private static volatile Context mContext;
    public static final String TAG;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private DownloadImpl(@NonNull Context context) {
        Context current = mContext;
        if (current != null) return;
        Class<DownloadImpl> clazz = DownloadImpl.class;
        synchronized (DownloadImpl.class) {
            if (mContext != null) return;
            current = mContext = context.getApplicationContext();
            String action = Runtime.getInstance().append(context, "com.download.cancelled");
            current.registerReceiver((BroadcastReceiver)new NotificationCancelReceiver(), new IntentFilter(action));
            Runtime.getInstance().log(TAG, "registerReceiver:" + action);
            // ** MonitorExit[var3_3] (shouldn't be in output)
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static DownloadImpl getInstance(@NonNull Context context) {
        if (sInstance != null) return sInstance;
        Class<DownloadImpl> clazz = DownloadImpl.class;
        synchronized (DownloadImpl.class) {
            if (sInstance != null) return sInstance;
            sInstance = new DownloadImpl(context);
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return sInstance;
        }
    }

    public static ResourceRequest with(@NonNull Context context) {
        return DownloadImpl.getInstance(context).with0(context);
    }

    public ResourceRequest with(@NonNull String url) {
        return ResourceRequest.with(mContext).url(url);
    }

    public ResourceRequest url(@NonNull String url) {
        return ResourceRequest.with(mContext).url(url);
    }

    private ResourceRequest with0(@NonNull Context context) {
        return ResourceRequest.with(mContext);
    }

    private void safe(@NonNull DownloadTask downloadTask) {
        if (null == downloadTask.getContext()) {
            throw new NullPointerException("context can't be null .");
        }
        if (TextUtils.isEmpty((CharSequence)downloadTask.getUrl())) {
            throw new NullPointerException("url can't be empty .");
        }
    }

    public boolean enqueue(@NonNull DownloadTask downloadTask) {
        this.safe(downloadTask);
        return DownloadSubmitterImpl.getInstance().submit(downloadTask);
    }

    public File call(@NonNull DownloadTask downloadTask) {
        this.safe(downloadTask);
        try {
            File file = DownloadSubmitterImpl.getInstance().submit0(downloadTask);
            return file;
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    public File callEx(@NonNull DownloadTask downloadTask) throws Exception {
        this.safe(downloadTask);
        File file = DownloadSubmitterImpl.getInstance().submit0(downloadTask);
        return file;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized DownloadTask cancel(@NonNull String url) {
        DownloadTask downloadTask = null;
        try {
            downloadTask = ExecuteTasksMap.getInstance().cancelTask(url);
        }
        finally {
            DownloadTask task = this.mTasks.get(url);
            if (task != null && task.getStatus() == 1004) {
                task.cancel();
                DownloadNotifier.cancel(task);
                downloadTask = task;
            }
            this.remove(url);
        }
        return downloadTask;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized List<DownloadTask> cancelAll() {
        ArrayList<DownloadTask> downloadTasks = new ArrayList<DownloadTask>();
        try {
            List<DownloadTask> runningTask = ExecuteTasksMap.getInstance().cancelTasks();
            if (null != runningTask) {
                downloadTasks.addAll(runningTask);
            }
        }
        finally {
            ConcurrentHashMap<String, DownloadTask> tasks = this.mTasks;
            if (!tasks.isEmpty()) {
                Set<Map.Entry<String, DownloadTask>> sets = tasks.entrySet();
                for (Map.Entry<String, DownloadTask> entry : sets) {
                    DownloadTask downloadTask = entry.getValue();
                    if (downloadTask == null || downloadTask.getStatus() != 1004) continue;
                    downloadTask.cancel();
                    DownloadNotifier.cancel(downloadTask);
                    downloadTasks.add(downloadTask);
                }
            }
            this.cleanTasksCache();
        }
        return downloadTasks;
    }

    public synchronized DownloadTask pause(@NonNull String url) {
        DownloadTask downloadTask = ExecuteTasksMap.getInstance().pauseTask(url);
        if (downloadTask != null) {
            this.mTasks.put(downloadTask.getUrl(), downloadTask);
        }
        return downloadTask;
    }

    public synchronized void resumeAll() {
        ConcurrentHashMap<String, DownloadTask> tasks = this.mTasks;
        if (tasks.size() <= 0) {
            return;
        }
        Set<Map.Entry<String, DownloadTask>> sets = tasks.entrySet();
        if (sets.size() > 0) {
            for (Map.Entry<String, DownloadTask> entry : sets) {
                DownloadTask downloadTask = entry.getValue();
                if (null == downloadTask || null == downloadTask.getContext() || TextUtils.isEmpty((CharSequence)downloadTask.getUrl())) {
                    Runtime.getInstance().logError(TAG, "downloadTask death .");
                    continue;
                }
                Runtime.getInstance().logError(TAG, "downloadTask:" + downloadTask.getUrl());
                this.enqueue(downloadTask);
            }
        }
        this.cleanTasksCache();
    }

    public synchronized boolean resume(@NonNull String url) {
        DownloadTask downloadTask = this.mTasks.remove(url);
        if (null == downloadTask || null == downloadTask.getContext() || TextUtils.isEmpty((CharSequence)downloadTask.getUrl())) {
            Runtime.getInstance().logError(TAG, "downloadTask death .");
            return false;
        }
        this.enqueue(downloadTask);
        return true;
    }

    private synchronized void cleanTasksCache() {
        ConcurrentHashMap<String, DownloadTask> tasks = this.mTasks;
        tasks.clear();
    }

    private synchronized void remove(@NonNull String url) {
        ConcurrentHashMap<String, DownloadTask> tasks = this.mTasks;
        tasks.remove(url);
    }

    public boolean exist(@NonNull String url) {
        return ExecuteTasksMap.getInstance().exist(url) || this.mTasks.contains(url);
    }

    public boolean isPaused(@NonNull String url) {
        DownloadTask downloadTask = this.mTasks.get(url);
        return downloadTask != null && downloadTask.getStatus() == 1004;
    }

    public int pausedTasksTotals() {
        return this.mTasks.size();
    }

    public boolean isRunning(@NonNull String url) {
        return ExecuteTasksMap.getInstance().exist(url);
    }

    static {
        TAG = "Download-" + DownloadImpl.class.getSimpleName();
    }
}

