/*
 * Decompiled with CFR 0.152.
 */
package com.download.library;

import android.content.Context;
import android.support.annotation.DrawableRes;
import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import com.download.library.DownloadImpl;
import com.download.library.DownloadListener;
import com.download.library.DownloadListenerAdapter;
import com.download.library.DownloadTask;
import com.download.library.DownloadingListener;
import com.download.library.Runtime;
import java.io.File;
import java.util.HashMap;

public class ResourceRequest<T extends DownloadTask> {
    private DownloadTask mDownloadTask;

    static ResourceRequest with(Context context) {
        ResourceRequest resourceRequest = new ResourceRequest();
        resourceRequest.mDownloadTask = Runtime.getInstance().getDefaultDownloadTask();
        resourceRequest.mDownloadTask.setContext(context);
        return resourceRequest;
    }

    public ResourceRequest url(@NonNull String url) {
        this.mDownloadTask.setUrl(url);
        return this;
    }

    public ResourceRequest target(@Nullable File target) {
        this.mDownloadTask.setFile(target);
        return this;
    }

    public ResourceRequest setUniquePath(boolean uniquePath) {
        this.mDownloadTask.setUniquePath(uniquePath);
        return this;
    }

    public ResourceRequest setBlockMaxTime(long blockMaxTime) {
        this.mDownloadTask.blockMaxTime = blockMaxTime;
        return this;
    }

    public ResourceRequest target(@NonNull File target, @NonNull String authority) {
        this.mDownloadTask.setFile(target, authority);
        return this;
    }

    protected ResourceRequest setContentLength(long contentLength) {
        this.mDownloadTask.mContentLength = contentLength;
        return this;
    }

    public ResourceRequest setDownloadTimeOut(long downloadTimeOut) {
        this.mDownloadTask.downloadTimeOut = downloadTimeOut;
        return this;
    }

    public ResourceRequest setConnectTimeOut(long connectTimeOut) {
        this.mDownloadTask.connectTimeOut = connectTimeOut;
        return this;
    }

    public ResourceRequest setOpenBreakPointDownload(boolean openBreakPointDownload) {
        this.mDownloadTask.mIsBreakPointDownload = openBreakPointDownload;
        return this;
    }

    public ResourceRequest setForceDownload(boolean force) {
        this.mDownloadTask.mIsForceDownload = force;
        return this;
    }

    public ResourceRequest setEnableIndicator(boolean enableIndicator) {
        this.mDownloadTask.mEnableIndicator = enableIndicator;
        return this;
    }

    public ResourceRequest setQuickProgress(boolean quickProgress) {
        this.mDownloadTask.quickProgress = quickProgress;
        return this;
    }

    public ResourceRequest setTargetCompareMD5(String targetCompareMD5) {
        this.mDownloadTask.targetCompareMD5 = targetCompareMD5;
        return this;
    }

    public ResourceRequest setRetry(int retry) {
        this.mDownloadTask.setRetry(retry);
        return this;
    }

    public ResourceRequest setIcon(@DrawableRes int icon) {
        this.mDownloadTask.mDownloadIcon = icon;
        return this;
    }

    public ResourceRequest setParallelDownload(boolean parallelDownload) {
        this.mDownloadTask.mIsParallelDownload = parallelDownload;
        return this;
    }

    public ResourceRequest addHeader(String key, String value) {
        if (this.mDownloadTask.mHeaders == null) {
            this.mDownloadTask.mHeaders = new HashMap();
        }
        this.mDownloadTask.mHeaders.put(key, value);
        return this;
    }

    public ResourceRequest autoOpenIgnoreMD5() {
        this.mDownloadTask.autoOpenIgnoreMD5();
        return this;
    }

    public ResourceRequest autoOpenWithMD5(String md5) {
        this.mDownloadTask.autoOpenWithMD5(md5);
        return this;
    }

    public ResourceRequest closeAutoOpen() {
        this.mDownloadTask.closeAutoOpen();
        return this;
    }

    public File get() {
        return DownloadImpl.getInstance(this.mDownloadTask.mContext).call(this.mDownloadTask);
    }

    public ResourceRequest setDownloadListener(DownloadListener downloadListener) {
        this.mDownloadTask.setDownloadListener(downloadListener);
        return this;
    }

    public ResourceRequest setDownloadingListener(DownloadingListener downloadListener) {
        this.mDownloadTask.setDownloadingListener(downloadListener);
        return this;
    }

    public ResourceRequest setDownloadListenerAdapter(DownloadListenerAdapter downloadListenerAdapter) {
        this.mDownloadTask.setDownloadListenerAdapter(downloadListenerAdapter);
        return this;
    }

    public ResourceRequest setCalculateMD5(boolean calculateMD5) {
        this.mDownloadTask.setCalculateMD5(calculateMD5);
        return this;
    }

    public ResourceRequest quickProgress() {
        this.mDownloadTask.setQuickProgress(true);
        return this;
    }

    public DownloadTask getDownloadTask() {
        return this.mDownloadTask;
    }

    public void enqueue() {
        DownloadImpl.getInstance(this.mDownloadTask.mContext).enqueue(this.mDownloadTask);
    }

    public void enqueue(DownloadListener downloadListener) {
        this.mDownloadTask.setDownloadListener(downloadListener);
        DownloadImpl.getInstance(this.mDownloadTask.mContext).enqueue(this.mDownloadTask);
    }

    public void enqueue(DownloadingListener downloadingListener) {
        this.mDownloadTask.setDownloadingListener(downloadingListener);
        DownloadImpl.getInstance(this.mDownloadTask.mContext).enqueue(this.mDownloadTask);
    }

    public void enqueue(DownloadListenerAdapter downloadListenerAdapter) {
        this.setDownloadListenerAdapter(downloadListenerAdapter);
        DownloadImpl.getInstance(this.mDownloadTask.mContext).enqueue(this.mDownloadTask);
    }
}

