/*
 * Decompiled with CFR 0.152.
 */
package com.download.library;

import android.os.AsyncTask;
import android.support.annotation.NonNull;
import com.download.library.Runtime;
import com.download.library.SerialExecutor;
import java.util.concurrent.Executor;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;

public final class Executors {
    private static volatile Executor IO;
    private static volatile Executor TASK_ENQUEUE_DISPATCH;
    private static volatile Executor TASK_QUEUEDUP_DISPATCH;
    private static final String TAG;
    protected static final Executor SERIAL_EXECUTOR;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Executor io() {
        if (IO != null) {
            return IO;
        }
        Class<Executors> clazz = Executors.class;
        synchronized (Executors.class) {
            if (IO == null) {
                ThreadPoolExecutor service = new ThreadPoolExecutor(4, 4, 30L, TimeUnit.MILLISECONDS, new LinkedBlockingQueue<Runnable>(), new ThreadFactory(){

                    @Override
                    public Thread newThread(@NonNull Runnable r) {
                        return new Thread(r);
                    }
                });
                service.allowCoreThreadTimeOut(true);
                IO = service;
            }
            // ** MonitorExit[var0] (shouldn't be in output)
            return IO;
        }
    }

    public static Executor getSerialExecutor() {
        return SERIAL_EXECUTOR;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Executor taskEnqueueDispatchExecutor() {
        if (TASK_ENQUEUE_DISPATCH != null) {
            return TASK_ENQUEUE_DISPATCH;
        }
        Class<Executors> clazz = Executors.class;
        synchronized (Executors.class) {
            if (TASK_ENQUEUE_DISPATCH == null) {
                ThreadPoolExecutor service = new ThreadPoolExecutor(1, 1, 30L, TimeUnit.MILLISECONDS, new LinkedBlockingQueue<Runnable>(), new ThreadFactory(){

                    @Override
                    public Thread newThread(@NonNull Runnable r) {
                        return new Thread(r);
                    }
                });
                service.allowCoreThreadTimeOut(true);
                TASK_ENQUEUE_DISPATCH = service;
            }
            // ** MonitorExit[var0] (shouldn't be in output)
            return TASK_ENQUEUE_DISPATCH;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Executor taskQueuedUpDispatchExecutor() {
        if (TASK_QUEUEDUP_DISPATCH != null) {
            return TASK_QUEUEDUP_DISPATCH;
        }
        Class<Executors> clazz = Executors.class;
        synchronized (Executors.class) {
            if (TASK_QUEUEDUP_DISPATCH == null) {
                ThreadPoolExecutor service = new ThreadPoolExecutor(1, 1, 30L, TimeUnit.MILLISECONDS, new LinkedBlockingQueue<Runnable>(), new ThreadFactory(){

                    @Override
                    public Thread newThread(@NonNull Runnable r) {
                        return new Thread(r);
                    }
                });
                service.allowCoreThreadTimeOut(true);
                TASK_QUEUEDUP_DISPATCH = service;
            }
            // ** MonitorExit[var0] (shouldn't be in output)
            return TASK_QUEUEDUP_DISPATCH;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void setTaskEnqueueDispatchExecutor(Executor executor) {
        if (executor == null) {
            Runtime.getInstance().logError(TAG, "executor is null");
            return;
        }
        Class<Executors> clazz = Executors.class;
        synchronized (Executors.class) {
            Executor taskEnqueueDispatch = TASK_ENQUEUE_DISPATCH;
            try {
                TASK_ENQUEUE_DISPATCH = executor;
            }
            finally {
                if (null != taskEnqueueDispatch && taskEnqueueDispatch instanceof ExecutorService) {
                    ((ExecutorService)taskEnqueueDispatch).shutdown();
                }
            }
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void setTaskQueuedupDispatchExecutor(Executor executor) {
        if (executor == null) {
            Runtime.getInstance().logError(TAG, "executor is null");
            return;
        }
        Class<Executors> clazz = Executors.class;
        synchronized (Executors.class) {
            Executor queuedupDispatch = TASK_QUEUEDUP_DISPATCH;
            try {
                TASK_QUEUEDUP_DISPATCH = executor;
            }
            finally {
                if (null != queuedupDispatch && queuedupDispatch instanceof ExecutorService) {
                    ((ExecutorService)queuedupDispatch).shutdown();
                }
            }
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void setIO(Executor executor) {
        if (executor == null) {
            Runtime.getInstance().logError(TAG, "executor is null");
            return;
        }
        Class<Executors> clazz = Executors.class;
        synchronized (Executors.class) {
            Executor io = IO;
            try {
                IO = executor;
            }
            finally {
                if (null != io && io != AsyncTask.THREAD_POOL_EXECUTOR && io instanceof ExecutorService) {
                    ((ExecutorService)io).shutdown();
                }
            }
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return;
        }
    }

    static {
        TAG = Executors.class.getSimpleName();
        SERIAL_EXECUTOR = new SerialExecutor();
    }
}

