/*
 * Decompiled with CFR 0.152.
 */
package com.download.library;

import android.support.annotation.NonNull;
import android.text.TextUtils;
import com.download.library.DownloadTask;
import com.download.library.ExecuteTask;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;

public final class ExecuteTasksMap {
    private ConcurrentHashMap<String, ExecuteTask> mTasks = new ConcurrentHashMap();

    private ExecuteTasksMap() {
    }

    static ExecuteTasksMap getInstance() {
        return ExecuteTaskHolder.INSTANCE;
    }

    DownloadTask cancelTask(String url) {
        ExecuteTask mExecuteTask = this.mTasks.get(url);
        if (null != mExecuteTask) {
            return mExecuteTask.cancelDownload();
        }
        return null;
    }

    DownloadTask pauseTask(String url) {
        DownloadTask downloadTask;
        ExecuteTask mExecuteTask = this.mTasks.get(url);
        if (null != mExecuteTask && null != (downloadTask = mExecuteTask.getDownloadTask()) && downloadTask.getStatus() == 1002) {
            return mExecuteTask.pauseDownload();
        }
        return null;
    }

    List<DownloadTask> cancelTasks() {
        Set<Map.Entry<String, ExecuteTask>> sets = this.mTasks.entrySet();
        if (sets.size() > 0) {
            ArrayList<DownloadTask> downloadTasks = new ArrayList<DownloadTask>(sets.size());
            for (Map.Entry<String, ExecuteTask> entry : sets) {
                DownloadTask downloadTask = entry.getValue().cancelDownload();
                if (null == downloadTask) continue;
                downloadTasks.add(downloadTask);
            }
            return downloadTasks;
        }
        return null;
    }

    List<DownloadTask> pauseTasks() {
        Set<Map.Entry<String, ExecuteTask>> sets = this.mTasks.entrySet();
        if (sets.size() > 0) {
            ArrayList<DownloadTask> downloadTasks = new ArrayList<DownloadTask>(sets.size());
            for (Map.Entry<String, ExecuteTask> entry : sets) {
                DownloadTask downloadTask = entry.getValue().pauseDownload();
                if (null == downloadTask) continue;
                downloadTasks.add(downloadTask);
            }
            return downloadTasks;
        }
        return null;
    }

    void addTask(@NonNull String url, @NonNull ExecuteTask recipient) {
        if (null != url && null != recipient) {
            this.mTasks.put(url, recipient);
        }
    }

    void removeTask(@NonNull String url) {
        if (null != url) {
            this.mTasks.remove(url);
        }
    }

    boolean exist(@NonNull String url) {
        return !TextUtils.isEmpty((CharSequence)url) && null != this.mTasks.get(url);
    }

    private static class ExecuteTaskHolder {
        private static final ExecuteTasksMap INSTANCE = new ExecuteTasksMap();

        private ExecuteTaskHolder() {
        }
    }
}

