/*
 * Decompiled with CFR 0.152.
 */
package com.download.library;

import android.app.Activity;
import android.content.Intent;
import android.os.Looper;
import android.os.Process;
import android.support.annotation.NonNull;
import android.text.TextUtils;
import android.util.Log;
import com.download.library.DownloadException;
import com.download.library.DownloadListener;
import com.download.library.DownloadNotifier;
import com.download.library.DownloadSubmitter;
import com.download.library.DownloadTask;
import com.download.library.Downloader;
import com.download.library.DownloadingListener;
import com.download.library.ExecuteTasksMap;
import com.download.library.Executors;
import com.download.library.Runtime;
import com.queue.library.DispatchThread;
import com.queue.library.GlobalQueue;
import java.io.File;
import java.io.IOException;
import java.util.concurrent.Callable;
import java.util.concurrent.Executor;

public class DownloadSubmitterImpl
implements DownloadSubmitter {
    private static final String TAG = "Download-" + DownloadSubmitterImpl.class.getSimpleName();
    private final Executor mExecutor;
    private final Executor mExecutor0;
    private volatile DispatchThread mMainQueue = null;
    private final Object mLock = new Object();

    private DownloadSubmitterImpl() {
        this.mExecutor = Executors.taskEnqueueDispatchExecutor();
        this.mExecutor0 = Executors.taskQueuedUpDispatchExecutor();
    }

    static DownloadSubmitterImpl getInstance() {
        return Holder.INSTANCE;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean submit(DownloadTask downloadTask) {
        if (TextUtils.isEmpty((CharSequence)downloadTask.getUrl())) {
            return false;
        }
        Object object = this.mLock;
        synchronized (object) {
            if (ExecuteTasksMap.getInstance().exist(downloadTask.getUrl())) {
                Log.e((String)TAG, (String)("task exists:" + downloadTask.getUrl()));
                return false;
            }
            Downloader downloader = (Downloader)Downloader.create(downloadTask);
            ExecuteTasksMap.getInstance().addTask(downloadTask.getUrl(), downloader);
            this.execute(new DownloadStartTask(downloadTask, downloader));
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public File submit0(@NonNull DownloadTask downloadTask) throws Exception {
        if (Looper.getMainLooper() == Looper.myLooper()) {
            throw new RuntimeException("Sync download must call it in the non main-Thread ");
        }
        boolean submit = this.submit(downloadTask);
        if (!submit) {
            return null;
        }
        downloadTask.setup();
        downloadTask.await();
        if (null != downloadTask.getThrowable()) {
            throw (Exception)downloadTask.getThrowable();
        }
        try {
            File file;
            File file2 = file = downloadTask.isSuccessful() ? downloadTask.getFile() : null;
            return file2;
        }
        finally {
            downloadTask.destroy();
        }
    }

    void execute(final @NonNull Runnable command) {
        this.mExecutor.execute(new Runnable(){

            @Override
            public void run() {
                Process.setThreadPriority((int)10);
                command.run();
            }
        });
    }

    void execute0(final @NonNull Runnable command) {
        this.mExecutor0.execute(new Runnable(){

            @Override
            public void run() {
                Process.setThreadPriority((int)10);
                command.run();
            }
        });
    }

    DispatchThread getMainQueue() {
        if (this.mMainQueue == null) {
            this.mMainQueue = GlobalQueue.getMainQueue();
        }
        return this.mMainQueue;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void releaseTask(DownloadTask downloadTask) {
        if (!TextUtils.isEmpty((CharSequence)downloadTask.getUrl())) {
            Object object = this.mLock;
            synchronized (object) {
                if (!TextUtils.isEmpty((CharSequence)downloadTask.getUrl())) {
                    ExecuteTasksMap.getInstance().removeTask(downloadTask.getUrl());
                }
            }
        }
    }

    private static class Holder {
        private static final DownloadSubmitterImpl INSTANCE = new DownloadSubmitterImpl();

        private Holder() {
        }
    }

    private final class DownloadTaskOver
    implements Runnable {
        private final int mResult;
        private final Downloader mDownloader;
        private final DownloadTask mDownloadTask;
        private final DownloadNotifier mDownloadNotifier;

        DownloadTaskOver(int result, Downloader downloader, DownloadTask downloadTask) {
            this.mResult = result;
            this.mDownloader = downloader;
            this.mDownloadTask = downloadTask;
            this.mDownloadNotifier = downloadTask.mDownloadNotifier;
        }

        @Override
        public void run() {
            DownloadTask downloadTask = this.mDownloadTask;
            try {
                if (this.mResult == 16388) {
                    if (null != this.mDownloadNotifier) {
                        this.mDownloadNotifier.onDownloadPaused();
                    }
                    return;
                }
                if (this.mResult == 16390) {
                    downloadTask.completed();
                } else if (this.mResult == 16393) {
                    downloadTask.completed();
                } else {
                    downloadTask.completed();
                }
                boolean isCancelDispose = this.doCallback(this.mResult);
                if (this.mResult > 8192) {
                    if (null != this.mDownloadNotifier) {
                        this.mDownloadNotifier.cancel();
                    }
                    return;
                }
                if (downloadTask.isEnableIndicator()) {
                    if (isCancelDispose) {
                        if (null != this.mDownloadNotifier) {
                            this.mDownloadNotifier.cancel();
                        }
                        return;
                    }
                    if (null != this.mDownloadNotifier) {
                        this.mDownloadNotifier.onDownloadFinished();
                    }
                }
                if (!downloadTask.isAutoOpen()) {
                    return;
                }
                this.autoOpen();
            }
            catch (Throwable throwable) {
                if (Runtime.getInstance().isDebug()) {
                    throwable.printStackTrace();
                }
            }
            finally {
                DownloadSubmitterImpl.this.releaseTask(downloadTask);
                this.destroyTask();
                downloadTask.anotify();
            }
        }

        void destroyTask() {
            DownloadTask downloadTask = this.mDownloadTask;
            if (!downloadTask.isSuccessful()) {
                return;
            }
            if (!downloadTask.isAWait) {
                Runtime.getInstance().log(TAG, "destroyTask:" + downloadTask.getUrl());
                downloadTask.destroy();
            }
        }

        private void autoOpen() {
            DownloadSubmitterImpl.this.getMainQueue().postRunnableScissors(new Runnable(){

                @Override
                public void run() {
                    block3: {
                        Intent mIntent = Runtime.getInstance().getCommonFileIntentCompat(DownloadTaskOver.this.mDownloadTask.getContext(), DownloadTaskOver.this.mDownloadTask);
                        if (!(DownloadTaskOver.this.mDownloadTask.getContext() instanceof Activity)) {
                            mIntent.addFlags(0x10000000);
                        }
                        try {
                            DownloadTaskOver.this.mDownloadTask.getContext().startActivity(mIntent);
                        }
                        catch (Throwable throwable) {
                            if (!Runtime.getInstance().isDebug()) break block3;
                            throwable.printStackTrace();
                        }
                    }
                }
            });
        }

        private boolean doCallback(final Integer code) {
            final DownloadTask downloadTask = this.mDownloadTask;
            final DownloadListener mDownloadListener = downloadTask.getDownloadListener();
            if (null == mDownloadListener) {
                return false;
            }
            return (Boolean)DownloadSubmitterImpl.getInstance().getMainQueue().call((Callable)new Callable<Boolean>(){

                @Override
                public Boolean call() {
                    return mDownloadListener.onResult(code <= 8192 ? null : new DownloadException(code, "failed , cause:" + (String)Downloader.DOWNLOAD_MESSAGE.get(code.intValue())), downloadTask.getFileUri(), downloadTask.getUrl(), DownloadTaskOver.this.mDownloadTask);
                }
            });
        }
    }

    private class DownloadStartTask
    implements Runnable {
        private final DownloadTask mDownloadTask;
        private final Downloader mDownloader;

        public DownloadStartTask(DownloadTask downloadTask, Downloader downloader) {
            this.mDownloadTask = downloadTask;
            this.mDownloader = downloader;
        }

        @Override
        public void run() {
            try {
                File file;
                if (null != this.mDownloadTask.getDownloadingListener()) {
                    try {
                        boolean mCallbackInMainThread;
                        DownloadingListener.MainThread annotation = this.mDownloadTask.getDownloadingListener().getClass().getDeclaredMethod("onProgress", String.class, Long.TYPE, Long.TYPE, Long.TYPE).getAnnotation(DownloadingListener.MainThread.class);
                        this.mDownloader.mCallbackInMainThread = mCallbackInMainThread = null != annotation;
                        Runtime.getInstance().log(TAG, " callback in main-Thread:" + mCallbackInMainThread);
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                    }
                }
                if (this.mDownloadTask.getStatus() != 1004) {
                    this.mDownloadTask.resetTime();
                }
                this.mDownloadTask.setStatus(1001);
                if (null == this.mDownloadTask.getFile()) {
                    file = this.mDownloadTask.isUniquePath() ? Runtime.getInstance().uniqueFile(this.mDownloadTask, null) : Runtime.getInstance().createFile(this.mDownloadTask.mContext, this.mDownloadTask);
                    this.mDownloadTask.setFileSafe(file);
                } else if (this.mDownloadTask.getFile().isDirectory()) {
                    file = this.mDownloadTask.isUniquePath() ? Runtime.getInstance().uniqueFile(this.mDownloadTask, this.mDownloadTask.getFile()) : Runtime.getInstance().createFile(this.mDownloadTask.mContext, this.mDownloadTask, this.mDownloadTask.getFile());
                    this.mDownloadTask.setFileSafe(file);
                } else if (!this.mDownloadTask.getFile().exists()) {
                    try {
                        this.mDownloadTask.getFile().createNewFile();
                    }
                    catch (IOException e) {
                        e.printStackTrace();
                        this.mDownloadTask.setFileSafe(null);
                    }
                }
                if (null == this.mDownloadTask.getFile()) {
                    throw new RuntimeException("target file can't be created . ");
                }
                this.mDownloadTask.createNotifier();
                if (this.mDownloadTask.isParallelDownload()) {
                    this.executeOnExecutor(Executors.io());
                } else {
                    this.executeOnExecutor(Executors.getSerialExecutor());
                }
            }
            catch (Throwable throwable) {
                DownloadSubmitterImpl.this.releaseTask(this.mDownloadTask);
                throwable.printStackTrace();
                throw throwable;
            }
        }

        private void executeOnExecutor(Executor threadPoolExecutor) {
            threadPoolExecutor.execute(new Runnable(){

                @Override
                public void run() {
                    try {
                        int result = DownloadStartTask.this.mDownloader.doInBackground();
                        DownloadSubmitterImpl.getInstance().execute0(new DownloadTaskOver(result, DownloadStartTask.this.mDownloader, DownloadStartTask.this.mDownloadTask));
                    }
                    catch (Throwable throwable) {
                        throwable.printStackTrace();
                        DownloadStartTask.this.mDownloadTask.error();
                        DownloadSubmitterImpl.this.releaseTask(DownloadStartTask.this.mDownloadTask);
                    }
                }
            });
        }
    }
}

