/*
 * Decompiled with CFR 0.152.
 */
package com.download.library;

import android.app.Activity;
import android.app.Notification;
import android.app.NotificationChannel;
import android.app.NotificationManager;
import android.app.PendingIntent;
import android.content.Context;
import android.content.Intent;
import android.os.Build;
import android.os.SystemClock;
import android.text.TextUtils;
import androidx.annotation.NonNull;
import androidx.core.app.NotificationCompat;
import com.download.library.DownloadException;
import com.download.library.DownloadListener;
import com.download.library.DownloadTask;
import com.download.library.Downloader;
import com.download.library.R;
import com.download.library.Runtime;
import com.queue.library.DispatchThread;
import com.queue.library.GlobalQueue;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.Locale;

public class DownloadNotifier {
    private static final int FLAG = 4;
    int requestCode;
    private int mNotificationId;
    private NotificationManager mNotificationManager;
    private Notification mNotification;
    private NotificationCompat.Builder mBuilder;
    private Context mContext;
    private volatile boolean mAddedCancelAction;
    private static final String TAG = "Download-" + DownloadNotifier.class.getSimpleName();
    private NotificationCompat.Action mAction;
    private DownloadTask mDownloadTask;
    private String mContent;
    private static long sLastUpdateNoticationTime = SystemClock.elapsedRealtime();
    private static volatile DispatchThread NOTIFICATION_UPDATE_QUEUE;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static DispatchThread getNotificationUpdateQueue() {
        if (null != NOTIFICATION_UPDATE_QUEUE) return NOTIFICATION_UPDATE_QUEUE;
        Class<DownloadNotifier> clazz = DownloadNotifier.class;
        synchronized (DownloadNotifier.class) {
            if (null != NOTIFICATION_UPDATE_QUEUE) return NOTIFICATION_UPDATE_QUEUE;
            NOTIFICATION_UPDATE_QUEUE = DispatchThread.create((String)"Notifier");
            // ** MonitorExit[var0] (shouldn't be in output)
            return NOTIFICATION_UPDATE_QUEUE;
        }
    }

    DownloadNotifier(Context context, int id) {
        block5: {
            this.requestCode = (int)SystemClock.uptimeMillis();
            this.mAddedCancelAction = false;
            this.mContent = "";
            this.mNotificationId = id;
            Runtime.getInstance().log(TAG, " DownloadNotifier:" + this.mNotificationId);
            this.mContext = context;
            this.mNotificationManager = (NotificationManager)this.mContext.getSystemService("notification");
            try {
                if (Build.VERSION.SDK_INT >= 26) {
                    String channelId = "";
                    channelId = this.mContext.getPackageName().concat(Runtime.getInstance().getVersion());
                    this.mBuilder = new NotificationCompat.Builder(this.mContext, channelId);
                    NotificationChannel mNotificationChannel = new NotificationChannel(channelId, (CharSequence)Runtime.getInstance().getApplicationName(context), 2);
                    NotificationManager mNotificationManager = (NotificationManager)this.mContext.getSystemService("notification");
                    if (null != mNotificationManager) {
                        mNotificationManager.createNotificationChannel(mNotificationChannel);
                    }
                    mNotificationChannel.enableLights(false);
                    mNotificationChannel.enableVibration(false);
                    mNotificationChannel.setSound(null, null);
                } else {
                    this.mBuilder = new NotificationCompat.Builder(this.mContext);
                }
            }
            catch (Throwable ignore) {
                if (!Runtime.getInstance().isDebug()) break block5;
                ignore.printStackTrace();
            }
        }
    }

    void initBuilder(DownloadTask downloadTask) {
        String title = this.getTitle(downloadTask);
        this.mDownloadTask = downloadTask;
        this.mBuilder.setContentIntent(PendingIntent.getActivity((Context)this.mContext, (int)200, (Intent)new Intent(), (int)0x8000000));
        this.mBuilder.setSmallIcon(this.mDownloadTask.getDownloadIcon());
        this.mBuilder.setTicker((CharSequence)this.mContext.getString(R.string.download_trickter));
        this.mBuilder.setContentTitle((CharSequence)title);
        this.mBuilder.setContentText((CharSequence)this.mContext.getString(R.string.download_coming_soon_download));
        this.mBuilder.setWhen(System.currentTimeMillis());
        this.mBuilder.setAutoCancel(true);
        this.mBuilder.setPriority(-1);
        int defaults = 0;
        this.mBuilder.setDeleteIntent(this.buildCancelContent(this.mContext, downloadTask.getId(), downloadTask.getUrl()));
        this.mBuilder.setDefaults(defaults);
    }

    void updateTitle(DownloadTask downloadTask) {
        String title = this.getTitle(downloadTask);
        this.mBuilder.setContentTitle((CharSequence)title);
    }

    @NonNull
    private String getTitle(DownloadTask downloadTask) {
        String title = null == downloadTask.getFile() || TextUtils.isEmpty((CharSequence)downloadTask.getFile().getName()) ? this.mContext.getString(R.string.download_file_download) : downloadTask.getFile().getName();
        return title;
    }

    private PendingIntent buildCancelContent(Context context, int id, String url) {
        Intent intentCancel = new Intent(Runtime.getInstance().append(context, "com.download.cancelled"));
        intentCancel.putExtra("TAG", url);
        PendingIntent pendingIntentCancel = PendingIntent.getBroadcast((Context)context, (int)(id * 1000), (Intent)intentCancel, (int)0x8000000);
        Runtime.getInstance().log(TAG, "buildCancelContent id:" + id * 1000 + " cancal action:" + Runtime.getInstance().append(context, "com.download.cancelled"));
        return pendingIntentCancel;
    }

    private void setProgress(int maxprogress, int currentprogress, boolean exc) {
        this.mBuilder.setProgress(maxprogress, currentprogress, exc);
        this.sent();
    }

    private boolean hasDeleteContent() {
        return this.mBuilder.getNotification().deleteIntent != null;
    }

    private void setDelecte(PendingIntent intent) {
        this.mBuilder.getNotification().deleteIntent = intent;
    }

    private void sent() {
        DownloadNotifier.getNotificationUpdateQueue().post(new Runnable(){

            @Override
            public void run() {
                DownloadNotifier.this.mNotification = DownloadNotifier.this.mBuilder.build();
                DownloadNotifier.this.mNotificationManager.notify(DownloadNotifier.this.mNotificationId, DownloadNotifier.this.mNotification);
            }
        });
    }

    void onPreDownload() {
        this.sent();
    }

    void onDownloading(int progress) {
        if (!this.hasDeleteContent()) {
            this.setDelecte(this.buildCancelContent(this.mContext, this.mNotificationId, this.mDownloadTask.mUrl));
        }
        if (!this.mAddedCancelAction) {
            this.mAddedCancelAction = true;
            this.mAction = new NotificationCompat.Action(17170445, (CharSequence)this.mContext.getString(0x1040000), this.buildCancelContent(this.mContext, this.mNotificationId, this.mDownloadTask.mUrl));
            this.mBuilder.addAction(this.mAction);
        }
        this.mContent = this.mContext.getString(R.string.download_current_downloading_progress, new Object[]{progress + "%"});
        this.mBuilder.setContentText((CharSequence)this.mContent);
        this.setProgress(100, progress, false);
        this.sent();
    }

    void onDownloaded(long loaded) {
        if (!this.hasDeleteContent()) {
            this.setDelecte(this.buildCancelContent(this.mContext, this.mNotificationId, this.mDownloadTask.mUrl));
        }
        if (!this.mAddedCancelAction) {
            this.mAddedCancelAction = true;
            this.mAction = new NotificationCompat.Action(this.mDownloadTask.getDownloadIcon(), (CharSequence)this.mContext.getString(0x1040000), this.buildCancelContent(this.mContext, this.mNotificationId, this.mDownloadTask.mUrl));
            this.mBuilder.addAction(this.mAction);
        }
        this.mContent = this.mContext.getString(R.string.download_current_downloaded_length, new Object[]{DownloadNotifier.byte2FitMemorySize(loaded)});
        this.mBuilder.setContentText((CharSequence)this.mContent);
        this.setProgress(100, 20, true);
        this.sent();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private long getDelayTime() {
        Class<DownloadNotifier> clazz = DownloadNotifier.class;
        synchronized (DownloadNotifier.class) {
            long current = SystemClock.elapsedRealtime();
            if (current >= sLastUpdateNoticationTime + 500L) {
                sLastUpdateNoticationTime = current;
                // ** MonitorExit[var1_1] (shouldn't be in output)
                return 0L;
            }
            long detal = 500L - (current - sLastUpdateNoticationTime);
            sLastUpdateNoticationTime += detal;
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return detal;
        }
    }

    private static String byte2FitMemorySize(long byteNum) {
        if (byteNum < 0L) {
            return "shouldn't be less than zero!";
        }
        if (byteNum < 1024L) {
            return String.format(Locale.getDefault(), "%.1fB", (double)byteNum);
        }
        if (byteNum < 0x100000L) {
            return String.format(Locale.getDefault(), "%.1fKB", (double)byteNum / 1024.0);
        }
        if (byteNum < 0x40000000L) {
            return String.format(Locale.getDefault(), "%.1fMB", (double)byteNum / 1048576.0);
        }
        return String.format(Locale.getDefault(), "%.1fGB", (double)byteNum / 1.073741824E9);
    }

    void onDownloadPaused() {
        Runtime.getInstance().log(TAG, " onDownloadPaused:" + this.mDownloadTask.getUrl());
        if (!this.hasDeleteContent()) {
            this.setDelecte(this.buildCancelContent(this.mContext, this.mNotificationId, this.mDownloadTask.mUrl));
        }
        if (TextUtils.isEmpty((CharSequence)this.mContent)) {
            this.mContent = "";
        }
        this.mBuilder.setContentText((CharSequence)this.mContent.concat("(").concat(this.mContext.getString(R.string.download_paused)).concat(")"));
        this.mBuilder.setSmallIcon(this.mDownloadTask.getDownloadDoneIcon());
        this.removeCancelAction();
        this.mAddedCancelAction = false;
        DownloadNotifier.getNotificationUpdateQueue().postRunnable(new Runnable(){

            @Override
            public void run() {
                DownloadNotifier.this.sent();
            }
        }, this.getDelayTime());
    }

    void onDownloadFinished() {
        this.removeCancelAction();
        Intent mIntent = Runtime.getInstance().getCommonFileIntentCompat(this.mContext, this.mDownloadTask);
        this.setDelecte(null);
        if (null != mIntent) {
            if (!(this.mContext instanceof Activity)) {
                mIntent.addFlags(0x10000000);
            }
            PendingIntent rightPendIntent = PendingIntent.getActivity((Context)this.mContext, (int)(this.mNotificationId * 10000), (Intent)mIntent, (int)0x8000000);
            this.mBuilder.setSmallIcon(this.mDownloadTask.getDownloadDoneIcon());
            this.mBuilder.setContentText((CharSequence)this.mContext.getString(R.string.download_click_open));
            this.mBuilder.setProgress(100, 100, false);
            this.mBuilder.setContentIntent(rightPendIntent);
            DownloadNotifier.getNotificationUpdateQueue().postRunnable(new Runnable(){

                @Override
                public void run() {
                    DownloadNotifier.this.sent();
                }
            }, this.getDelayTime());
        }
    }

    private void removeCancelAction() {
        block4: {
            try {
                Class<?> clazz = this.mBuilder.getClass();
                Field mField = clazz.getDeclaredField("mActions");
                ArrayList mActions = null;
                if (null != mField) {
                    mActions = (ArrayList)mField.get(this.mBuilder);
                }
                int index = -1;
                if (null != mActions && (index = mActions.indexOf(this.mAction)) != -1) {
                    mActions.remove(index);
                }
            }
            catch (Throwable ignore) {
                if (!Runtime.getInstance().isDebug()) break block4;
                ignore.printStackTrace();
            }
        }
    }

    void cancel() {
        final int notificationId = this.mNotificationId;
        DownloadNotifier.getNotificationUpdateQueue().postRunnableScissors(new Runnable(){

            @Override
            public void run() {
                DownloadNotifier.this.mNotificationManager.cancel(notificationId);
            }
        });
    }

    static void cancel(final DownloadTask downloadTask) {
        final int notificationId = downloadTask.mId;
        final Context context = downloadTask.getContext();
        final DownloadListener downloadListener = downloadTask.getDownloadListener();
        DownloadNotifier.getNotificationUpdateQueue().postRunnableScissors(new Runnable(){

            @Override
            public void run() {
                NotificationManager notificationManager = (NotificationManager)context.getSystemService("notification");
                if (null != notificationManager) {
                    notificationManager.cancel(notificationId);
                }
            }
        });
        GlobalQueue.getMainQueue().post(new Runnable(){

            @Override
            public void run() {
                if (null != downloadListener) {
                    downloadListener.onResult(new DownloadException(16390, (String)Downloader.DOWNLOAD_MESSAGE.get(16390)), downloadTask.getFileUri(), downloadTask.getUrl(), downloadTask);
                }
            }
        });
    }
}

