/*
 * Decompiled with CFR 0.152.
 */
package com.download.library;

import android.os.Handler;
import android.os.Looper;
import com.download.library.DownloadTask;
import com.download.library.Downloader;
import java.io.File;
import java.util.concurrent.Callable;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.locks.Condition;
import java.util.concurrent.locks.ReentrantLock;

public class SyncDownloader
extends Downloader
implements Callable<File> {
    private static final Handler HANDLER = new Handler(Looper.getMainLooper());
    private volatile boolean mEnqueue;
    private ReentrantLock mLock = new ReentrantLock();
    private Condition mCondition = this.mLock.newCondition();

    SyncDownloader(DownloadTask downloadTask) {
        this.mDownloadTask = downloadTask;
    }

    @Override
    protected void onPreExecute() {
        try {
            super.onPreExecute();
        }
        catch (Throwable throwable) {
            this.mThrowable = throwable;
            throw throwable;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void onPostExecute(Integer integer) {
        try {
            super.onPostExecute(integer);
        }
        finally {
            this.mLock.lock();
            try {
                this.mCondition.signal();
            }
            finally {
                this.mLock.unlock();
            }
        }
    }

    @Override
    protected void destroyTask() {
    }

    @Override
    public DownloadTask cancelDownload() {
        super.cancelDownload();
        return null;
    }

    @Override
    public File call() throws Exception {
        if (Looper.myLooper() == Looper.getMainLooper()) {
            throw new UnsupportedOperationException("Sync download must call it in the non main-Thread  ");
        }
        this.mLock.lock();
        try {
            final CountDownLatch syncLatch = new CountDownLatch(1);
            HANDLER.post(new Runnable(){

                @Override
                public void run() {
                    SyncDownloader.this.mEnqueue = SyncDownloader.this.download(SyncDownloader.this.mDownloadTask);
                    syncLatch.countDown();
                }
            });
            syncLatch.await();
            if (!this.mEnqueue) {
                throw new RuntimeException("download task already exist!");
            }
            this.mCondition.await();
        }
        finally {
            this.mLock.unlock();
        }
        if (null != this.mThrowable) {
            throw (RuntimeException)this.mThrowable;
        }
        return this.mDownloadTask.mFile;
    }
}

