/*
 * Decompiled with CFR 0.152.
 */
package com.download.library;

import android.content.Context;
import android.support.annotation.NonNull;
import android.text.TextUtils;
import com.download.library.DownloadNotifier;
import com.download.library.DownloadTask;
import com.download.library.Downloader;
import com.download.library.ExecuteTasksMap;
import com.download.library.ResourceRequest;
import com.download.library.Runtime;
import com.download.library.SyncDownloader;
import java.io.File;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;

public final class DownloadImpl {
    private static final DownloadImpl sInstance = new DownloadImpl();
    private final ConcurrentHashMap<String, DownloadTask> mTasks = new ConcurrentHashMap();
    private static Context mContext;
    public static final String TAG;

    private DownloadImpl() {
    }

    public static DownloadImpl getInstance() {
        return sInstance;
    }

    public ResourceRequest with(@NonNull Context context) {
        if (null != context) {
            mContext = context.getApplicationContext();
        }
        return ResourceRequest.with(mContext);
    }

    public ResourceRequest with(@NonNull String url) {
        if (null == mContext) {
            throw new NullPointerException("Context can't be null . ");
        }
        return ResourceRequest.with(mContext).url(url);
    }

    public ResourceRequest with(@NonNull Context context, @NonNull String url) {
        if (null != context) {
            mContext = context.getApplicationContext();
        }
        return ResourceRequest.with(mContext).url(url);
    }

    private void safe(@NonNull DownloadTask downloadTask) {
        if (null == downloadTask.getContext()) {
            throw new NullPointerException("context can't be null .");
        }
        if (TextUtils.isEmpty((CharSequence)downloadTask.getUrl())) {
            throw new NullPointerException("url can't be empty .");
        }
    }

    public boolean enqueue(@NonNull DownloadTask downloadTask) {
        this.safe(downloadTask);
        return new Downloader().download(downloadTask);
    }

    public File call(@NonNull DownloadTask downloadTask) {
        this.safe(downloadTask);
        SyncDownloader callable = new SyncDownloader(downloadTask);
        try {
            return (File)callable.call();
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    public File callEx(@NonNull DownloadTask downloadTask) throws Exception {
        this.safe(downloadTask);
        SyncDownloader callable = new SyncDownloader(downloadTask);
        return (File)callable.call();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public DownloadTask cancel(@NonNull String url) {
        DownloadTask downloadTask = null;
        try {
            downloadTask = ExecuteTasksMap.getInstance().cancelTask(url);
        }
        finally {
            DownloadTask task = this.mTasks.get(url);
            if (task != null && task.getStatus() == 1003) {
                task.setStatus(1005);
                DownloadNotifier.cancel(task);
                downloadTask = task;
            }
            this.remove(url);
        }
        return downloadTask;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<DownloadTask> cancelAll() {
        ArrayList<DownloadTask> downloadTasks = new ArrayList<DownloadTask>();
        try {
            List<DownloadTask> runningTask = ExecuteTasksMap.getInstance().cancelTasks();
            if (null != runningTask) {
                downloadTasks.addAll(runningTask);
            }
        }
        finally {
            ConcurrentHashMap<String, DownloadTask> tasks = this.mTasks;
            if (!tasks.isEmpty()) {
                Set<Map.Entry<String, DownloadTask>> sets = tasks.entrySet();
                for (Map.Entry<String, DownloadTask> entry : sets) {
                    DownloadTask downloadTask = entry.getValue();
                    if (downloadTask == null || downloadTask.getStatus() != 1003) continue;
                    downloadTask.setStatus(1005);
                    DownloadNotifier.cancel(downloadTask);
                    downloadTasks.add(downloadTask);
                }
            }
            this.cleanTasksCache();
        }
        return downloadTasks;
    }

    public DownloadTask pause(@NonNull String url) {
        DownloadTask downloadTask = ExecuteTasksMap.getInstance().pauseTask(url);
        if (downloadTask != null) {
            this.mTasks.put(downloadTask.getUrl(), downloadTask);
        }
        return downloadTask;
    }

    public void resumeAll() {
        ConcurrentHashMap<String, DownloadTask> tasks = this.mTasks;
        if (tasks.size() <= 0) {
            return;
        }
        Set<Map.Entry<String, DownloadTask>> sets = tasks.entrySet();
        if (sets != null && sets.size() > 0) {
            for (Map.Entry<String, DownloadTask> entry : sets) {
                DownloadTask downloadTask = entry.getValue();
                if (null == downloadTask || null == downloadTask.getContext() || TextUtils.isEmpty((CharSequence)downloadTask.getUrl())) {
                    Runtime.getInstance().logError(TAG, "downloadTask death .");
                    continue;
                }
                this.enqueue(downloadTask);
            }
        }
        this.cleanTasksCache();
    }

    public boolean resume(@NonNull String url) {
        DownloadTask downloadTask = this.mTasks.remove(url);
        if (null == downloadTask || null == downloadTask.getContext() || TextUtils.isEmpty((CharSequence)downloadTask.getUrl())) {
            Runtime.getInstance().logError(TAG, "downloadTask death .");
            return false;
        }
        this.enqueue(downloadTask);
        return true;
    }

    private void cleanTasksCache() {
        ConcurrentHashMap<String, DownloadTask> tasks = this.mTasks;
        tasks.clear();
    }

    private void remove(@NonNull String url) {
        ConcurrentHashMap<String, DownloadTask> tasks = this.mTasks;
        tasks.remove(url);
    }

    public boolean exist(@NonNull String url) {
        return ExecuteTasksMap.getInstance().exist(url) || this.mTasks.contains(url);
    }

    public boolean isPaused(@NonNull String url) {
        DownloadTask downloadTask = this.mTasks.get(url);
        return downloadTask != null && downloadTask.getStatus() == 1003;
    }

    public int pausedTasksTotals() {
        return this.mTasks.size();
    }

    public boolean isRunning(@NonNull String url) {
        return ExecuteTasksMap.getInstance().exist(url);
    }

    static {
        TAG = DownloadImpl.class.getSimpleName();
    }
}

