/*
 * Decompiled with CFR 0.152.
 */
package com.download.library;

import android.content.Context;
import android.content.Intent;
import android.content.pm.ApplicationInfo;
import android.content.pm.PackageManager;
import android.net.ConnectivityManager;
import android.net.NetworkInfo;
import android.net.Uri;
import android.os.Build;
import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import android.support.v4.content.FileProvider;
import android.text.TextUtils;
import android.util.Log;
import com.download.library.DefaultStorageEngine;
import com.download.library.DownloadTask;
import com.download.library.Extra;
import com.download.library.StorageEngine;
import java.io.File;
import java.io.IOException;
import java.math.BigInteger;
import java.security.MessageDigest;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class Runtime {
    private static final Runtime sInstance = new Runtime();
    private DownloadTask sDefaultDownloadTask;
    private AtomicInteger mIDGenerator = new AtomicInteger(1);
    private AtomicInteger mThreadGlobalCounter = new AtomicInteger(1);
    private File mDownloadDir = null;
    private static Pattern DISPOSITION_PATTERN = Pattern.compile(".*filename=(.*)");
    static final String PREFIX = "Download-";
    boolean DEBUG = true;
    private String authority;
    private StorageEngine mStorageEngine;
    private StorageEngine.StorageEngineFactory mStorageEngineFactory;

    public void setDebug(boolean debug) {
        this.DEBUG = debug;
    }

    public boolean isDebug() {
        return this.DEBUG;
    }

    private Runtime() {
    }

    public static Runtime getInstance() {
        return sInstance;
    }

    public StorageEngine getStorageEngine(Context context) {
        StorageEngine storageEngine = this.mStorageEngine;
        if (null == storageEngine) {
            storageEngine = this.mStorageEngine = this.getStorageEngineFactory().newStoraEngine(context);
        }
        return storageEngine;
    }

    StorageEngine.StorageEngineFactory getStorageEngineFactory() {
        StorageEngine.StorageEngineFactory storageEngineFactory = this.mStorageEngineFactory;
        if (null == this.mStorageEngineFactory) {
            storageEngineFactory = this.mStorageEngineFactory = new DefaultStorageEngine.DefaultStorageEngineFactory();
        }
        return storageEngineFactory;
    }

    public void setStorageEngineFactory(StorageEngine.StorageEngineFactory storageEngineFactory) {
        this.mStorageEngineFactory = storageEngineFactory;
        this.mStorageEngine = null;
    }

    public DownloadTask getDefaultDownloadTask() {
        if (null == this.sDefaultDownloadTask) {
            this.createDefaultDownloadTask();
        }
        return this.sDefaultDownloadTask.clone();
    }

    private void createDefaultDownloadTask() {
        this.sDefaultDownloadTask = new DownloadTask();
        this.sDefaultDownloadTask.setBreakPointDownload(true).setIcon(0x1080081).setConnectTimeOut(6000).setBlockMaxTime(600000).setDownloadTimeOut(Long.MAX_VALUE).setParallelDownload(true).setEnableIndicator(false).setAutoOpen(false).setForceDownload(true);
    }

    public String getIdentify() {
        return "Downloader";
    }

    public String getVersion() {
        return "4.0.3";
    }

    public int generateGlobalId() {
        return this.mIDGenerator.getAndIncrement();
    }

    public int generateGlobalThreadId() {
        return this.mThreadGlobalCounter.getAndIncrement();
    }

    public File createFile(Context context, Extra extra) {
        return this.createFile(context, extra, null);
    }

    public File createFile(Context context, Extra extra, File dir) {
        String fileName = "";
        try {
            String path;
            File pathFile;
            fileName = this.getFileNameByContentDisposition(extra.getContentDisposition());
            if (TextUtils.isEmpty((CharSequence)fileName) && !TextUtils.isEmpty((CharSequence)extra.getUrl())) {
                Uri mUri = Uri.parse((String)extra.getUrl());
                fileName = mUri.getPath().substring(mUri.getPath().lastIndexOf(47) + 1);
            }
            if (!TextUtils.isEmpty((CharSequence)fileName) && fileName.length() > 64) {
                fileName = fileName.substring(fileName.length() - 64, fileName.length());
            }
            if (TextUtils.isEmpty((CharSequence)fileName)) {
                fileName = this.md5(extra.getUrl());
            }
            if (fileName.contains("\"")) {
                fileName = fileName.replace("\"", "");
            }
            if (!(pathFile = new File(path = dir == null || !dir.isDirectory() ? this.getDir(context, extra.isEnableIndicator()).getPath() : dir.getAbsolutePath())).exists()) {
                pathFile.mkdirs();
            }
            return this.createFileByName(pathFile, context, fileName, !extra.isBreakPointDownload());
        }
        catch (Throwable e) {
            e.printStackTrace();
            return null;
        }
    }

    public boolean checkWifi(Context context) {
        ConnectivityManager connectivity = (ConnectivityManager)context.getSystemService("connectivity");
        if (connectivity == null) {
            return false;
        }
        NetworkInfo info = connectivity.getActiveNetworkInfo();
        return info != null && info.isConnected() && info.getType() == 1;
    }

    public boolean checkNetwork(Context context) {
        ConnectivityManager connectivity = (ConnectivityManager)context.getSystemService("connectivity");
        if (connectivity == null) {
            return false;
        }
        NetworkInfo info = connectivity.getActiveNetworkInfo();
        return info != null && info.isConnected();
    }

    File createFileByName(File path, Context context, String name, boolean cover) throws IOException {
        if (!path.isDirectory()) {
            return null;
        }
        File mFile = new File(path, name);
        if (mFile.exists()) {
            if (cover) {
                mFile.delete();
                mFile.createNewFile();
            }
        } else {
            mFile.createNewFile();
        }
        return mFile;
    }

    String getFileNameByContentDisposition(String contentDisposition) {
        if (TextUtils.isEmpty((CharSequence)contentDisposition)) {
            return "";
        }
        Matcher m = DISPOSITION_PATTERN.matcher(contentDisposition.toLowerCase());
        if (m.find()) {
            return m.group(1);
        }
        return "";
    }

    public File getDir(Context context, boolean isPublic) {
        File file = this.mDownloadDir == null || !this.mDownloadDir.isDirectory() ? context.getCacheDir() : this.mDownloadDir;
        if (!(file = new File(file, "download" + File.separator + (isPublic ? "public" : "privite"))).exists()) {
            file.mkdirs();
        }
        return file;
    }

    public File getDir(Context context) {
        return this.getDir(context, false);
    }

    public File getDefaultDir(Context context) {
        File file = new File(context.getCacheDir(), "download");
        if (!file.exists()) {
            file.mkdirs();
        }
        return file;
    }

    public void log(String tag, String msg) {
        if (this.DEBUG) {
            Log.i((String)tag, (String)msg);
        }
    }

    public File uniqueFile(@NonNull DownloadTask downloadTask, @Nullable File targetDir) {
        String md5;
        File dir = targetDir == null || !targetDir.isDirectory() ? Runtime.getInstance().getDir(downloadTask.getContext(), downloadTask.isEnableIndicator()) : targetDir;
        File target = new File(dir, md5 = Runtime.getInstance().md5(downloadTask.getUrl()));
        if (!target.exists()) {
            target.mkdirs();
        }
        if (!target.isDirectory()) {
            target.delete();
            target.mkdirs();
        }
        return this.createFile(downloadTask.getContext(), downloadTask, target);
    }

    public void setDownloadDir(File downloadDir, String authority) {
        this.mDownloadDir = downloadDir;
        this.authority = authority;
    }

    public void logError(String tag, String msg) {
        if (this.DEBUG) {
            Log.e((String)tag, (String)msg);
        }
    }

    public String md5(String str) {
        try {
            MessageDigest md = MessageDigest.getInstance("MD5");
            md.update(str.getBytes());
            return new BigInteger(1, md.digest()).toString(16);
        }
        catch (Exception e) {
            if (this.isDebug()) {
                e.printStackTrace();
            }
            return "";
        }
    }

    public String getApplicationName(Context context) {
        PackageManager packageManager = null;
        ApplicationInfo applicationInfo = null;
        try {
            packageManager = context.getApplicationContext().getPackageManager();
            applicationInfo = packageManager.getApplicationInfo(context.getPackageName(), 0);
        }
        catch (PackageManager.NameNotFoundException e) {
            applicationInfo = null;
        }
        String applicationName = (String)packageManager.getApplicationLabel(applicationInfo);
        return applicationName;
    }

    public Intent getCommonFileIntentCompat(Context context, DownloadTask downloadTask) {
        Intent mIntent = new Intent().setAction("android.intent.action.VIEW");
        this.setIntentDataAndType(context, mIntent, this.getMIMEType(downloadTask.getFile()), downloadTask.getFile(), false, downloadTask.isCustomFile() ? downloadTask.getAuthority() : this.getAuthority(downloadTask.getContext()));
        return mIntent;
    }

    private String getAuthority(Context context) {
        return TextUtils.isEmpty((CharSequence)this.authority) ? (this.authority = context.getPackageName() + ".DownloadFileProvider") : this.authority;
    }

    public Uri getUriFromFile(Context context, File file, String authority) {
        Uri uri = null;
        uri = Build.VERSION.SDK_INT >= 24 ? FileProvider.getUriForFile((Context)context, (String)authority, (File)file) : Uri.fromFile((File)file);
        return uri;
    }

    public Uri getUriFromFileForN(Context context, File file) {
        Uri fileUri = FileProvider.getUriForFile((Context)context, (String)(context.getPackageName() + ".DownloadFileProvider"), (File)file);
        return fileUri;
    }

    public void setIntentDataAndType(Context context, Intent intent, String type, File file, boolean writeAble, String authority) {
        if (Build.VERSION.SDK_INT >= 24) {
            intent.setDataAndType(this.getUriFromFile(context, file, authority), type);
            intent.addFlags(1);
            if (writeAble) {
                intent.addFlags(2);
            }
        } else {
            intent.setDataAndType(Uri.fromFile((File)file), type);
        }
    }

    public String getMIMEType(File f) {
        String type = "";
        String fName = f.getName();
        String end = fName.substring(fName.lastIndexOf(".") + 1, fName.length()).toLowerCase();
        type = end.equals("pdf") ? "application/pdf" : (end.equals("m4a") || end.equals("mp3") || end.equals("mid") || end.equals("xmf") || end.equals("ogg") || end.equals("wav") ? "audio/*" : (end.equals("3gp") || end.equals("mp4") ? "video/*" : (end.equals("jpg") || end.equals("gif") || end.equals("png") || end.equals("jpeg") || end.equals("bmp") ? "image/*" : (end.equals("apk") ? "application/vnd.android.package-archive" : (end.equals("pptx") || end.equals("ppt") ? "application/vnd.ms-powerpoint" : (end.equals("docx") || end.equals("doc") ? "application/vnd.ms-word" : (end.equals("xlsx") || end.equals("xls") ? "application/vnd.ms-excel" : "*/*")))))));
        return type;
    }
}

