/*
 * Decompiled with CFR 0.152.
 */
package com.download.library;

import android.content.Context;
import android.net.Uri;
import android.os.SystemClock;
import android.support.annotation.DrawableRes;
import android.support.annotation.NonNull;
import android.support.v4.util.ArrayMap;
import android.text.TextUtils;
import com.download.library.DownloadListener;
import com.download.library.DownloadListenerAdapter;
import com.download.library.DownloadTask;
import com.download.library.DownloadingListener;
import com.download.library.Extra;
import com.download.library.Runtime;
import java.io.File;
import java.io.Serializable;
import java.util.concurrent.atomic.AtomicInteger;

public class DownloadTask
extends Extra
implements Serializable,
Cloneable {
    static final String TAG = "Download-" + DownloadTask.class.getSimpleName();
    int mId = Runtime.getInstance().generateGlobalId();
    long mTotalsLength;
    Context mContext;
    File mFile;
    DownloadListener mDownloadListener;
    DownloadingListener mDownloadingListener;
    String authority = "";
    public static final int STATUS_NEW = 1000;
    public static final int STATUS_PENDDING = 1001;
    public static final int STATUS_DOWNLOADING = 1002;
    public static final int STATUS_PAUSED = 1003;
    public static final int STATUS_COMPLETED = 1004;
    long beginTime = 0L;
    long pauseTime = 0L;
    long endTime = 0L;
    long detalTime = 0L;
    boolean isCustomFile = false;
    boolean uniquePath = true;
    int connectTimes = 0;
    private AtomicInteger status = new AtomicInteger(1000);

    public int getStatus() {
        return this.status.get();
    }

    void setStatus(@DownloadTaskStatus int status) {
        this.status.set(status);
    }

    void resetTime() {
        this.beginTime = 0L;
        this.pauseTime = 0L;
        this.endTime = 0L;
        this.detalTime = 0L;
    }

    public int getId() {
        return this.mId;
    }

    public Context getContext() {
        return this.mContext;
    }

    public DownloadTask setContext(Context context) {
        this.mContext = context.getApplicationContext();
        return this;
    }

    public DownloadTask setEnableIndicator(boolean enableIndicator) {
        if (enableIndicator && this.mFile != null && TextUtils.isEmpty((CharSequence)this.authority)) {
            Runtime.getInstance().logError(TAG, " Custom file path, you must specify authority, otherwise the notification should not be turned on");
            this.mEnableIndicator = false;
        } else {
            this.mEnableIndicator = enableIndicator;
        }
        return this;
    }

    public File getFile() {
        return this.mFile;
    }

    public Uri getFileUri() {
        return Uri.fromFile((File)this.mFile);
    }

    String getAuthority() {
        return this.authority;
    }

    public DownloadTask setFile(@NonNull File file) {
        this.mFile = file;
        this.authority = "";
        this.checkCustomFilePath(file);
        return this;
    }

    private void checkCustomFilePath(File file) {
        if (file == null || file.getAbsolutePath().startsWith(Runtime.getInstance().getDefaultDir(this.getContext()).getAbsolutePath())) {
            this.isCustomFile = false;
        } else if (!TextUtils.isEmpty((CharSequence)this.authority)) {
            this.setEnableIndicator(true);
            this.isCustomFile = true;
        } else {
            this.setEnableIndicator(false);
            this.isCustomFile = true;
        }
    }

    boolean isCustomFile() {
        return this.isCustomFile;
    }

    public DownloadTask setFile(@NonNull File file, @NonNull String authority) {
        this.mFile = file;
        this.authority = authority;
        this.checkCustomFilePath(file);
        return this;
    }

    void updateTime(long beginTime) {
        if (this.beginTime == 0L) {
            this.beginTime = beginTime;
            return;
        }
        if (this.beginTime != beginTime) {
            this.detalTime += Math.abs(beginTime - this.pauseTime);
        }
    }

    public long getUsedTime() {
        if (this.status.get() == 1002) {
            return this.beginTime > 0L ? SystemClock.elapsedRealtime() - this.beginTime - this.detalTime : 0L;
        }
        if (this.status.get() == 1004) {
            return this.endTime - this.beginTime - this.detalTime;
        }
        return 0L;
    }

    public long getBeginTime() {
        return this.beginTime;
    }

    protected void pause() {
        this.pauseTime = SystemClock.elapsedRealtime();
    }

    protected void completed() {
        this.endTime = SystemClock.elapsedRealtime();
    }

    protected void destroy() {
        this.mId = -1;
        this.mUrl = null;
        this.mContext = null;
        this.mFile = null;
        this.mIsParallelDownload = false;
        this.mIsForceDownload = false;
        this.mEnableIndicator = true;
        this.mDownloadIcon = 0x1080081;
        this.mDownloadDoneIcon = 17301634;
        this.mIsParallelDownload = true;
        this.mIsBreakPointDownload = true;
        this.mUserAgent = "";
        this.mContentDisposition = "";
        this.mMimetype = "";
        this.mContentLength = -1L;
        if (this.mHeaders != null) {
            this.mHeaders.clear();
            this.mHeaders = null;
        }
        this.status.set(1000);
    }

    DownloadingListener getDownloadingListener() {
        return this.mDownloadingListener;
    }

    public DownloadTask setDownloadingListener(DownloadingListener downloadingListener) {
        this.mDownloadingListener = downloadingListener;
        return this;
    }

    public DownloadListener getDownloadListener() {
        return this.mDownloadListener;
    }

    public DownloadTask setDownloadListener(DownloadListener downloadListener) {
        this.mDownloadListener = downloadListener;
        return this;
    }

    public DownloadTask setDownloadListenerAdapter(DownloadListenerAdapter downloadListenerAdapter) {
        this.setDownloadListener(downloadListenerAdapter);
        this.setDownloadingListener(downloadListenerAdapter);
        return this;
    }

    void setTotalsLength(long totalsLength) {
        this.mTotalsLength = totalsLength;
    }

    public long getTotalsLength() {
        return this.mTotalsLength;
    }

    public DownloadTask setBreakPointDownload(boolean breakPointDownload) {
        this.mIsBreakPointDownload = breakPointDownload;
        return this;
    }

    public DownloadTask setForceDownload(boolean force) {
        this.mIsForceDownload = force;
        return this;
    }

    public DownloadTask setIcon(@DrawableRes int icon) {
        this.mDownloadIcon = icon;
        return this;
    }

    public DownloadTask setParallelDownload(boolean parallelDownload) {
        this.mIsParallelDownload = parallelDownload;
        return this;
    }

    public DownloadTask addHeader(String key, String value) {
        if (this.mHeaders == null) {
            this.mHeaders = new ArrayMap();
        }
        this.mHeaders.put(key, value);
        return this;
    }

    public DownloadTask setAutoOpen(boolean autoOpen) {
        this.mAutoOpen = autoOpen;
        return this;
    }

    public DownloadTask setDownloadTimeOut(long downloadTimeOut) {
        this.downloadTimeOut = downloadTimeOut;
        return this;
    }

    public DownloadTask setConnectTimeOut(int connectTimeOut) {
        this.connectTimeOut = connectTimeOut;
        return this;
    }

    public DownloadTask setBlockMaxTime(int blockMaxTime) {
        this.blockMaxTime = blockMaxTime;
        return this;
    }

    public DownloadTask setUserAgent(String userAgent) {
        this.mUserAgent = userAgent;
        return this;
    }

    public DownloadTask setContentLength(long contentLength) {
        this.mContentLength = contentLength;
        return this;
    }

    public DownloadTask setMimetype(String mimetype) {
        this.mMimetype = mimetype;
        return this;
    }

    public DownloadTask setContentDisposition(String contentDisposition) {
        this.mContentDisposition = contentDisposition;
        return this;
    }

    public DownloadTask setUrl(String url) {
        this.mUrl = url;
        return this;
    }

    public DownloadTask setDownloadDoneIcon(@DrawableRes int icon) {
        this.mDownloadDoneIcon = icon;
        return this;
    }

    @Override
    public DownloadTask clone() {
        try {
            DownloadTask downloadTask = (DownloadTask)super.clone();
            downloadTask.mId = Runtime.getInstance().generateGlobalId();
            return downloadTask;
        }
        catch (Throwable throwable) {
            throwable.printStackTrace();
            return new DownloadTask();
        }
    }

    public boolean isUniquePath() {
        return this.uniquePath;
    }

    public void setUniquePath(boolean uniquePath) {
        this.uniquePath = uniquePath;
    }

    public void setLength(long length) {
        this.mTotalsLength = length;
    }
}

