/*
 * Decompiled with CFR 0.152.
 */
package dev.jorel.commandapi.nms;

import com.google.common.io.Files;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonElement;
import com.mojang.authlib.GameProfile;
import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import com.mojang.brigadier.suggestion.SuggestionProvider;
import com.mojang.brigadier.suggestion.Suggestions;
import com.mojang.brigadier.suggestion.SuggestionsBuilder;
import com.mojang.brigadier.tree.CommandNode;
import de.tr7zw.changeme.nbtapi.NBTContainer;
import dev.jorel.commandapi.CommandAPIHandler;
import dev.jorel.commandapi.arguments.EntitySelectorArgument;
import dev.jorel.commandapi.arguments.ICustomProvidedArgument;
import dev.jorel.commandapi.arguments.LocationType;
import dev.jorel.commandapi.exceptions.AngleArgumentException;
import dev.jorel.commandapi.exceptions.BiomeArgumentException;
import dev.jorel.commandapi.exceptions.UUIDArgumentException;
import dev.jorel.commandapi.nms.NMS;
import dev.jorel.commandapi.wrappers.FloatRange;
import dev.jorel.commandapi.wrappers.FunctionWrapper;
import dev.jorel.commandapi.wrappers.IntegerRange;
import dev.jorel.commandapi.wrappers.Location2D;
import dev.jorel.commandapi.wrappers.MathOperation;
import dev.jorel.commandapi.wrappers.NativeProxyCommandSender;
import dev.jorel.commandapi.wrappers.Rotation;
import dev.jorel.commandapi.wrappers.ScoreboardSlot;
import dev.jorel.commandapi.wrappers.SimpleFunctionWrapper;
import java.io.File;
import java.io.IOException;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.EnumSet;
import java.util.HashSet;
import java.util.Set;
import java.util.UUID;
import java.util.function.Predicate;
import java.util.function.ToIntBiFunction;
import java.util.function.ToIntFunction;
import java.util.stream.Collectors;
import net.kyori.adventure.text.Component;
import net.kyori.adventure.text.serializer.gson.GsonComponentSerializer;
import net.md_5.bungee.api.chat.BaseComponent;
import net.md_5.bungee.chat.ComponentSerializer;
import net.minecraft.server.v1_14_R1.Advancement;
import net.minecraft.server.v1_14_R1.ArgumentBlockPredicate;
import net.minecraft.server.v1_14_R1.ArgumentChat;
import net.minecraft.server.v1_14_R1.ArgumentChatComponent;
import net.minecraft.server.v1_14_R1.ArgumentChatFormat;
import net.minecraft.server.v1_14_R1.ArgumentCriterionValue;
import net.minecraft.server.v1_14_R1.ArgumentDimension;
import net.minecraft.server.v1_14_R1.ArgumentEnchantment;
import net.minecraft.server.v1_14_R1.ArgumentEntity;
import net.minecraft.server.v1_14_R1.ArgumentEntitySummon;
import net.minecraft.server.v1_14_R1.ArgumentItemPredicate;
import net.minecraft.server.v1_14_R1.ArgumentItemStack;
import net.minecraft.server.v1_14_R1.ArgumentMathOperation;
import net.minecraft.server.v1_14_R1.ArgumentMinecraftKeyRegistered;
import net.minecraft.server.v1_14_R1.ArgumentMobEffect;
import net.minecraft.server.v1_14_R1.ArgumentNBTTag;
import net.minecraft.server.v1_14_R1.ArgumentParticle;
import net.minecraft.server.v1_14_R1.ArgumentPosition;
import net.minecraft.server.v1_14_R1.ArgumentProfile;
import net.minecraft.server.v1_14_R1.ArgumentRegistry;
import net.minecraft.server.v1_14_R1.ArgumentRotation;
import net.minecraft.server.v1_14_R1.ArgumentRotationAxis;
import net.minecraft.server.v1_14_R1.ArgumentScoreboardCriteria;
import net.minecraft.server.v1_14_R1.ArgumentScoreboardObjective;
import net.minecraft.server.v1_14_R1.ArgumentScoreboardSlot;
import net.minecraft.server.v1_14_R1.ArgumentScoreboardTeam;
import net.minecraft.server.v1_14_R1.ArgumentScoreholder;
import net.minecraft.server.v1_14_R1.ArgumentTag;
import net.minecraft.server.v1_14_R1.ArgumentTile;
import net.minecraft.server.v1_14_R1.ArgumentTime;
import net.minecraft.server.v1_14_R1.ArgumentVec2;
import net.minecraft.server.v1_14_R1.ArgumentVec2I;
import net.minecraft.server.v1_14_R1.ArgumentVec3;
import net.minecraft.server.v1_14_R1.BlockPosition;
import net.minecraft.server.v1_14_R1.BlockPosition2D;
import net.minecraft.server.v1_14_R1.CommandListenerWrapper;
import net.minecraft.server.v1_14_R1.CompletionProviders;
import net.minecraft.server.v1_14_R1.CriterionConditionValue;
import net.minecraft.server.v1_14_R1.CustomFunction;
import net.minecraft.server.v1_14_R1.CustomFunctionData;
import net.minecraft.server.v1_14_R1.DimensionManager;
import net.minecraft.server.v1_14_R1.Entity;
import net.minecraft.server.v1_14_R1.EntitySelector;
import net.minecraft.server.v1_14_R1.EntityTypes;
import net.minecraft.server.v1_14_R1.EnumChatFormat;
import net.minecraft.server.v1_14_R1.EnumDirection;
import net.minecraft.server.v1_14_R1.IBlockData;
import net.minecraft.server.v1_14_R1.IChatBaseComponent;
import net.minecraft.server.v1_14_R1.ICompletionProvider;
import net.minecraft.server.v1_14_R1.IRegistry;
import net.minecraft.server.v1_14_R1.IVectorPosition;
import net.minecraft.server.v1_14_R1.IWorldReader;
import net.minecraft.server.v1_14_R1.LootTableRegistry;
import net.minecraft.server.v1_14_R1.MinecraftKey;
import net.minecraft.server.v1_14_R1.ParticleParam;
import net.minecraft.server.v1_14_R1.Scoreboard;
import net.minecraft.server.v1_14_R1.ScoreboardScore;
import net.minecraft.server.v1_14_R1.ShapeDetectorBlock;
import net.minecraft.server.v1_14_R1.Vec2F;
import net.minecraft.server.v1_14_R1.Vec3D;
import net.minecraft.server.v1_14_R1.World;
import org.bukkit.Axis;
import org.bukkit.Bukkit;
import org.bukkit.ChatColor;
import org.bukkit.Location;
import org.bukkit.NamespacedKey;
import org.bukkit.Particle;
import org.bukkit.Sound;
import org.bukkit.World;
import org.bukkit.block.Biome;
import org.bukkit.block.Block;
import org.bukkit.block.data.BlockData;
import org.bukkit.command.Command;
import org.bukkit.command.CommandSender;
import org.bukkit.command.SimpleCommandMap;
import org.bukkit.craftbukkit.v1_14_R1.CraftLootTable;
import org.bukkit.craftbukkit.v1_14_R1.CraftParticle;
import org.bukkit.craftbukkit.v1_14_R1.CraftServer;
import org.bukkit.craftbukkit.v1_14_R1.CraftSound;
import org.bukkit.craftbukkit.v1_14_R1.CraftWorld;
import org.bukkit.craftbukkit.v1_14_R1.block.data.CraftBlockData;
import org.bukkit.craftbukkit.v1_14_R1.command.VanillaCommandWrapper;
import org.bukkit.craftbukkit.v1_14_R1.enchantments.CraftEnchantment;
import org.bukkit.craftbukkit.v1_14_R1.entity.CraftEntity;
import org.bukkit.craftbukkit.v1_14_R1.entity.CraftPlayer;
import org.bukkit.craftbukkit.v1_14_R1.inventory.CraftItemStack;
import org.bukkit.craftbukkit.v1_14_R1.potion.CraftPotionEffectType;
import org.bukkit.craftbukkit.v1_14_R1.util.CraftChatMessage;
import org.bukkit.enchantments.Enchantment;
import org.bukkit.entity.EntityType;
import org.bukkit.entity.Player;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.Recipe;
import org.bukkit.loot.LootTable;
import org.bukkit.potion.PotionEffectType;

public class NMS_1_14
implements NMS<CommandListenerWrapper> {
    @Override
    public Component getAdventureChat(CommandContext<CommandListenerWrapper> cmdCtx, String key) throws CommandSyntaxException {
        String jsonString = IChatBaseComponent.ChatSerializer.a((IChatBaseComponent)ArgumentChat.a(cmdCtx, (String)key));
        return GsonComponentSerializer.gson().deserialize((Object)jsonString);
    }

    @Override
    public Component getAdventureChatComponent(CommandContext<CommandListenerWrapper> cmdCtx, String key) {
        String jsonString = IChatBaseComponent.ChatSerializer.a((IChatBaseComponent)ArgumentChatComponent.a(cmdCtx, (String)key));
        return GsonComponentSerializer.gson().deserialize((Object)jsonString);
    }

    private SimpleFunctionWrapper convertFunction(CustomFunction customFunction) {
        NamespacedKey minecraftKey = new NamespacedKey(customFunction.a().b(), customFunction.a().getKey());
        CustomFunctionData customFunctionData = ((CraftServer)Bukkit.getServer()).getServer().getFunctionData();
        ToIntBiFunction<CustomFunction, CommandListenerWrapper> obj = (arg_0, arg_1) -> ((CustomFunctionData)customFunctionData).a(arg_0, arg_1);
        ToIntFunction<CommandListenerWrapper> appliedObj = clw -> obj.applyAsInt(customFunction, (CommandListenerWrapper)clw);
        return new SimpleFunctionWrapper(minecraftKey, appliedObj, (String[])Arrays.stream(customFunction.b()).map(Object::toString).toArray(String[]::new));
    }

    @Override
    public Set<NamespacedKey> getFunctions() {
        HashSet<NamespacedKey> functions = new HashSet<NamespacedKey>();
        for (MinecraftKey key : ((CraftServer)Bukkit.getServer()).getServer().getFunctionData().c().keySet()) {
            functions.add(new NamespacedKey(key.b(), key.getKey()));
        }
        return functions;
    }

    @Override
    public Set<NamespacedKey> getTags() {
        HashSet<NamespacedKey> functions = new HashSet<NamespacedKey>();
        for (MinecraftKey key : ((CraftServer)Bukkit.getServer()).getServer().getFunctionData().g().a()) {
            functions.add(new NamespacedKey(key.b(), key.getKey()));
        }
        return functions;
    }

    @Override
    public SimpleFunctionWrapper[] getTag(NamespacedKey key) {
        MinecraftKey minecraftKey = new MinecraftKey(key.getNamespace(), key.getKey());
        CustomFunctionData functionData = ((CraftServer)Bukkit.getServer()).getServer().getFunctionData();
        return (SimpleFunctionWrapper[])functionData.g().b(minecraftKey).a().stream().map(this::convertFunction).toArray(SimpleFunctionWrapper[]::new);
    }

    @Override
    public SimpleFunctionWrapper getFunction(NamespacedKey key) {
        MinecraftKey minecraftKey = new MinecraftKey(key.getNamespace(), key.getKey());
        CustomFunctionData functionData = ((CraftServer)Bukkit.getServer()).getServer().getFunctionData();
        return this.convertFunction((CustomFunction)functionData.a(minecraftKey).get());
    }

    @Override
    public FunctionWrapper[] getFunction(CommandContext<CommandListenerWrapper> cmdCtx, String str) throws CommandSyntaxException {
        Collection customFuncList = ArgumentTag.a(cmdCtx, (String)str);
        FunctionWrapper[] result = new FunctionWrapper[customFuncList.size()];
        CommandListenerWrapper commandListenerWrapper = this.getCLW(cmdCtx).a().b(2);
        int count = 0;
        for (CustomFunction customFunction : customFuncList) {
            result[count++] = FunctionWrapper.fromSimpleFunctionWrapper(this.convertFunction(customFunction), commandListenerWrapper, e -> this.getCLW(cmdCtx).a(((CraftEntity)e).getHandle()));
        }
        return result;
    }

    @Override
    public CommandListenerWrapper getCLWFromCommandSender(CommandSender sender) {
        return VanillaCommandWrapper.getListener((CommandSender)sender);
    }

    @Override
    public ArgumentType<?> _ArgumentAngle() {
        throw new AngleArgumentException();
    }

    @Override
    public ArgumentType<?> _ArgumentAxis() {
        return ArgumentRotationAxis.a();
    }

    @Override
    public ArgumentType<?> _ArgumentBlockPredicate() {
        return ArgumentBlockPredicate.a();
    }

    @Override
    public ArgumentType<?> _ArgumentBlockState() {
        return ArgumentTile.a();
    }

    @Override
    public ArgumentType<?> _ArgumentChat() {
        return ArgumentChat.a();
    }

    @Override
    public ArgumentType<?> _ArgumentChatComponent() {
        return ArgumentChatComponent.a();
    }

    @Override
    public ArgumentType<?> _ArgumentChatFormat() {
        return ArgumentChatFormat.a();
    }

    @Override
    public ArgumentType<?> _ArgumentDimension() {
        return ArgumentDimension.a();
    }

    @Override
    public ArgumentType<?> _ArgumentEnchantment() {
        return ArgumentEnchantment.a();
    }

    @Override
    public ArgumentType<?> _ArgumentEntity(EntitySelectorArgument.EntitySelector selector) {
        switch (selector) {
            case MANY_ENTITIES: {
                return ArgumentEntity.multipleEntities();
            }
            case MANY_PLAYERS: {
                return ArgumentEntity.d();
            }
            case ONE_ENTITY: {
                return ArgumentEntity.a();
            }
            case ONE_PLAYER: {
                return ArgumentEntity.c();
            }
        }
        return null;
    }

    @Override
    public ArgumentType<?> _ArgumentEntitySummon() {
        return ArgumentEntitySummon.a();
    }

    @Override
    public ArgumentType<?> _ArgumentFloatRange() {
        return new ArgumentCriterionValue.a();
    }

    @Override
    public ArgumentType<?> _ArgumentIntRange() {
        return new ArgumentCriterionValue.b();
    }

    @Override
    public ArgumentType<?> _ArgumentItemPredicate() {
        return ArgumentItemPredicate.a();
    }

    @Override
    public ArgumentType<?> _ArgumentItemStack() {
        return ArgumentItemStack.a();
    }

    @Override
    public ArgumentType<?> _ArgumentMathOperation() {
        return ArgumentMathOperation.a();
    }

    @Override
    public ArgumentType<?> _ArgumentMinecraftKeyRegistered() {
        return ArgumentMinecraftKeyRegistered.a();
    }

    @Override
    public ArgumentType<?> _ArgumentMobEffect() {
        return ArgumentMobEffect.a();
    }

    @Override
    public ArgumentType<?> _ArgumentNBTCompound() {
        return ArgumentNBTTag.a();
    }

    @Override
    public ArgumentType<?> _ArgumentParticle() {
        return ArgumentParticle.a();
    }

    @Override
    public ArgumentType<?> _ArgumentPosition() {
        return ArgumentPosition.a();
    }

    @Override
    public ArgumentType<?> _ArgumentPosition2D() {
        return ArgumentVec2I.a();
    }

    @Override
    public ArgumentType<?> _ArgumentProfile() {
        return ArgumentProfile.a();
    }

    @Override
    public ArgumentType<?> _ArgumentRotation() {
        return ArgumentRotation.a();
    }

    @Override
    public ArgumentType<?> _ArgumentScoreboardCriteria() {
        return ArgumentScoreboardCriteria.a();
    }

    @Override
    public ArgumentType<?> _ArgumentScoreboardObjective() {
        return ArgumentScoreboardObjective.a();
    }

    @Override
    public ArgumentType<?> _ArgumentScoreboardSlot() {
        return ArgumentScoreboardSlot.a();
    }

    @Override
    public ArgumentType<?> _ArgumentScoreboardTeam() {
        return ArgumentScoreboardTeam.a();
    }

    @Override
    public ArgumentType<?> _ArgumentScoreholder(boolean single) {
        return single ? ArgumentScoreholder.a() : ArgumentScoreholder.b();
    }

    @Override
    public ArgumentType<?> _ArgumentTag() {
        return ArgumentTag.a();
    }

    @Override
    public ArgumentType<?> _ArgumentTime() {
        return ArgumentTime.a();
    }

    @Override
    public ArgumentType<?> _ArgumentUUID() {
        throw new UUIDArgumentException();
    }

    @Override
    public ArgumentType<?> _ArgumentVec2() {
        return ArgumentVec2.a();
    }

    @Override
    public ArgumentType<?> _ArgumentVec3() {
        return ArgumentVec3.a();
    }

    @Override
    public String[] compatibleVersions() {
        return new String[]{"1.14", "1.14.1", "1.14.2"};
    }

    @Override
    public String convert(ItemStack is) {
        net.minecraft.server.v1_14_R1.ItemStack nmsItemStack = CraftItemStack.asNMSCopy((ItemStack)is);
        return is.getType().getKey().toString() + nmsItemStack.getOrCreateTag().asString();
    }

    @Override
    public String convert(Particle particle) {
        return CraftParticle.toNMS((Particle)particle).a();
    }

    @Override
    public String convert(PotionEffectType potion) {
        return IRegistry.MOB_EFFECT.getKey(IRegistry.MOB_EFFECT.fromId(potion.getId())).toString();
    }

    @Override
    public String convert(Sound sound) {
        return CraftSound.getSound((Sound)sound);
    }

    @Override
    public void createDispatcherFile(File file, CommandDispatcher<CommandListenerWrapper> dispatcher) throws IOException {
        Files.write((CharSequence)new GsonBuilder().setPrettyPrinting().create().toJson((JsonElement)ArgumentRegistry.a(dispatcher, (CommandNode)dispatcher.getRoot())), (File)file, (Charset)StandardCharsets.UTF_8);
    }

    @Override
    public org.bukkit.advancement.Advancement getAdvancement(CommandContext<CommandListenerWrapper> cmdCtx, String key) throws CommandSyntaxException {
        return ArgumentMinecraftKeyRegistered.a(cmdCtx, (String)key).bukkit;
    }

    @Override
    public float getAngle(CommandContext<CommandListenerWrapper> cmdCtx, String key) {
        throw new AngleArgumentException();
    }

    @Override
    public EnumSet<Axis> getAxis(CommandContext<CommandListenerWrapper> cmdCtx, String key) {
        EnumSet<Axis> set = EnumSet.noneOf(Axis.class);
        EnumSet parsedEnumSet = ArgumentRotationAxis.a(cmdCtx, (String)key);
        for (EnumDirection.EnumAxis element : parsedEnumSet) {
            switch (element) {
                case X: {
                    set.add(Axis.X);
                    break;
                }
                case Y: {
                    set.add(Axis.Y);
                    break;
                }
                case Z: {
                    set.add(Axis.Z);
                }
            }
        }
        return set;
    }

    @Override
    public Biome getBiome(CommandContext<CommandListenerWrapper> cmdCtx, String key) {
        throw new BiomeArgumentException();
    }

    @Override
    public Predicate<Block> getBlockPredicate(CommandContext<CommandListenerWrapper> cmdCtx, String key) throws CommandSyntaxException {
        Predicate predicate = ArgumentBlockPredicate.a(cmdCtx, (String)key);
        return block -> predicate.test(new ShapeDetectorBlock((IWorldReader)this.getCLW(cmdCtx).getWorld(), new BlockPosition(block.getX(), block.getY(), block.getZ()), true));
    }

    @Override
    public BlockData getBlockState(CommandContext<CommandListenerWrapper> cmdCtx, String key) {
        return CraftBlockData.fromData((IBlockData)ArgumentTile.a(cmdCtx, (String)key).a());
    }

    @Override
    public CommandDispatcher<CommandListenerWrapper> getBrigadierDispatcher() {
        return ((CraftServer)Bukkit.getServer()).getServer().getCommandDispatcher().a();
    }

    @Override
    public BaseComponent[] getChat(CommandContext<CommandListenerWrapper> cmdCtx, String key) throws CommandSyntaxException {
        String resultantString = IChatBaseComponent.ChatSerializer.a((IChatBaseComponent)ArgumentChat.a(cmdCtx, (String)key));
        return ComponentSerializer.parse((String)resultantString);
    }

    @Override
    public ChatColor getChatColor(CommandContext<CommandListenerWrapper> cmdCtx, String str) {
        return CraftChatMessage.getColor((EnumChatFormat)ArgumentChatFormat.a(cmdCtx, (String)str));
    }

    @Override
    public BaseComponent[] getChatComponent(CommandContext<CommandListenerWrapper> cmdCtx, String str) {
        String resultantString = IChatBaseComponent.ChatSerializer.a((IChatBaseComponent)ArgumentChatComponent.a(cmdCtx, (String)str));
        return ComponentSerializer.parse((String)resultantString);
    }

    private CommandListenerWrapper getCLW(CommandContext<CommandListenerWrapper> cmdCtx) {
        return (CommandListenerWrapper)cmdCtx.getSource();
    }

    @Override
    public CommandSender getCommandSenderForCLW(CommandListenerWrapper clw) {
        try {
            return clw.getBukkitSender();
        }
        catch (UnsupportedOperationException e) {
            return null;
        }
    }

    @Override
    public World.Environment getDimension(CommandContext<CommandListenerWrapper> cmdCtx, String key) {
        DimensionManager manager = ArgumentDimension.a(cmdCtx, (String)key);
        switch (manager.getDimensionID()) {
            case 0: {
                return World.Environment.NORMAL;
            }
            case -1: {
                return World.Environment.NETHER;
            }
            case 1: {
                return World.Environment.THE_END;
            }
        }
        return null;
    }

    @Override
    public Enchantment getEnchantment(CommandContext<CommandListenerWrapper> cmdCtx, String str) {
        return new CraftEnchantment(ArgumentEnchantment.a(cmdCtx, (String)str));
    }

    @Override
    public Object getEntitySelector(CommandContext<CommandListenerWrapper> cmdCtx, String str, EntitySelectorArgument.EntitySelector selector) throws CommandSyntaxException {
        EntitySelector argument = (EntitySelector)cmdCtx.getArgument(str, EntitySelector.class);
        try {
            CommandAPIHandler.getInstance().getField(EntitySelector.class, "checkPermissions").set(argument, false);
        }
        catch (IllegalAccessException | IllegalArgumentException e1) {
            e1.printStackTrace();
        }
        switch (selector) {
            case MANY_ENTITIES: {
                try {
                    return argument.getEntities((CommandListenerWrapper)cmdCtx.getSource()).stream().map(entity -> entity.getBukkitEntity()).collect(Collectors.toList());
                }
                catch (CommandSyntaxException e) {
                    return new ArrayList();
                }
            }
            case MANY_PLAYERS: {
                try {
                    return argument.d((CommandListenerWrapper)cmdCtx.getSource()).stream().map(player -> (Player)player.getBukkitEntity()).collect(Collectors.toList());
                }
                catch (CommandSyntaxException e) {
                    return new ArrayList();
                }
            }
            case ONE_ENTITY: {
                return argument.a((CommandListenerWrapper)cmdCtx.getSource()).getBukkitEntity();
            }
            case ONE_PLAYER: {
                return argument.c((CommandListenerWrapper)cmdCtx.getSource()).getBukkitEntity();
            }
        }
        throw new IllegalStateException("A serious error has occurred! Contact the author of the CommandAPI");
    }

    @Override
    public EntityType getEntityType(CommandContext<CommandListenerWrapper> cmdCtx, String str) throws CommandSyntaxException {
        Entity entity = ((EntityTypes)IRegistry.ENTITY_TYPE.get(ArgumentEntitySummon.a(cmdCtx, (String)str))).a((World)this.getCLW(cmdCtx).getWorld().getWorld().getHandle());
        return entity.getBukkitEntity().getType();
    }

    @Override
    public FloatRange getFloatRange(CommandContext<CommandListenerWrapper> cmdCtx, String key) {
        CriterionConditionValue.FloatRange range = (CriterionConditionValue.FloatRange)cmdCtx.getArgument(key, CriterionConditionValue.FloatRange.class);
        float low = range.a() == null ? -3.4028235E38f : ((Float)range.a()).floatValue();
        float high = range.b() == null ? Float.MAX_VALUE : ((Float)range.b()).floatValue();
        return new FloatRange(low, high);
    }

    @Override
    public IntegerRange getIntRange(CommandContext<CommandListenerWrapper> cmdCtx, String key) {
        CriterionConditionValue.IntegerRange range = ArgumentCriterionValue.b.a(cmdCtx, (String)key);
        int low = range.a() == null ? Integer.MIN_VALUE : (Integer)range.a();
        int high = range.b() == null ? Integer.MAX_VALUE : (Integer)range.b();
        return new IntegerRange(low, high);
    }

    @Override
    public ItemStack getItemStack(CommandContext<CommandListenerWrapper> cmdCtx, String str) throws CommandSyntaxException {
        return CraftItemStack.asBukkitCopy((net.minecraft.server.v1_14_R1.ItemStack)ArgumentItemStack.a(cmdCtx, (String)str).a(1, false));
    }

    @Override
    public Predicate<ItemStack> getItemStackPredicate(CommandContext<CommandListenerWrapper> cmdCtx, String key) throws CommandSyntaxException {
        Predicate predicate = ArgumentItemPredicate.a(cmdCtx, (String)key);
        return item -> predicate.test(CraftItemStack.asNMSCopy((ItemStack)item));
    }

    @Override
    public String getKeyedAsString(CommandContext<CommandListenerWrapper> cmdCtx, String key) throws CommandSyntaxException {
        MinecraftKey minecraftKey = ArgumentMinecraftKeyRegistered.c(cmdCtx, (String)key);
        return minecraftKey.toString();
    }

    @Override
    public Location getLocation(CommandContext<CommandListenerWrapper> cmdCtx, String str, LocationType locationType) throws CommandSyntaxException {
        switch (locationType) {
            case BLOCK_POSITION: {
                BlockPosition blockPos = ArgumentPosition.a(cmdCtx, (String)str);
                return new Location((org.bukkit.World)this.getCLW(cmdCtx).getWorld().getWorld(), (double)blockPos.getX(), (double)blockPos.getY(), (double)blockPos.getZ());
            }
            case PRECISE_POSITION: {
                Vec3D vecPos = ArgumentVec3.a(cmdCtx, (String)str);
                return new Location((org.bukkit.World)this.getCLW(cmdCtx).getWorld().getWorld(), vecPos.x, vecPos.y, vecPos.z);
            }
        }
        return null;
    }

    @Override
    public Location2D getLocation2D(CommandContext<CommandListenerWrapper> cmdCtx, String key, LocationType locationType2d) throws CommandSyntaxException {
        switch (locationType2d) {
            case BLOCK_POSITION: {
                BlockPosition2D blockPos = ArgumentVec2I.a(cmdCtx, (String)key);
                return new Location2D((org.bukkit.World)this.getCLW(cmdCtx).getWorld().getWorld(), blockPos.a, blockPos.b);
            }
            case PRECISE_POSITION: {
                Vec2F vecPos = ArgumentVec2.a(cmdCtx, (String)key);
                return new Location2D((org.bukkit.World)this.getCLW(cmdCtx).getWorld().getWorld(), vecPos.i, vecPos.j);
            }
        }
        return null;
    }

    @Override
    public LootTable getLootTable(CommandContext<CommandListenerWrapper> cmdCtx, String str) {
        MinecraftKey minecraftKey = ArgumentMinecraftKeyRegistered.c(cmdCtx, (String)str);
        String namespace = minecraftKey.b();
        String key = minecraftKey.getKey();
        net.minecraft.server.v1_14_R1.LootTable lootTable = this.getCLW(cmdCtx).getServer().getLootTableRegistry().getLootTable(minecraftKey);
        return new CraftLootTable(new NamespacedKey(namespace, key), lootTable);
    }

    @Override
    public MathOperation getMathOperation(CommandContext<CommandListenerWrapper> cmdCtx, String key) throws CommandSyntaxException {
        ArgumentMathOperation.a result = ArgumentMathOperation.a(cmdCtx, (String)key);
        Scoreboard board = new Scoreboard();
        ScoreboardScore tester_left = new ScoreboardScore(board, null, null);
        ScoreboardScore tester_right = new ScoreboardScore(board, null, null);
        tester_left.setScore(6);
        tester_right.setScore(2);
        result.apply(tester_left, tester_right);
        switch (tester_left.getScore()) {
            case 8: {
                return MathOperation.ADD;
            }
            case 4: {
                return MathOperation.SUBTRACT;
            }
            case 12: {
                return MathOperation.MULTIPLY;
            }
            case 3: {
                return MathOperation.DIVIDE;
            }
            case 0: {
                return MathOperation.MOD;
            }
            case 6: {
                return MathOperation.MAX;
            }
            case 2: {
                if (tester_right.getScore() == 6) {
                    return MathOperation.SWAP;
                }
                tester_left.setScore(2);
                tester_right.setScore(6);
                result.apply(tester_left, tester_right);
                if (tester_left.getScore() == 2) {
                    return MathOperation.MIN;
                }
                return MathOperation.ASSIGN;
            }
        }
        return null;
    }

    @Override
    public NBTContainer getNBTCompound(CommandContext<CommandListenerWrapper> cmdCtx, String key) {
        return new NBTContainer((Object)ArgumentNBTTag.a(cmdCtx, (String)key));
    }

    @Override
    public String getObjective(CommandContext<CommandListenerWrapper> cmdCtx, String key) throws IllegalArgumentException, CommandSyntaxException {
        return ArgumentScoreboardObjective.a(cmdCtx, (String)key).getName();
    }

    @Override
    public String getObjectiveCriteria(CommandContext<CommandListenerWrapper> cmdCtx, String key) {
        return ArgumentScoreboardCriteria.a(cmdCtx, (String)key).getName();
    }

    @Override
    public Particle getParticle(CommandContext<CommandListenerWrapper> cmdCtx, String str) {
        return CraftParticle.toBukkit((ParticleParam)ArgumentParticle.a(cmdCtx, (String)str));
    }

    @Override
    public Player getPlayer(CommandContext<CommandListenerWrapper> cmdCtx, String str) throws CommandSyntaxException {
        Player target = Bukkit.getPlayer((UUID)((GameProfile)ArgumentProfile.a(cmdCtx, (String)str).iterator().next()).getId());
        if (target == null) {
            throw ArgumentProfile.a.create();
        }
        return target;
    }

    @Override
    public PotionEffectType getPotionEffect(CommandContext<CommandListenerWrapper> cmdCtx, String str) throws CommandSyntaxException {
        return new CraftPotionEffectType(ArgumentMobEffect.a(cmdCtx, (String)str));
    }

    @Override
    public Recipe getRecipe(CommandContext<CommandListenerWrapper> cmdCtx, String key) throws CommandSyntaxException {
        return ArgumentMinecraftKeyRegistered.b(cmdCtx, (String)key).toBukkitRecipe();
    }

    @Override
    public Rotation getRotation(CommandContext<CommandListenerWrapper> cmdCtx, String key) {
        IVectorPosition pos = ArgumentRotation.a(cmdCtx, (String)key);
        Vec2F vec = pos.b(this.getCLW(cmdCtx));
        return new Rotation(vec.i, vec.j);
    }

    @Override
    public ScoreboardSlot getScoreboardSlot(CommandContext<CommandListenerWrapper> cmdCtx, String key) {
        return new ScoreboardSlot(ArgumentScoreboardSlot.a(cmdCtx, (String)key));
    }

    @Override
    public Collection<String> getScoreHolderMultiple(CommandContext<CommandListenerWrapper> cmdCtx, String key) throws CommandSyntaxException {
        return ArgumentScoreholder.b(cmdCtx, (String)key);
    }

    @Override
    public String getScoreHolderSingle(CommandContext<CommandListenerWrapper> cmdCtx, String key) throws CommandSyntaxException {
        return ArgumentScoreholder.a(cmdCtx, (String)key);
    }

    @Override
    public CommandSender getSenderForCommand(CommandContext<CommandListenerWrapper> cmdCtx, boolean isNative) {
        CraftEntity proxy;
        CommandListenerWrapper clw = this.getCLW(cmdCtx);
        Object sender = clw.getBukkitSender();
        Vec3D pos = clw.getPosition();
        Vec2F rot = clw.i();
        CraftWorld world = clw.getWorld().getWorld();
        Location location = new Location((org.bukkit.World)clw.getWorld().getWorld(), pos.getX(), pos.getY(), pos.getZ(), rot.j, rot.i);
        Entity proxyEntity = clw.getEntity();
        CraftEntity craftEntity = proxy = proxyEntity == null ? null : proxyEntity.getBukkitEntity();
        if (isNative || proxy != null && !sender.equals(proxy)) {
            sender = new NativeProxyCommandSender((CommandSender)sender, (CommandSender)proxy, location, (org.bukkit.World)world);
        }
        return sender;
    }

    @Override
    public SimpleCommandMap getSimpleCommandMap() {
        return ((CraftServer)Bukkit.getServer()).getCommandMap();
    }

    @Override
    public Sound getSound(CommandContext<CommandListenerWrapper> cmdCtx, String key) {
        MinecraftKey minecraftKey = ArgumentMinecraftKeyRegistered.c(cmdCtx, (String)key);
        for (CraftSound sound : CraftSound.values()) {
            try {
                if (!CommandAPIHandler.getInstance().getField(CraftSound.class, "minecraftKey").get(sound).equals(minecraftKey.getKey())) continue;
                return Sound.valueOf((String)sound.name());
            }
            catch (IllegalAccessException | IllegalArgumentException e1) {
                e1.printStackTrace();
            }
        }
        return null;
    }

    @Override
    public SuggestionProvider<CommandListenerWrapper> getSuggestionProvider(ICustomProvidedArgument.SuggestionProviders provider) {
        switch (provider) {
            case FUNCTION: {
                return (context, builder) -> {
                    CustomFunctionData functionData = this.getCLW((CommandContext<CommandListenerWrapper>)context).getServer().getFunctionData();
                    ICompletionProvider.a((Iterable)functionData.g().a(), (SuggestionsBuilder)builder, (String)"#");
                    return ICompletionProvider.a(functionData.c().keySet(), (SuggestionsBuilder)builder);
                };
            }
            case RECIPES: {
                return CompletionProviders.b;
            }
            case SOUNDS: {
                return CompletionProviders.c;
            }
            case ADVANCEMENTS: {
                return (cmdCtx, builder) -> {
                    Collection advancements = ((CommandListenerWrapper)cmdCtx.getSource()).getServer().getAdvancementData().b();
                    return ICompletionProvider.a(advancements.stream().map(Advancement::getName), (SuggestionsBuilder)builder);
                };
            }
            case LOOT_TABLES: {
                return (context, builder) -> {
                    LootTableRegistry lootTables = this.getCLW((CommandContext<CommandListenerWrapper>)context).getServer().getLootTableRegistry();
                    return ICompletionProvider.a((Iterable)lootTables.a(), (SuggestionsBuilder)builder);
                };
            }
            case ENTITIES: {
                return CompletionProviders.d;
            }
        }
        return (context, builder) -> Suggestions.empty();
    }

    @Override
    public String getTeam(CommandContext<CommandListenerWrapper> cmdCtx, String key) throws CommandSyntaxException {
        return ArgumentScoreboardTeam.a(cmdCtx, (String)key).getName();
    }

    @Override
    public int getTime(CommandContext<CommandListenerWrapper> cmdCtx, String key) {
        return (Integer)cmdCtx.getArgument(key, Integer.class);
    }

    @Override
    public UUID getUUID(CommandContext<CommandListenerWrapper> cmdCtx, String key) {
        throw new UUIDArgumentException();
    }

    @Override
    public boolean isVanillaCommandWrapper(Command command) {
        return command instanceof VanillaCommandWrapper;
    }

    @Override
    public void resendPackets(Player player) {
        CraftPlayer craftPlayer = (CraftPlayer)player;
        CraftServer craftServer = (CraftServer)Bukkit.getServer();
        net.minecraft.server.v1_14_R1.CommandDispatcher nmsDispatcher = craftServer.getServer().getCommandDispatcher();
        nmsDispatcher.a(craftPlayer.getHandle());
    }
}

