/*
 * Decompiled with CFR 0.152.
 */
package dev.jorel.commandapi;

import com.mojang.brigadier.LiteralMessage;
import com.mojang.brigadier.Message;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import com.mojang.brigadier.exceptions.SimpleCommandExceptionType;
import dev.jorel.commandapi.exceptions.WrapperCommandSyntaxException;
import dev.jorel.commandapi.executors.ExecutorType;
import dev.jorel.commandapi.executors.IExecutorNormal;
import dev.jorel.commandapi.executors.IExecutorResulting;
import dev.jorel.commandapi.executors.IExecutorTyped;
import java.util.ArrayList;
import java.util.List;
import org.bukkit.command.BlockCommandSender;
import org.bukkit.command.CommandSender;
import org.bukkit.command.ConsoleCommandSender;
import org.bukkit.command.ProxiedCommandSender;
import org.bukkit.entity.Entity;
import org.bukkit.entity.Player;

class CustomCommandExecutor {
    private List<IExecutorNormal<? extends CommandSender>> normalExecutors = new ArrayList<IExecutorNormal<? extends CommandSender>>();
    private List<IExecutorResulting<? extends CommandSender>> resultingExecutors = new ArrayList<IExecutorResulting<? extends CommandSender>>();

    CustomCommandExecutor mergeExecutor(CustomCommandExecutor executor) {
        CustomCommandExecutor result = new CustomCommandExecutor();
        result.normalExecutors = new ArrayList<IExecutorNormal<? extends CommandSender>>(this.normalExecutors);
        result.resultingExecutors = new ArrayList<IExecutorResulting<? extends CommandSender>>(this.resultingExecutors);
        result.normalExecutors.addAll(executor.normalExecutors);
        result.resultingExecutors.addAll(executor.resultingExecutors);
        return result;
    }

    public void addNormalExecutor(IExecutorNormal<? extends CommandSender> ex) {
        this.normalExecutors.add(ex);
    }

    public void addResultingExecutor(IExecutorResulting<? extends CommandSender> rEx) {
        this.resultingExecutors.add(rEx);
    }

    public boolean isEmpty() {
        return this.normalExecutors.isEmpty() && this.resultingExecutors.isEmpty();
    }

    public boolean isForceNative() {
        return this.matches(this.normalExecutors, ExecutorType.NATIVE) || this.matches(this.resultingExecutors, ExecutorType.NATIVE);
    }

    public List<IExecutorNormal<? extends CommandSender>> getNormalExecutors() {
        return this.normalExecutors;
    }

    public void setNormalExecutors(List<IExecutorNormal<? extends CommandSender>> normalExecutors) {
        this.normalExecutors = normalExecutors;
    }

    public List<IExecutorResulting<? extends CommandSender>> getResultingExecutors() {
        return this.resultingExecutors;
    }

    public void setResultingExecutors(List<IExecutorResulting<? extends CommandSender>> resultingExecutors) {
        this.resultingExecutors = resultingExecutors;
    }

    public int execute(CommandSender sender, Object[] arguments) throws CommandSyntaxException {
        if (!this.resultingExecutors.isEmpty()) {
            try {
                return this.execute(this.resultingExecutors, sender, arguments);
            }
            catch (WrapperCommandSyntaxException e) {
                throw e.getException();
            }
            catch (Exception e) {
                e.printStackTrace(System.out);
                return 0;
            }
        }
        try {
            return this.execute(this.normalExecutors, sender, arguments);
        }
        catch (WrapperCommandSyntaxException e) {
            throw e.getException();
        }
        catch (Exception e) {
            e.printStackTrace(System.out);
            return 0;
        }
    }

    private int execute(List<? extends IExecutorTyped> executors, CommandSender sender, Object[] args, ExecutorType type) throws WrapperCommandSyntaxException {
        return executors.stream().filter(o -> o.getType() == type).findFirst().get().executeWith(sender, args);
    }

    private boolean matches(List<? extends IExecutorTyped> executors, ExecutorType type) {
        return executors.stream().map(IExecutorTyped::getType).anyMatch(type::equals);
    }

    private int execute(List<? extends IExecutorTyped> executors, CommandSender sender, Object[] args) throws WrapperCommandSyntaxException {
        if (this.isForceNative()) {
            return this.execute(executors, sender, args, ExecutorType.NATIVE);
        }
        if (sender instanceof Player && this.matches(executors, ExecutorType.PLAYER)) {
            return this.execute(executors, sender, args, ExecutorType.PLAYER);
        }
        if (sender instanceof Entity && this.matches(executors, ExecutorType.ENTITY)) {
            return this.execute(executors, sender, args, ExecutorType.ENTITY);
        }
        if (sender instanceof ConsoleCommandSender && this.matches(executors, ExecutorType.CONSOLE)) {
            return this.execute(executors, sender, args, ExecutorType.CONSOLE);
        }
        if (sender instanceof BlockCommandSender && this.matches(executors, ExecutorType.BLOCK)) {
            return this.execute(executors, sender, args, ExecutorType.BLOCK);
        }
        if (sender instanceof ProxiedCommandSender && this.matches(executors, ExecutorType.PROXY)) {
            return this.execute(executors, sender, args, ExecutorType.PROXY);
        }
        if (this.matches(executors, ExecutorType.ALL)) {
            return this.execute(executors, sender, args, ExecutorType.ALL);
        }
        throw new WrapperCommandSyntaxException(new SimpleCommandExceptionType((Message)new LiteralMessage("This command has no implementations for " + sender.getClass().getSimpleName().toLowerCase())).create());
    }
}

