/*
 * Decompiled with CFR 0.152.
 */
package dev.jorel.commandapi;

import dev.jorel.commandapi.CommandAPI;
import dev.jorel.commandapi.CommandAPICommand;
import dev.jorel.commandapi.CommandAPIHandler;
import dev.jorel.commandapi.CommandPermission;
import dev.jorel.commandapi.arguments.Argument;
import dev.jorel.commandapi.arguments.GreedyStringArgument;
import java.lang.reflect.Proxy;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.bukkit.Bukkit;
import org.bukkit.command.CommandSender;
import org.bukkit.command.PluginCommand;
import org.bukkit.command.ProxiedCommandSender;
import org.bukkit.plugin.Plugin;
import org.bukkit.plugin.java.JavaPlugin;

public abstract class Converter {
    private static final List<Argument> PLAIN_ARGUMENTS = Arrays.asList(new GreedyStringArgument("args"));
    private static final Set<String> CALLER_METHODS = new HashSet<String>(Arrays.asList("isPermissionSet", "hasPermission", "addAttachment", "removeAttachment", "recalculatePermissions", "getEffectivePermissions", "isOp", "setOp"));

    public static void convert(String cmdName) {
        Converter.convertCommand(cmdName, PLAIN_ARGUMENTS);
    }

    public static void convert(String cmdName, List<Argument> arguments) {
        Converter.convertCommand(cmdName, arguments);
    }

    private static void convertCommand(String commandName, List<Argument> arguments) {
        CommandAPI.logInfo("Converting command /" + commandName);
        new CommandAPICommand(commandName).withPermission(CommandPermission.NONE).executesNative((sender, args) -> {
            CommandSender proxiedSender = sender.getCallee();
            Bukkit.dispatchCommand((CommandSender)proxiedSender, (String)commandName);
        }).register();
        CommandAPICommand multiArgs = new CommandAPICommand(commandName).withPermission(CommandPermission.NONE).withArguments(arguments).executesNative((sender, args) -> {
            CommandSender proxiedSender = sender.getCallee();
            Bukkit.dispatchCommand((CommandSender)proxiedSender, (String)(commandName + " " + String.join((CharSequence)" ", (String[])args)));
        });
        multiArgs.setConverted(true);
        multiArgs.register();
    }

    public static void convert(Plugin plugin) {
        CommandAPI.logInfo("Converting commands for " + plugin.getName() + ":");
        plugin.getDescription().getCommands().keySet().forEach(commandName -> Converter.convertPluginCommand((JavaPlugin)plugin, commandName, PLAIN_ARGUMENTS));
    }

    public static void convert(Plugin plugin, String cmdName) {
        Converter.convertPluginCommand((JavaPlugin)plugin, cmdName, PLAIN_ARGUMENTS);
    }

    public static void convert(Plugin plugin, String cmdName, List<Argument> arguments) {
        Converter.convertPluginCommand((JavaPlugin)plugin, cmdName, arguments);
    }

    public static void convert(Plugin plugin, String cmdName, Argument ... arguments) {
        Converter.convertPluginCommand((JavaPlugin)plugin, cmdName, Arrays.asList(arguments));
    }

    private static void convertPluginCommand(JavaPlugin plugin, String commandName, List<Argument> arguments) {
        CommandAPI.logInfo("Converting " + plugin.getName() + " command /" + commandName);
        Map cmdData = (Map)plugin.getDescription().getCommands().get(commandName);
        if (cmdData == null) {
            CommandAPI.getLog().severe("Couldn't find /" + commandName + " in " + plugin.getName() + "'s plugin.yml. Are you sure you're not confusing it with an alias?");
            return;
        }
        Object[] aliases = null;
        Object aliasObj = cmdData.get("aliases");
        if (aliasObj == null) {
            aliases = new String[]{};
        } else if (aliasObj instanceof String) {
            aliases = new String[]{(String)aliasObj};
        } else if (aliasObj instanceof List) {
            List list = (List)aliasObj;
            aliases = list.toArray(new String[0]);
        }
        if (aliases.length != 0) {
            CommandAPI.logInfo("Aliases for command /" + commandName + " found. Using aliases " + Arrays.deepToString(aliases));
        }
        CommandPermission permissionNode = null;
        String permission = (String)cmdData.get("permission");
        if (permission == null) {
            permissionNode = CommandPermission.NONE;
        } else {
            CommandAPI.logInfo("Permission for command /" + commandName + " found. Using " + permission);
            permissionNode = CommandPermission.fromString(permission);
        }
        new CommandAPICommand(commandName).withPermission(permissionNode).withAliases((String[])aliases).executesNative((sender, args) -> {
            PluginCommand command = plugin.getCommand(commandName);
            if (command == null) {
                command = CommandAPIHandler.getInstance().getNMS().getSimpleCommandMap().getCommand(commandName);
            }
            CommandSender proxiedSender = CommandAPI.getConfiguration().shouldSkipSenderProxy((Plugin)plugin) ? sender.getCallee() : Converter.mergeProxySender(sender);
            command.execute(proxiedSender, commandName, new String[0]);
        }).register();
        CommandAPICommand multiArgs = new CommandAPICommand(commandName).withPermission(permissionNode).withAliases((String[])aliases).withArguments(arguments).executesNative((sender, args) -> {
            PluginCommand command = plugin.getCommand(commandName);
            if (command == null) {
                command = CommandAPIHandler.getInstance().getNMS().getSimpleCommandMap().getCommand(commandName);
            }
            CommandSender proxiedSender = CommandAPI.getConfiguration().shouldSkipSenderProxy((Plugin)plugin) ? sender.getCallee() : Converter.mergeProxySender(sender);
            command.execute(proxiedSender, commandName, (String[])args);
        });
        multiArgs.setConverted(true);
        multiArgs.register();
    }

    private static CommandSender mergeProxySender(ProxiedCommandSender proxySender) {
        Class<?>[] interfaces;
        Class<?>[] calleeInterfaces = proxySender.getCallee().getClass().getInterfaces();
        if (proxySender.getCallee().getClass().isInterface()) {
            interfaces = new Class[calleeInterfaces.length + 1];
            System.arraycopy(calleeInterfaces, 0, interfaces, 1, calleeInterfaces.length);
            interfaces[0] = proxySender.getCallee().getClass();
        } else {
            interfaces = calleeInterfaces;
        }
        return (CommandSender)Proxy.newProxyInstance(CommandSender.class.getClassLoader(), interfaces, (p, method, args) -> method.invoke((Object)(CALLER_METHODS.contains(method.getName()) ? proxySender.getCaller() : proxySender.getCallee()), args));
    }
}

