/*
 * Decompiled with CFR 0.152.
 */
package com.droidnet;

import android.content.BroadcastReceiver;
import android.content.Context;
import android.content.Intent;
import android.net.ConnectivityManager;
import android.net.NetworkInfo;
import java.lang.ref.WeakReference;

class NetworkChangeReceiver
extends BroadcastReceiver {
    private WeakReference<NetworkChangeListener> mNetworkChangeListenerWeakReference;

    NetworkChangeReceiver() {
    }

    public void onReceive(Context context, Intent intent) {
        NetworkChangeListener networkChangeListener = (NetworkChangeListener)this.mNetworkChangeListenerWeakReference.get();
        if (networkChangeListener != null) {
            networkChangeListener.onNetworkChange(this.isNetworkConnected(context));
        }
    }

    void setNetworkChangeListener(NetworkChangeListener networkChangeListener) {
        this.mNetworkChangeListenerWeakReference = new WeakReference<NetworkChangeListener>(networkChangeListener);
    }

    void removeNetworkChangeListener() {
        if (this.mNetworkChangeListenerWeakReference != null) {
            this.mNetworkChangeListenerWeakReference.clear();
        }
    }

    boolean isNetworkConnected(Context context) {
        ConnectivityManager connectivityManager = (ConnectivityManager)context.getSystemService("connectivity");
        NetworkInfo netInfo = connectivityManager.getActiveNetworkInfo();
        return netInfo != null && netInfo.isAvailable() && netInfo.isConnected();
    }

    static interface NetworkChangeListener {
        public void onNetworkChange(boolean var1);
    }
}

