/*
 * Decompiled with CFR 0.152.
 */
package com.baozi.treerecyclerview.item;

import android.support.annotation.NonNull;
import com.baozi.treerecyclerview.item.TreeItem;
import com.baozi.treerecyclerview.item.TreeItemGroup;
import java.util.ArrayList;
import java.util.List;

public abstract class TreeSelectItemGroup<D>
extends TreeItemGroup<D> {
    private List<TreeItem> selectItems;

    public List<TreeItem> getSelectItems() {
        if (this.selectItems == null) {
            this.selectItems = new ArrayList<TreeItem>();
        }
        return this.selectItems;
    }

    public boolean isSelectAll() {
        return this.getSelectItems().containsAll(this.getChild());
    }

    public void selectAll(boolean b) {
        this.getSelectItems().clear();
        if (b && this.getChildCount() != 0) {
            this.getSelectItems().addAll(this.getChild());
        }
    }

    public boolean isChildSelect() {
        return !this.getSelectItems().isEmpty();
    }

    @Deprecated
    public boolean isChildCheck() {
        return !this.getSelectItems().isEmpty();
    }

    @Override
    public boolean onInterceptClick(TreeItem child) {
        this.addSelectItem(child);
        return super.onInterceptClick(child);
    }

    protected void addSelectItem(@NonNull TreeItem child) {
        if (this.selectFlag() == SelectFlag.SINGLE_CHOICE) {
            if (this.getSelectItems().size() != 0) {
                this.getSelectItems().set(0, child);
            } else {
                this.getSelectItems().add(child);
            }
        } else {
            int index = this.getSelectItems().indexOf(child);
            if (index == -1) {
                this.getSelectItems().add(child);
            } else {
                this.getSelectItems().remove(index);
            }
        }
    }

    public SelectFlag selectFlag() {
        return SelectFlag.MULTIPLE_CHOICE;
    }

    public static enum SelectFlag {
        SINGLE_CHOICE,
        MULTIPLE_CHOICE;

    }
}

