/*
 * Decompiled with CFR 0.152.
 */
package com.baozi.treerecyclerview.item;

import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import com.baozi.treerecyclerview.adpater.TreeRecyclerType;
import com.baozi.treerecyclerview.factory.ItemHelperFactory;
import com.baozi.treerecyclerview.item.TreeItem;
import com.baozi.treerecyclerview.manager.ItemManager;
import java.util.List;

public abstract class TreeItemGroup<D>
extends TreeItem<D> {
    private List<TreeItem> child;
    private boolean isExpand;

    public boolean isExpand() {
        return this.isExpand;
    }

    public final void setExpand(boolean expand) {
        if (!this.isCanExpand()) {
            return;
        }
        this.isExpand = expand;
        if (expand) {
            this.onExpand();
        } else {
            this.onCollapse();
        }
    }

    @Deprecated
    public void notifyExpand() {
        this.setExpand(this.isExpand);
    }

    protected void onExpand() {
        ItemManager itemManager = this.getItemManager();
        if (itemManager == null) {
            return;
        }
        List<TreeItem> expandChild = this.getExpandChild();
        if (expandChild.size() == 0) {
            return;
        }
        int itemPosition = itemManager.getItemPosition(this);
        itemManager.addItems(itemPosition + 1, expandChild);
    }

    protected void onCollapse() {
        ItemManager itemManager = this.getItemManager();
        if (itemManager == null) {
            return;
        }
        List<TreeItem> expandChild = this.getExpandChild();
        if (expandChild.size() == 0) {
            return;
        }
        itemManager.removeItems(this.getExpandChild());
    }

    public boolean isCanExpand() {
        return true;
    }

    @NonNull
    public List<TreeItem> getExpandChild() {
        return ItemHelperFactory.getChildItemsWithType(this, TreeRecyclerType.SHOW_EXPAND);
    }

    @Override
    public void setData(D data) {
        super.setData(data);
        this.child = this.initChildList(data);
    }

    public void setChild(List<TreeItem> child) {
        this.child = child;
    }

    @Nullable
    public List<TreeItem> getAllChilds() {
        return ItemHelperFactory.getChildItemsWithType(this, TreeRecyclerType.SHOW_ALL);
    }

    @Nullable
    public List<TreeItem> getChild() {
        return this.child;
    }

    public int getChildCount() {
        return this.child == null ? 0 : this.child.size();
    }

    @Nullable
    protected abstract List<TreeItem> initChildList(D var1);

    public boolean onInterceptClick(TreeItem child) {
        return false;
    }
}

