/*
 * Decompiled with CFR 0.152.
 */
package com.baozi.treerecyclerview.item;

import android.graphics.Rect;
import android.support.annotation.NonNull;
import android.support.v7.widget.RecyclerView;
import com.baozi.treerecyclerview.base.ViewHolder;
import com.baozi.treerecyclerview.item.TreeItem;

public class SimpleTreeItem
extends TreeItem {
    private int layout;
    private int spanSize;
    private Consumer<ViewHolder> treeClick;
    private Consumer<ViewHolder> treeBind;
    private Rect treeRect;

    public SimpleTreeItem() {
        this(0, 0);
    }

    public SimpleTreeItem(int layout) {
        this(layout, 0);
    }

    public SimpleTreeItem(int layout, int spanSize) {
        this.layout = layout;
        this.spanSize = spanSize;
    }

    @Override
    public int getLayoutId() {
        return this.layout;
    }

    @Override
    public void onBindViewHolder(@NonNull ViewHolder viewHolder) {
        if (this.treeBind != null) {
            this.treeBind.accept(viewHolder);
        }
    }

    @Override
    public void onClick(ViewHolder viewHolder) {
        if (this.treeClick != null) {
            this.treeClick.accept(viewHolder);
        }
    }

    @Override
    public void getItemOffsets(@NonNull Rect outRect, RecyclerView.LayoutParams layoutParams, int position) {
        if (this.treeRect != null) {
            outRect.set(this.treeRect);
        }
    }

    @Override
    public int getSpanSize(int maxSpan) {
        return this.spanSize == 0 ? this.spanSize : maxSpan / this.spanSize;
    }

    public SimpleTreeItem setTreeClick(Consumer<ViewHolder> treeClick) {
        this.treeClick = treeClick;
        return this;
    }

    public SimpleTreeItem setTreeBind(Consumer<ViewHolder> treeOnBind) {
        this.treeBind = treeOnBind;
        return this;
    }

    public SimpleTreeItem setTreeOffset(Rect outRect) {
        this.treeRect = outRect;
        return this;
    }

    public static interface Consumer<T> {
        public void accept(T var1);
    }
}

