/*
 * Decompiled with CFR 0.152.
 */
package com.baozi.treerecyclerview.factory;

import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import com.baozi.treerecyclerview.adpater.TreeRecyclerType;
import com.baozi.treerecyclerview.annotation.TreeDataType;
import com.baozi.treerecyclerview.base.BaseItemData;
import com.baozi.treerecyclerview.factory.ItemConfig;
import com.baozi.treerecyclerview.item.TreeItem;
import com.baozi.treerecyclerview.item.TreeItemGroup;
import com.baozi.treerecyclerview.item.TreeSortItem;
import java.util.ArrayList;
import java.util.List;

public class ItemHelperFactory {
    public static List<TreeItem> createItems(@Nullable List list, @Nullable TreeItemGroup treeParentItem) {
        return ItemHelperFactory.createItems(list, null, treeParentItem);
    }

    public static List<TreeItem> createItems(@Nullable List list, Class<? extends TreeItem> iClass, @Nullable TreeItemGroup treeParentItem) {
        if (null == list) {
            return null;
        }
        int size = list.size();
        ArrayList<TreeItem> treeItemList = new ArrayList<TreeItem>();
        for (int i = 0; i < size; ++i) {
            Object itemData = list.get(i);
            TreeItem treeItem = ItemHelperFactory.createTreeItem(itemData, iClass, treeParentItem);
            if (treeItem == null) continue;
            treeItemList.add(treeItem);
        }
        return treeItemList;
    }

    @Deprecated
    public static List<TreeItem> createTreeItemList(@Nullable List list, Class<? extends TreeItem> iClass) {
        return ItemHelperFactory.createItems(list, iClass, null);
    }

    @Deprecated
    public static List<TreeItem> createTreeItemList(@Nullable List list, Class<? extends TreeItem> iClass, @Nullable TreeItemGroup treeParentItem) {
        return ItemHelperFactory.createItems(list, iClass, treeParentItem);
    }

    public static TreeItem createTreeItem(Object d) {
        return ItemHelperFactory.createTreeItem(d, null);
    }

    @Nullable
    public static TreeItem createTreeItem(Object data, @Nullable TreeItemGroup treeParentItem) {
        return ItemHelperFactory.createTreeItem(data, null, treeParentItem);
    }

    @Nullable
    public static TreeItem createTreeItem(Object data, @Nullable Class zClass, @Nullable TreeItemGroup treeParentItem) {
        TreeItem treeItem = null;
        try {
            Class<? extends TreeItem> treeItemClass = zClass != null ? zClass : ItemHelperFactory.getTypeClass(data);
            if (treeItemClass != null) {
                treeItem = treeItemClass.newInstance();
                treeItem.setData(data);
                treeItem.setParentItem(treeParentItem);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return treeItem;
    }

    private static Class<? extends TreeItem> getTypeClass(Object itemData) {
        Class treeItemClass = null;
        if (itemData instanceof BaseItemData) {
            int viewItemType = ((BaseItemData)itemData).getViewItemType();
            treeItemClass = ItemConfig.getTreeViewHolderType(viewItemType);
        } else {
            TreeDataType annotation = itemData.getClass().getAnnotation(TreeDataType.class);
            if (annotation != null) {
                treeItemClass = annotation.iClass();
            }
        }
        return treeItemClass;
    }

    @Deprecated
    public static List<TreeItem> createTreeSortList(@Nullable List list, Class<? extends TreeSortItem> iClass, Object sortKey, @Nullable TreeItemGroup treeParentItem) {
        if (null == list) {
            return null;
        }
        int size = list.size();
        ArrayList<TreeItem> treeItemList = new ArrayList<TreeItem>();
        for (int i = 0; i < size; ++i) {
            try {
                Object itemData = list.get(i);
                if (iClass == null) continue;
                TreeSortItem sortItem = iClass.newInstance();
                sortItem.setData(itemData);
                sortItem.setSortKey(sortKey);
                sortItem.setParentItem(treeParentItem);
                treeItemList.add(sortItem);
                continue;
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return treeItemList;
    }

    @Deprecated
    public static List<TreeItem> createTreeSortList(@Nullable List list, Object sortKey, @Nullable TreeItemGroup treeParentItem) {
        if (null == list) {
            return null;
        }
        ArrayList<TreeItem> treeItemList = new ArrayList<TreeItem>();
        int size = list.size();
        for (int i = 0; i < size; ++i) {
            try {
                Object itemData = list.get(i);
                Class<? extends TreeItem> iClass = ItemHelperFactory.getTypeClass(itemData);
                if (iClass == null || iClass != TreeSortItem.class) continue;
                TreeSortItem sortItem = (TreeSortItem)iClass.newInstance();
                sortItem.setData(itemData);
                sortItem.setSortKey(sortKey);
                sortItem.setParentItem(treeParentItem);
                treeItemList.add(sortItem);
                continue;
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return treeItemList;
    }

    @NonNull
    public static ArrayList<TreeItem> getChildItemsWithType(@Nullable TreeItemGroup itemGroup, @NonNull TreeRecyclerType type) {
        if (itemGroup == null) {
            return new ArrayList<TreeItem>();
        }
        return ItemHelperFactory.getChildItemsWithType(itemGroup.getChild(), type);
    }

    @NonNull
    public static ArrayList<TreeItem> getChildItemsWithType(@Nullable List<TreeItem> items, @NonNull TreeRecyclerType type) {
        ArrayList<TreeItem> returnItems = new ArrayList<TreeItem>();
        if (items == null) {
            return returnItems;
        }
        int childCount = items.size();
        for (int i = 0; i < childCount; ++i) {
            TreeItem childItem = items.get(i);
            returnItems.add(childItem);
            if (!(childItem instanceof TreeItemGroup)) continue;
            ArrayList<TreeItem> list = null;
            switch (type) {
                case SHOW_ALL: {
                    list = ItemHelperFactory.getChildItemsWithType((TreeItemGroup)childItem, type);
                    break;
                }
                case SHOW_EXPAND: {
                    if (!((TreeItemGroup)childItem).isExpand()) break;
                    list = ItemHelperFactory.getChildItemsWithType((TreeItemGroup)childItem, type);
                }
            }
            if (list == null || list.size() <= 0) continue;
            returnItems.addAll(list);
        }
        return returnItems;
    }
}

