/*
 * Decompiled with CFR 0.152.
 */
package com.github.jikoo.regionerator.world.impl;

import com.github.jikoo.regionerator.DebugLevel;
import com.github.jikoo.regionerator.world.ChunkInfo;
import com.github.jikoo.regionerator.world.RegionInfo;
import com.github.jikoo.regionerator.world.impl.AnvilWorld;
import java.io.File;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.nio.file.Files;
import java.util.Arrays;
import org.jetbrains.annotations.NotNull;

public class AnvilRegion
extends RegionInfo {
    private final File regionFile;
    private byte[] header;

    AnvilRegion(@NotNull AnvilWorld world, @NotNull File regionFile, int lowestChunkX, int lowestChunkZ) {
        super(world, lowestChunkX, lowestChunkZ);
        this.regionFile = regionFile;
    }

    public File getRegionFile() {
        return this.regionFile;
    }

    @Override
    public void read() throws IOException {
        if (this.header == null) {
            this.header = new byte[8192];
        }
        if (!this.getRegionFile().exists()) {
            Arrays.fill(this.header, (byte)0);
            return;
        }
        try (RandomAccessFile regionRandomAccess = new RandomAccessFile(this.getRegionFile(), "r");){
            regionRandomAccess.read(this.header);
        }
    }

    @Override
    public boolean write() throws IOException {
        if (!this.getRegionFile().exists()) {
            return false;
        }
        if (!(this.getRegionFile().canWrite() || this.getRegionFile().setWritable(true) || this.getRegionFile().canWrite())) {
            throw new IOException("Unable to set " + this.getRegionFile().getName() + " writable");
        }
        for (int i = 0; i < 4096; ++i) {
            if (this.header[i] == 0) continue;
            try (RandomAccessFile regionRandomAccess = new RandomAccessFile(this.getRegionFile(), "rwd");){
                regionRandomAccess.write(this.header, 0, 4096);
            }
            this.getPlugin().debug(DebugLevel.HIGH, () -> String.format("Rewrote header of region %s", this.getIdentifier()));
            return true;
        }
        Files.deleteIfExists(this.getRegionFile().toPath());
        this.getPlugin().debug(DebugLevel.HIGH, () -> String.format("Deleted region %s with empty header", this.getIdentifier()));
        return true;
    }

    @Override
    @NotNull
    public AnvilWorld getWorldInfo() {
        return (AnvilWorld)super.getWorldInfo();
    }

    @Override
    public boolean exists() {
        return this.getRegionFile().exists();
    }

    @Override
    @NotNull
    protected ChunkInfo getChunkInternal(int localChunkX, int localChunkZ) {
        return new AnvilChunk(localChunkX, localChunkZ);
    }

    private class AnvilChunk
    extends ChunkInfo {
        public AnvilChunk(int localChunkX, int localChunkZ) {
            super(AnvilRegion.this, localChunkX, localChunkZ);
        }

        @Override
        public boolean isOrphaned() {
            boolean orphaned = true;
            int index = 4 * (this.getLocalChunkX() + this.getLocalChunkZ() * 32);
            for (int i = 0; i < 4; ++i) {
                if (AnvilRegion.this.header[index + i] == 0) continue;
                orphaned = false;
                break;
            }
            return orphaned;
        }

        @Override
        public void setOrphaned() {
            int index = 4 * (this.getLocalChunkX() + this.getLocalChunkZ() * 32);
            for (int i = 0; i < 4; ++i) {
                ((AnvilRegion)AnvilRegion.this).header[index + i] = 0;
            }
        }

        @Override
        public long getLastModified() {
            int index = 4096 + 4 * (this.getLocalChunkX() + this.getLocalChunkZ() * 32);
            return 1000L * (long)(AnvilRegion.this.header[index] << 24 | (AnvilRegion.this.header[index + 1] & 0xFF) << 16 | (AnvilRegion.this.header[index + 2] & 0xFF) << 8 | AnvilRegion.this.header[index + 3] & 0xFF);
        }
    }
}

