/*
 * Decompiled with CFR 0.152.
 */
package com.github.jikoo.regionerator.world;

import com.github.jikoo.regionerator.Coords;
import com.github.jikoo.regionerator.Regionerator;
import com.github.jikoo.regionerator.world.ChunkInfo;
import com.github.jikoo.regionerator.world.WorldInfo;
import com.google.common.base.Preconditions;
import java.io.IOException;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.stream.Stream;
import org.bukkit.World;
import org.jetbrains.annotations.NotNull;

public abstract class RegionInfo {
    private final WorldInfo world;
    private final int lowestChunkX;
    private final int lowestChunkZ;

    protected RegionInfo(@NotNull WorldInfo world, int lowestChunkX, int lowestChunkZ) {
        this.world = world;
        this.lowestChunkX = lowestChunkX;
        this.lowestChunkZ = lowestChunkZ;
    }

    public abstract void read() throws IOException;

    public abstract boolean write() throws IOException;

    @NotNull
    public WorldInfo getWorldInfo() {
        return this.world;
    }

    @NotNull
    public World getWorld() {
        return this.world.getWorld();
    }

    public abstract boolean exists();

    public int getLowestChunkX() {
        return this.lowestChunkX;
    }

    public int getLowestChunkZ() {
        return this.lowestChunkZ;
    }

    @NotNull
    public String getIdentifier() {
        return Coords.chunkToRegion(this.getLowestChunkX()) + "_" + Coords.chunkToRegion(this.getLowestChunkZ());
    }

    @NotNull
    public ChunkInfo getChunk(int chunkX, int chunkZ) {
        return this.getLocalChunk(chunkX - this.lowestChunkX, chunkZ - this.lowestChunkZ);
    }

    @NotNull
    public ChunkInfo getLocalChunk(int localChunkX, int localChunkZ) {
        Preconditions.checkArgument((localChunkX >= 0 && localChunkX < 32 && localChunkZ >= 0 && localChunkZ < 32 ? 1 : 0) != 0, (String)"Local chunk coords must be within range 0-31! Received values X: %s, Z: %s", (int)localChunkX, (int)localChunkZ);
        return this.getChunkInternal(localChunkX, localChunkZ);
    }

    @NotNull
    protected abstract ChunkInfo getChunkInternal(int var1, int var2);

    public Stream<ChunkInfo> getChunks() {
        AtomicInteger index = new AtomicInteger();
        return Stream.generate(() -> {
            int localIndex = index.getAndIncrement();
            int localChunkX = localIndex % 32;
            int localChunkZ = localIndex / 32;
            return this.getLocalChunk(localChunkX, localChunkZ);
        }).limit(1024L);
    }

    protected Regionerator getPlugin() {
        return this.getWorldInfo().getPlugin();
    }
}

