/*
 * Decompiled with CFR 0.152.
 */
package com.github.jikoo.regionerator.util.yaml;

import com.github.jikoo.regionerator.Regionerator;
import com.github.jikoo.regionerator.util.yaml.FileYamlData;
import java.io.File;
import java.util.List;
import org.bukkit.configuration.ConfigurationSection;
import org.bukkit.plugin.Plugin;
import org.jetbrains.annotations.NotNull;

public class MiscData
extends FileYamlData {
    private final Regionerator plugin;

    public MiscData(@NotNull Regionerator plugin, @NotNull File file) {
        super((Plugin)plugin, file);
        this.plugin = plugin;
    }

    @Override
    public void reload() {
        super.reload();
        this.checkWorldValidity();
    }

    public void checkWorldValidity() {
        if (this.plugin == null || this.plugin.config() == null) {
            return;
        }
        ConfigurationSection worlds = this.raw().getConfigurationSection("next-cycle");
        if (worlds == null) {
            return;
        }
        List<String> enabledWorlds = this.plugin.config().getStringList("worlds");
        for (String worldName : worlds.getKeys(false)) {
            if (enabledWorlds.contains(worldName)) continue;
            if (!enabledWorlds.stream().noneMatch(worldName::equalsIgnoreCase)) continue;
            this.set("next-cycle." + worldName, null);
        }
    }

    public void setNextCycle(@NotNull String worldName, long timestamp) {
        this.set("next-cycle." + worldName, timestamp);
    }

    public long getNextCycle(@NotNull String worldName) {
        long nextCycle = this.getLong("next-cycle." + worldName);
        if (nextCycle == 0L) {
            nextCycle = this.plugin.config().getFlagVisit();
            this.setNextCycle(worldName, nextCycle);
        }
        return nextCycle;
    }
}

