/*
 * Decompiled with CFR 0.152.
 */
package com.github.jikoo.regionerator.util;

import com.github.jikoo.regionerator.ChunkFlagger;
import com.github.jikoo.regionerator.DebugLevel;
import com.github.jikoo.regionerator.Regionerator;
import com.github.jikoo.regionerator.VisitStatus;
import com.github.jikoo.regionerator.hooks.Hook;
import com.github.jikoo.regionerator.util.SupplierCache;
import com.github.jikoo.regionerator.util.yaml.Config;
import com.github.jikoo.regionerator.world.ChunkInfo;
import com.github.jikoo.regionerator.world.WorldInfo;
import java.util.ArrayList;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeUnit;
import org.bukkit.Bukkit;
import org.bukkit.plugin.Plugin;

public class VisitStatusCache
extends SupplierCache<VisitStatus> {
    public VisitStatusCache(Regionerator plugin, ChunkInfo chunkInfo) {
        super(() -> {
            boolean isFresh;
            if (chunkInfo.isOrphaned()) {
                return VisitStatus.ORPHANED;
            }
            long now = System.currentTimeMillis();
            ChunkFlagger.FlagData flagData = plugin.getFlagger().getChunkFlag(chunkInfo.getWorld(), chunkInfo.getChunkX(), chunkInfo.getChunkZ()).join();
            long lastVisit = flagData.getLastVisit();
            boolean bl = isFresh = !plugin.config().isDeleteFreshChunks() && lastVisit == plugin.config().getFlagGenerated();
            if (!isFresh && now <= lastVisit) {
                plugin.debug(DebugLevel.HIGH, () -> String.format("Chunk %s is visited until %s", flagData.getChunkId(), lastVisit));
                if (lastVisit == 0x7FFFFFFFFFFFFFFEL) {
                    return VisitStatus.PERMANENTLY_FLAGGED;
                }
                if (lastVisit == 0x7FFFFFFFFFFFFFFDL) {
                    return VisitStatus.UNKNOWN;
                }
                return VisitStatus.VISITED;
            }
            if (!isFresh && now - plugin.config().getFlagDuration() <= chunkInfo.getLastModified()) {
                plugin.debug(DebugLevel.HIGH, () -> String.format("Chunk %s is modified until %s", flagData.getChunkId(), lastVisit));
                return VisitStatus.VISITED;
            }
            ArrayList<Hook> syncHooks = Bukkit.isPrimaryThread() ? null : new ArrayList<Hook>();
            WorldInfo world = chunkInfo.getRegionInfo().getWorldInfo();
            int chunkX = chunkInfo.getChunkX();
            int chunkZ = chunkInfo.getChunkZ();
            for (Hook hook : plugin.getProtectionHooks()) {
                if (syncHooks != null && !hook.isAsyncCapable()) {
                    syncHooks.add(hook);
                    continue;
                }
                if (!hook.isChunkProtected(world.getWorld(), chunkX, chunkZ)) continue;
                plugin.debug(DebugLevel.HIGH, () -> String.format("Chunk %s contains protections by %s", flagData.getChunkId(), hook.getProtectionName()));
                return VisitStatus.PROTECTED;
            }
            if (syncHooks != null && !syncHooks.isEmpty()) {
                if (!plugin.isEnabled()) {
                    return VisitStatus.UNKNOWN;
                }
                try {
                    VisitStatus visitStatus = (VisitStatus)((Object)((Object)Bukkit.getScheduler().callSyncMethod((Plugin)plugin, () -> {
                        for (Hook hook : syncHooks) {
                            if (!hook.isChunkProtected(world.getWorld(), chunkX, chunkZ)) continue;
                            plugin.debug(DebugLevel.HIGH, () -> String.format("Chunk %s contains protections by %s", flagData.getChunkId(), hook.getProtectionName()));
                            return VisitStatus.PROTECTED;
                        }
                        return VisitStatus.UNKNOWN;
                    }).get()));
                    if (visitStatus == VisitStatus.PROTECTED) {
                        return VisitStatus.PROTECTED;
                    }
                }
                catch (InterruptedException | ExecutionException e) {
                    throw new RuntimeException(e);
                }
            }
            if (isFresh) {
                plugin.debug(DebugLevel.HIGH, () -> "Chunk " + flagData.getChunkId() + " has not been visited since it was generated.");
                return VisitStatus.GENERATED;
            }
            return VisitStatus.UNVISITED;
        }, VisitStatusCache.calcCacheDuration(plugin), TimeUnit.MINUTES);
    }

    private static int calcCacheDuration(Regionerator plugin) {
        Config config = plugin.config();
        return (int)Math.ceil(1024.0 / (double)config.getDeletionChunkCount() * (double)config.getDeletionRecoveryMillis() / 60000.0);
    }
}

