/*
 * Decompiled with CFR 0.152.
 */
package com.github.jikoo.regionerator.hooks;

import com.github.jikoo.regionerator.Coords;
import com.github.jikoo.regionerator.hooks.PluginHook;
import com.palmergames.bukkit.towny.TownySettings;
import com.palmergames.bukkit.towny.object.Coord;
import com.palmergames.bukkit.towny.object.WorldCoord;
import org.bukkit.World;

public class TownyHook
extends PluginHook {
    public TownyHook() {
        super("Towny");
    }

    @Override
    public boolean isChunkProtected(World chunkWorld, int chunkX, int chunkZ) {
        int minX = Coords.chunkToBlock(chunkX);
        int maxX = minX + 15;
        int minZ = Coords.chunkToBlock(chunkZ);
        int maxZ = minZ + 15;
        Coord lowCoord = Coord.parseCoord((int)minX, (int)minZ);
        Coord highCoord = Coord.parseCoord((int)maxX, (int)maxZ);
        int cellSize = TownySettings.getTownBlockSize();
        for (int x = lowCoord.getX(); x <= highCoord.getX(); x += cellSize) {
            for (int z = lowCoord.getZ(); z <= highCoord.getZ(); z += cellSize) {
                WorldCoord worldCoord = new WorldCoord(chunkWorld.getName(), x, z);
                try {
                    if (!worldCoord.getTownBlock().hasTown()) continue;
                    return true;
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        }
        return false;
    }
}

