/*
 * Decompiled with CFR 0.152.
 */
package com.github.jikoo.regionerator.hooks;

import br.net.fabiozumbi12.RedProtect.Bukkit.RedProtect;
import br.net.fabiozumbi12.RedProtect.Bukkit.Region;
import com.github.jikoo.regionerator.Coords;
import com.github.jikoo.regionerator.hooks.PluginHook;
import com.github.jikoo.regionerator.world.DummyChunk;
import org.bukkit.Chunk;
import org.bukkit.Location;
import org.bukkit.World;

public class RedProtectHook
extends PluginHook {
    private boolean needAPI = false;

    public RedProtectHook() {
        super("RedProtect");
    }

    @Override
    public boolean isHookUsable() {
        try {
            return super.isHookUsable();
        }
        catch (Exception | NoSuchFieldError | NoSuchMethodError e) {
            System.err.println("RedProtect fast hook failed usability! Falling back to slower API-based solution.");
            System.err.println("Please report this stack trace:");
            e.printStackTrace();
            this.needAPI = true;
            return super.isHookUsable();
        }
    }

    @Override
    public boolean isChunkProtected(World chunkWorld, int chunkX, int chunkZ) {
        if (this.needAPI) {
            return RedProtect.get().getAPI().getChunkRegions((Chunk)new DummyChunk(chunkWorld, chunkX, chunkZ)).size() > 0;
        }
        for (Region region : RedProtect.get().getRegionManager().getRegionsByWorld(chunkWorld.getName())) {
            Location min = region.getMinLocation();
            Location max = region.getMaxLocation();
            if (Coords.blockToChunk(min.getBlockX()) > chunkX || Coords.blockToChunk(max.getBlockX()) < chunkX || Coords.blockToChunk(min.getBlockZ()) > chunkZ || Coords.blockToChunk(max.getBlockZ()) < chunkZ) continue;
            return true;
        }
        return false;
    }
}

