/*
 * Decompiled with CFR 0.152.
 */
package com.github.jikoo.regionerator.hooks;

import com.github.jikoo.regionerator.hooks.PluginHook;
import com.github.jikoo.regionerator.util.function.ThrowingTriFunction;
import java.lang.reflect.Constructor;
import java.lang.reflect.Method;
import org.bukkit.World;

public class FactionsHook
extends PluginHook {
    private Method boardSingleton;
    private Method boardGetFaction;
    private Method factionIsWilderness;
    private ThrowingTriFunction<Object, String, Integer, Integer> getLocation;

    public FactionsHook() throws ReflectiveOperationException {
        super("Factions");
        try {
            Class<?> boardClazz = Class.forName("com.massivecraft.factions.Board");
            this.boardSingleton = boardClazz.getMethod("getInstance", new Class[0]);
            Class<?> factionLocationClazz = Class.forName("com.massivecraft.factions.FLocation");
            this.boardGetFaction = boardClazz.getMethod("getFactionAt", factionLocationClazz);
            Constructor<?> locationConstructor = factionLocationClazz.getConstructor(String.class, Integer.TYPE, Integer.TYPE);
            this.getLocation = (worldName, chunkX, chunkZ) -> locationConstructor.newInstance(worldName, chunkX, chunkZ);
            Class<?> factionClazz = Class.forName("com.massivecraft.factions.Faction");
            this.factionIsWilderness = factionClazz.getMethod("isWilderness", new Class[0]);
            return;
        }
        catch (ReflectiveOperationException boardClazz) {
            Class<?> massiveBoard = Class.forName("com.massivecraft.factions.entity.BoardColl");
            this.boardSingleton = massiveBoard.getDeclaredMethod("get", new Class[0]);
            Class<?> massivePS = Class.forName("com.massivecraft.massivecore.ps.PS");
            this.boardGetFaction = massiveBoard.getDeclaredMethod("getFactionAt", massivePS);
            Method locationValueOf = massivePS.getDeclaredMethod("valueOf", String.class, Integer.TYPE, Integer.TYPE);
            this.getLocation = (worldName, chunkX, chunkZ) -> locationValueOf.invoke(null, worldName, chunkX, chunkZ);
            Class<?> massiveFaction = Class.forName("com.massivecraft.factions.entity.Faction");
            this.factionIsWilderness = massiveFaction.getDeclaredMethod("isNone", new Class[0]);
            return;
        }
    }

    @Override
    public boolean isChunkProtected(World chunkWorld, int chunkX, int chunkZ) {
        try {
            Object faction = this.boardGetFaction.invoke(this.boardSingleton.invoke(null, new Object[0]), this.getLocation.apply(chunkWorld.getName(), chunkX, chunkZ));
            return faction != null && (Boolean)this.factionIsWilderness.invoke(faction, new Object[0]) == false;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }
}

