/*
 * Decompiled with CFR 0.152.
 */
package com.github.jikoo.regionerator.commands;

import com.github.jikoo.regionerator.Coords;
import com.github.jikoo.regionerator.DeletionRunnable;
import com.github.jikoo.regionerator.Regionerator;
import com.github.jikoo.regionerator.commands.FlagHandler;
import com.github.jikoo.regionerator.commands.TabCompleter;
import com.github.jikoo.regionerator.hooks.Hook;
import com.github.jikoo.regionerator.world.ChunkInfo;
import com.github.jikoo.regionerator.world.RegionInfo;
import java.io.IOException;
import java.text.SimpleDateFormat;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.logging.Level;
import java.util.stream.Stream;
import org.bukkit.Chunk;
import org.bukkit.command.Command;
import org.bukkit.command.CommandSender;
import org.bukkit.command.TabExecutor;
import org.bukkit.entity.Player;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class RegioneratorExecutor
implements TabExecutor {
    private final Regionerator plugin;
    private final Map<String, DeletionRunnable> deletionRunnables;
    private final FlagHandler flagHandler;

    public RegioneratorExecutor(Regionerator plugin, Map<String, DeletionRunnable> deletionRunnables) {
        this.plugin = plugin;
        this.deletionRunnables = deletionRunnables;
        this.flagHandler = new FlagHandler(plugin);
    }

    public boolean onCommand(@NotNull CommandSender sender, @NotNull Command command, @NotNull String label, String[] args) {
        this.plugin.attemptDeletionActivation();
        if (args.length < 1) {
            if (this.plugin.config().getWorlds().isEmpty()) {
                sender.sendMessage("No worlds are configured. Edit your config and use /regionerator reload.");
                return true;
            }
            SimpleDateFormat format = new SimpleDateFormat("HH:mm 'on' d MMM");
            long millisBetweenCycles = this.plugin.config().getMillisBetweenCycles();
            for (String worldName : this.plugin.config().getWorlds()) {
                long activeAt = this.plugin.getMiscData().getNextCycle(worldName);
                if (activeAt > System.currentTimeMillis()) {
                    String message = this.plugin.config().isRememberCycleDelay() && activeAt >= System.currentTimeMillis() - millisBetweenCycles ? worldName + ": Next run at " + format.format(new Date(activeAt)) : worldName + ": Gathering data, deletion starts " + format.format(new Date(activeAt));
                    sender.sendMessage(message);
                    continue;
                }
                if (this.deletionRunnables.containsKey(worldName)) {
                    DeletionRunnable runnable = this.deletionRunnables.get(worldName);
                    sender.sendMessage(runnable.getRunStats());
                    if (runnable.getNextRun() >= Long.MAX_VALUE) continue;
                    sender.sendMessage(" - Next run: " + format.format(runnable.getNextRun()));
                    continue;
                }
                sender.sendMessage("Cycle for " + worldName + " is ready to start.");
            }
            if (this.plugin.isPaused()) {
                sender.sendMessage("Regionerator is paused. Use \"/regionerator resume\" to continue.");
            }
            return true;
        }
        args[0] = args[0].toLowerCase();
        if (args[0].equals("reload")) {
            this.plugin.reloadConfig();
            this.plugin.reloadFeatures();
            sender.sendMessage("Regionerator configuration reloaded!");
            return true;
        }
        if (args[0].equals("pause") || args[0].equals("stop")) {
            this.plugin.setPaused(true);
            sender.sendMessage("Paused Regionerator. Use /regionerator resume to resume.");
            return true;
        }
        if (args[0].equals("resume") || args[0].equals("unpause") || args[0].equals("start")) {
            this.plugin.setPaused(false);
            sender.sendMessage("Resumed Regionerator. Use /regionerator pause to pause.");
            return true;
        }
        if (args[0].equals("flag")) {
            this.flagHandler.handleFlags(sender, args, true);
            return true;
        }
        if (args[0].equals("unflag")) {
            this.flagHandler.handleFlags(sender, args, false);
            return true;
        }
        if (args[0].equals("cache")) {
            sender.sendMessage("Cached chunk values: " + this.plugin.getFlagger().getCached());
            sender.sendMessage("Queued saves: " + this.plugin.getFlagger().getQueued());
            return true;
        }
        if (sender instanceof Player && args[0].equals("check")) {
            Player player = (Player)sender;
            if (!this.plugin.config().getWorlds().contains(player.getWorld().getName())) {
                player.sendMessage("World is not configured for deletion.");
            }
            Chunk chunk = player.getLocation().getChunk();
            for (Hook hook : this.plugin.getProtectionHooks()) {
                player.sendMessage("Chunk is " + (hook.isChunkProtected(chunk.getWorld(), chunk.getX(), chunk.getZ()) ? "" : "not ") + "protected by " + hook.getProtectionName());
            }
            SimpleDateFormat format = new SimpleDateFormat("HH:mm 'on' d MMM yyyy");
            RegionInfo regionInfo = this.plugin.getWorldManager().getWorld(player.getWorld()).getRegion(Coords.chunkToRegion(chunk.getX()), Coords.chunkToRegion(chunk.getZ()));
            try {
                regionInfo.read();
            }
            catch (IOException e) {
                player.sendMessage("Caught IOException reading region data. Please check console!");
                this.plugin.getLogger().log(Level.WARNING, "Unable to read region!", e);
            }
            if (!regionInfo.exists()) {
                long visit = this.plugin.getFlagger().getChunkFlag(chunk.getWorld(), chunk.getX(), chunk.getZ()).join().getLastVisit();
                if (visit == -1L) {
                    player.sendMessage("Chunk has not been visited.");
                } else if (!this.plugin.config().isDeleteFreshChunks() && visit == this.plugin.config().getFlagGenerated()) {
                    player.sendMessage("Chunk has not been visited since generation.");
                } else if (visit == 0x7FFFFFFFFFFFFFFEL) {
                    player.sendMessage("Chunk is eternally flagged.");
                } else {
                    player.sendMessage("Chunk visited until: " + format.format(new Date(visit)));
                }
                visit = this.plugin.getFlagger().getChunkFlagOnDelete(chunk.getWorld(), chunk.getX(), chunk.getZ()).join().getLastVisit();
                if (visit != -1L) {
                    player.sendMessage("Visited (last delete): " + format.format(new Date(visit)));
                }
                player.sendMessage("Region not available from disk! Cannot check details.");
                return true;
            }
            ChunkInfo chunkInfo = regionInfo.getChunk(chunk.getX(), chunk.getZ());
            player.sendMessage("Chunk visited until: " + format.format(new Date(chunkInfo.getLastVisit())));
            player.sendMessage("Chunk last modified: " + format.format(new Date(chunkInfo.getLastModified())));
            player.sendMessage("Chunk VisitStatus: " + chunkInfo.getVisitStatus().name());
            long visit = this.plugin.getFlagger().getChunkFlagOnDelete(chunk.getWorld(), chunk.getX(), chunk.getZ()).join().getLastVisit();
            if (visit != -1L) {
                player.sendMessage("Visited (last delete): " + format.format(new Date(visit)));
            }
            if (chunkInfo.isOrphaned()) {
                player.sendMessage("Chunk is marked as orphaned. VisitStatus should be GENERATED or UNKNOWN.");
            }
            return true;
        }
        return false;
    }

    @Nullable
    public List<String> onTabComplete(@NotNull CommandSender sender, @NotNull Command command, @NotNull String label, @NotNull String[] args) {
        if (!sender.hasPermission("regionerator.command") || args.length < 1) {
            return Collections.emptyList();
        }
        if (args.length == 1) {
            String[] stringArray;
            if (sender instanceof Player) {
                String[] stringArray2 = new String[7];
                stringArray2[0] = "pause";
                stringArray2[1] = "resume";
                stringArray2[2] = "reload";
                stringArray2[3] = "flag";
                stringArray2[4] = "unflag";
                stringArray2[5] = "cache";
                stringArray = stringArray2;
                stringArray2[6] = "check";
            } else {
                String[] stringArray3 = new String[6];
                stringArray3[0] = "pause";
                stringArray3[1] = "resume";
                stringArray3[2] = "reload";
                stringArray3[3] = "flag";
                stringArray3[4] = "unflag";
                stringArray = stringArray3;
                stringArray3[5] = "cache";
            }
            String[] completions = stringArray;
            return TabCompleter.completeString(args[0], completions);
        }
        args[0] = args[0].toLowerCase(Locale.ENGLISH);
        if ("flag".equals(args[0]) || "unflag".equals(args[0])) {
            if (args.length == 2) {
                return TabCompleter.completeString(args[1], (String[])Stream.concat(Stream.of("selection"), this.plugin.config().getWorlds().stream()).toArray(String[]::new));
            }
            if (!"selection".equalsIgnoreCase(args[1]) && args.length <= 4) {
                return TabCompleter.completeInteger(args[args.length - 1]);
            }
        }
        return Collections.emptyList();
    }
}

