/*
 * Decompiled with CFR 0.152.
 */
package com.github.jikoo.regionerator;

import com.github.jikoo.regionerator.ChunkFlagger;
import com.github.jikoo.regionerator.DebugLevel;
import com.github.jikoo.regionerator.DeletionRunnable;
import com.github.jikoo.regionerator.FlaggingRunnable;
import com.github.jikoo.regionerator.WorldManager;
import com.github.jikoo.regionerator.commands.RegioneratorExecutor;
import com.github.jikoo.regionerator.hooks.Hook;
import com.github.jikoo.regionerator.hooks.PluginHook;
import com.github.jikoo.regionerator.listeners.DebugListener;
import com.github.jikoo.regionerator.listeners.FlaggingListener;
import com.github.jikoo.regionerator.listeners.HookListener;
import com.github.jikoo.regionerator.util.yaml.Config;
import com.github.jikoo.regionerator.util.yaml.MiscData;
import java.io.File;
import java.util.Collections;
import java.util.Iterator;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.Phaser;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.function.Consumer;
import java.util.function.Supplier;
import java.util.logging.Level;
import org.bukkit.Bukkit;
import org.bukkit.World;
import org.bukkit.command.Command;
import org.bukkit.command.CommandExecutor;
import org.bukkit.command.CommandSender;
import org.bukkit.command.PluginCommand;
import org.bukkit.configuration.ConfigurationSection;
import org.bukkit.event.HandlerList;
import org.bukkit.event.Listener;
import org.bukkit.plugin.Plugin;
import org.bukkit.plugin.java.JavaPlugin;
import org.bukkit.scheduler.BukkitRunnable;
import org.bukkit.scheduler.BukkitTask;

public class Regionerator
extends JavaPlugin {
    private final Map<String, DeletionRunnable> deletionRunnables = new ConcurrentHashMap<String, DeletionRunnable>();
    private final Set<Hook> protectionHooks = Collections.newSetFromMap(new ConcurrentHashMap());
    private final WorldManager worldManager = new WorldManager(this);
    private final AtomicBoolean paused = new AtomicBoolean();
    private ChunkFlagger chunkFlagger;
    private Config config;
    private MiscData miscData;
    private BukkitTask flagging;
    private DebugListener debugListener;

    public void onEnable() {
        this.saveDefaultConfig();
        this.config = new Config((Plugin)this);
        this.miscData = new MiscData(this, new File(this.getDataFolder(), "data.yml"));
        boolean migrated = false;
        for (String worldName : this.config.getWorlds()) {
            if (!this.getConfig().isLong("delete-this-to-reset-plugin." + worldName)) continue;
            this.miscData.setNextCycle(worldName, this.getConfig().getLong("delete-this-to-reset-plugin." + worldName));
            migrated = true;
        }
        if (migrated) {
            this.getConfig().set("delete-this-to-reset-plugin", null);
            this.saveConfig();
        }
        this.miscData.checkWorldValidity();
        this.chunkFlagger = new ChunkFlagger(this);
        this.debugListener = new DebugListener(this);
        PluginCommand command = this.getCommand("regionerator");
        RegioneratorExecutor executor = new RegioneratorExecutor(this, this.deletionRunnables);
        if (command != null) {
            command.setExecutor((CommandExecutor)executor);
        }
        if (this.config.getWorlds().isEmpty()) {
            this.getLogger().severe("No worlds are enabled. There's nothing to do!");
            return;
        }
        this.reloadFeatures();
        this.debug(DebugLevel.LOW, () -> executor.onCommand((CommandSender)Bukkit.getConsoleSender(), (Command)Objects.requireNonNull(command), "regionerator", new String[0]));
    }

    public void onDisable() {
        this.deletionRunnables.values().forEach(BukkitRunnable::cancel);
        this.deletionRunnables.clear();
        this.getServer().getScheduler().cancelTasks((Plugin)this);
        if (this.chunkFlagger != null) {
            this.getLogger().info("Shutting down flagger - currently holds " + this.chunkFlagger.getCached() + " flags.");
            this.chunkFlagger.shutdown();
        }
        this.protectionHooks.clear();
    }

    public void reloadConfig() {
        super.reloadConfig();
        if (this.config != null) {
            this.config.reload();
        }
        if (this.miscData != null) {
            this.miscData.reload();
        }
    }

    public void reloadFeatures() {
        HandlerList.unregisterAll((Plugin)this);
        if (this.flagging != null) {
            this.flagging.cancel();
        }
        this.protectionHooks.clear();
        this.getServer().getPluginManager().registerEvents((Listener)new HookListener(this), (Plugin)this);
        Set hookNames = Objects.requireNonNull(Objects.requireNonNull(this.getConfig().getDefaults()).getConfigurationSection("hooks")).getKeys(false);
        ConfigurationSection hookSection = this.getConfig().getConfigurationSection("hooks");
        if (hookSection != null) {
            hookNames.addAll(hookSection.getKeys(false));
        }
        for (String hookName : hookNames) {
            Class<?> clazz;
            if (!this.getConfig().getBoolean("hooks." + hookName, true)) continue;
            try {
                clazz = Class.forName("com.github.jikoo.regionerator.hooks." + hookName + "Hook");
                if (!Hook.class.isAssignableFrom(clazz)) {
                }
            }
            catch (ClassNotFoundException e) {}
            continue;
            try {
                Hook hook = (Hook)clazz.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
                if (!hook.areDependenciesPresent()) {
                    this.debug(DebugLevel.LOW, () -> String.format("Dependencies not found for %s hook, skipping.", hookName));
                    continue;
                }
                if (hook.isHookUsable()) {
                    this.protectionHooks.add(hook);
                    this.debug(DebugLevel.LOW, () -> "Enabled protection hook for " + hookName);
                    continue;
                }
                this.getLogger().warning("Protection hook for " + hookName + " failed usability check! Deletion is paused.");
                this.setPaused(true);
            }
            catch (ReflectiveOperationException e) {
                this.getLogger().log(Level.SEVERE, "Unable to enable hook for " + hookName + "! Deletion is paused.", e);
                this.setPaused(true);
            }
            catch (NoClassDefFoundError e) {
                this.debug(() -> String.format("Dependencies not found for %s hook, skipping.", hookName), e);
            }
        }
        if (this.config.getFlagDuration() > 0L) {
            this.getServer().getPluginManager().registerEvents((Listener)new FlaggingListener(this), (Plugin)this);
            this.flagging = new FlaggingRunnable(this).runTaskTimer((Plugin)this, 0L, this.config.getFlaggingInterval());
        } else {
            this.flagging = new BukkitRunnable(){

                public void run() {
                    Regionerator.this.attemptDeletionActivation();
                }
            }.runTaskTimer((Plugin)this, 0L, 1200L);
        }
        if (this.debug(DebugLevel.HIGH)) {
            this.getServer().getPluginManager().registerEvents((Listener)this.debugListener, (Plugin)this);
        }
    }

    public Config config() {
        return this.config;
    }

    public MiscData getMiscData() {
        return this.miscData;
    }

    public WorldManager getWorldManager() {
        return this.worldManager;
    }

    void finishCycle(DeletionRunnable runnable) {
        this.miscData.setNextCycle(runnable.getWorld(), runnable.getNextRun());
    }

    public void attemptDeletionActivation() {
        this.deletionRunnables.values().removeIf(value -> value.getNextRun() < System.currentTimeMillis());
        if (this.isPaused()) {
            return;
        }
        for (String worldName : this.config.getWorlds()) {
            if (this.miscData.getNextCycle(worldName) > System.currentTimeMillis()) continue;
            DeletionRunnable runnable = this.deletionRunnables.get(worldName);
            if (runnable != null) {
                if (runnable.getNextRun() != Long.MAX_VALUE) continue;
                return;
            }
            World world = Bukkit.getWorld((String)worldName);
            if (world == null) continue;
            try {
                runnable = new DeletionRunnable(this, world);
            }
            catch (RuntimeException e) {
                this.debug(DebugLevel.HIGH, e::getMessage);
                continue;
            }
            runnable.runTaskAsynchronously((Plugin)this);
            this.deletionRunnables.put(worldName, runnable);
            this.debug(DebugLevel.LOW, () -> "Deletion run scheduled for " + world.getName());
            return;
        }
    }

    public Set<Hook> getProtectionHooks() {
        return Collections.unmodifiableSet(this.protectionHooks);
    }

    public void addHook(PluginHook hook) {
        if (hook == null) {
            throw new IllegalArgumentException("Hook cannot be null");
        }
        for (Hook enabledHook : this.protectionHooks) {
            if (!enabledHook.getClass().equals(hook.getClass())) continue;
            throw new IllegalStateException(String.format("Hook %s is already enabled", hook.getProtectionName()));
        }
        if (!hook.isHookUsable()) {
            throw new IllegalStateException(String.format("Hook %s is not usable", hook.getProtectionName()));
        }
        this.protectionHooks.add(hook);
    }

    public boolean removeHook(Class<? extends Hook> hook) {
        Iterator<Hook> hookIterator = this.protectionHooks.iterator();
        while (hookIterator.hasNext()) {
            if (!hookIterator.next().getClass().equals(hook)) continue;
            hookIterator.remove();
            return true;
        }
        return false;
    }

    public boolean removeHook(Hook hook) {
        return this.protectionHooks.remove(hook);
    }

    public ChunkFlagger getFlagger() {
        return this.chunkFlagger;
    }

    DebugListener getDebugListener() {
        return this.debugListener;
    }

    public boolean isPaused() {
        return this.paused.get();
    }

    public void setPaused(boolean paused) {
        boolean wasPaused = this.paused.getAndSet(paused);
        if (paused == wasPaused) {
            return;
        }
        Consumer<Phaser> phaserConsumer = paused ? Phaser::register : Phaser::arriveAndDeregister;
        this.deletionRunnables.values().stream().map(DeletionRunnable::getPhaser).forEach(phaserConsumer);
    }

    public boolean debug(DebugLevel level) {
        return this.config.getDebugLevel().ordinal() >= level.ordinal();
    }

    public void debug(DebugLevel level, Supplier<String> message) {
        if (this.debug(level)) {
            this.getLogger().info(message.get());
        }
    }

    public void debug(DebugLevel level, Runnable runnable) {
        if (this.debug(level)) {
            runnable.run();
        }
    }

    public void debug(Supplier<String> message, Throwable throwable) {
        if (this.debug(DebugLevel.MEDIUM)) {
            this.getLogger().log(Level.WARNING, message.get(), throwable);
        } else if (this.debug(DebugLevel.LOW)) {
            this.getLogger().log(Level.WARNING, message.get());
        }
    }
}

